from setuphelpers import *
import waptlicences


def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    update_dict = {"windows": ".exe"}
    download_url = "https://packages.element.io/desktop/install/win32/x64/Element%20Setup.exe"

    latest_bin = download_url.rsplit("/")[-1].replace("%20","")

    version_url = "https://api.github.com/repos/element-hq/element-web/releases/latest"


    # Getting latest version information from official sources

    json_load = wgets(version_url, proxies=proxies, as_json=True)
    version = json_load["tag_name"].replace("v", "").replace(".windows", "")

    # Downloading latest binaries
    print(f"Latest version of {control.name} is: {version}")
    print("Download URL is: %s" % download_url)
    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(download_url, latest_bin, proxies=proxies)
    else:
        print("Binary is present: %s" % latest_bin)

    
    # Check signature bin
    expected_issuer = 'NEW VECTOR LTD'
    sign_name = waptlicences.check_exe_signing_certificate(latest_bin)[0]
    if sign_name != expected_issuer:
        error('Bad issuer %s != %s ' % (sign_name,expected_issuer))



    # Changing version of the package
    if Version(version) > Version(control.get_software_version()):
        print(f"Software version updated (from: {control.get_software_version()} to: {Version(version)})")
        package_updated = True
    else:
        print(f"Software version up-to-date ({Version(version)})")

    # Deleting binaries
    for f in glob.glob("*.exe"):
        if f != latest_bin:
            remove_file(f)
    
    control.set_software_version(version)
    control.save_control_to_wapt()

    return package_updated
