# -*- coding: utf-8 -*-
from setuphelpers import *
import time

element_install_dir = makepath(programfiles32, "element_install")
element_install_path = makepath(element_install_dir, "ElementSetup.exe")


def install():
    mkdirs(element_install_dir)
    filecopyto("ElementSetup.exe", element_install_path)
    element_squirrel_remove()


def session_setup():
    
    programdata_user_dir = makepath(programdata, get_current_user)
    programdata_app_dir = makepath(programdata_user_dir, "Element")

    if isdir(programdata_app_dir):
        if not isfile(makepath(programdata_app_dir, ".dead")):
            try:
                app_uninstall_cmd = rf'"{programdata_app_dir}\Update.exe" --uninstall -s'
                run(app_uninstall_cmd)
            except:
                print("Unable to remove Element in: %s" % programdata_app_dir)
        remove_tree(programdata_app_dir)

    if dir_is_empty(programdata_user_dir):
        remove_tree(programdata_user_dir)

    # Install app
    user_app_dir = makepath(user_local_appdata, "Element")
    element_versions = glob.glob(makepath(user_app_dir, "**/ElementSetup.exe"))
    if element_versions:
        element_version = "1.0"
        for d in element_versions:
            if Version(get_file_properties(d)["ProductVersion"]) > Version(element_version):
                element_version = get_file_properties(d)["ProductVersion"]
        if Version(control.get_software_version()) > Version(element_version):
            run('"%s"' % element_install_path)
        else:
            print("Element already up-to-date (%s)" % element_version)
    else:
        run('"%s"' % element_install_path + " --silent")


    # Element interact differently if user is admin
    if running_as_admin():
        element_squirrel_remove()


def uninstall():
    if isdir(element_install_dir):
        remove_tree(element_install_dir)
    element_squirrel_remove()


    # if element was uninstalled a .dead file is left behind to prevent automatic reinstall
    for user_dir in glob.glob(makepath(systemdrive, "Users", "*")):
        # "C:\Users\username\AppData\Local\element-desktop\Update.exe"
        local_appdata_app_dir = makepath(user_dir, "AppData", "Local", "element-desktop")
        if isdir(local_appdata_app_dir):
            if not isfile(makepath(local_appdata_app_dir, ".dead")):
                try:
                    app_uninstall_cmd = rf'"{local_appdata_app_dir}\Update.exe" --uninstall -s'
                    print(app_uninstall_cmd)
                    run(app_uninstall_cmd)
                except:
                    print("Unable to remove Element for user: %s" % user_dir.split(os.sep)[-1])
            remove_tree(local_appdata_app_dir)

        # "C:\Users\jpadmin\AppData\Roaming\Microsoft\Windows\Start Menu\Programs\Element Inc"
        start_shortcut = makepath(user_dir, r"AppData\Roaming\Microsoft\Windows\Start Menu\Programs\Element")
        desktop_shortcut = makepath(user_dir, r"Desktop\Element.lnk")
        if isfile(desktop_shortcut):
            remove_file(desktop_shortcut)
        if isdir(start_shortcut):
            remove_tree(start_shortcut)


def element_squirrel_remove():
    squirrel_dir = makepath(programdata, "SquirrelMachineInstalls")
    element_old_installer = makepath(programdata, "Element.exe")
    if isfile(element_old_installer):
        remove_file(element_old_installer)
    if dir_is_empty(squirrel_dir):
        remove_tree(squirrel_dir)

