# -*- coding: utf-8 -*-
from setuphelpers import *


def update_package():
    # Initializing variables
    bin_contains = "eclipse-jee-"

    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
        app_name = control.name
        url = "https://www.eclipse.org/downloads/packages"
        if control.architecture == "x64":
            arch = "64bits"
        else:
            arch = "32bits"
    # www.eclipse.org/downloads/download.php?file=/technology/epp/downloads/release/2021-03/R/eclipse-jee-2021-03-R-win32-x86_64.zip
    # Getting latest version from official sources

    print("URL used is: %s" % url)
    for bs_search in bs_find_all(url, "a", "title", "Eclipse IDE for Enterprise Java and Web Developers", proxies=proxies):
        if "eclipse-ide-enterprise" in bs_search["href"]:
            url2 = "https://www.eclipse.org" + bs_search["href"]
            print("URL used is: %s" % url)
            break
    version = url2.split("/")[-3]
    url_dl = "https://ftp.snt.utwente.nl/pub/software/eclipse/technology/epp/downloads/release/%s/R/eclipse-jee-%s-R-win32-x86_64.zip" % (version, version)
    version = version.replace("-", ".")
    latest_bin = url_dl.split("/")[-1]
    print("Latest %s version is: %s" % (app_name, version))
    print("Download url is: %s" % url_dl)

    # Downloading latest binaries
    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(url_dl, bin_contains + version + ".zip", proxies=proxies)

    # Changing version of the package
    if Version(version) > Version(control.get_software_version()):
        print("Software version updated (from: %s to: %s)" % (control.get_software_version(), Version(version)))
        result = True
    else:
        print("Software version up-to-date (%s)" % Version(version))
    control.version = "%s-%s" % (Version(version), control.version.split("-", 1)[-1])
    # control.set_software_version(version)
    control.save_control_to_wapt()

    # Deleting outdated binaries
    remove_outdated_binaries(version)
