# -*- coding: utf-8 -*-
from setuphelpers import *

app_name = "Eclipse Java EE"
app_dir = makepath(programfiles32, "eclipse")
app_path = makepath(app_dir, "eclipse.exe")


def install():
    # Declaring local variables
    bin_contains = "eclipse-jee-"

    package_version = control.get_software_version()
    bin_name = glob.glob("*%s*.zip" % bin_contains)[0]

    # Getting installed software version
    if isfile(app_path):
        for entry in installed_softwares("Eclipse Java EE"):
            installed_version = entry["version"]
    else:
        installed_version = None

    # Installing software
    print("Installing: %s" % app_name)
    if installed_version is None or installed_version < package_version or force:
        killalltasks(control.get_impacted_process_list())
        time.sleep(2)
        if isdir(app_dir):
            remove_tree(app_dir)
        mkdirs(app_dir)
        print("Extracting: %s to: %s" % (bin_name, app_dir))
        unzip(bin_name, programfiles32)

        # Creating shortcuts
        create_desktop_shortcut(app_name, app_path)
        create_programs_menu_shortcut(app_name, app_path)

        # Adding software to "list-registry"
        register_windows_uninstall(control, win64app=False)
    else:
        print("%s already installed. Skipping" % app_name)


def uninstall():
    # Uninstalling software
    killalltasks(control.get_impacted_process_list())
    if isdir(app_dir):
        remove_tree(app_dir)
    unregister_uninstall(app_name)

    # Removing shortcuts
    remove_desktop_shortcut(app_name)
    remove_programs_menu_shortcut(app_name)


def audit():
    # Declaring local variables
    package_version = control.get_software_version()

    # Getting installed software version
    if isfile(app_path):
        for entry in installed_softwares("Eclipse Java EE"):
            installed_version = entry["version"]
    else:
        installed_version = None

    # Auditing software
    print("Auditing: %s" % control.package)
    if installed_version is None or installed_version < package_version:
        print("%s version is incorrect (%s)" % (app_name, installed_version))
        return "ERROR"
    else:
        print("%s is installed in correct version (%s)" % (app_name, installed_version))
        return "OK"
