# -*- coding: utf-8 -*-
from setuphelpers import *
import re
import zipfile


def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    dict_arch = {
        "x64" :"-windows-x64",
        "x86"  : "-windows-x32"

    }
    
    git_repo = "DuckieTV/Nightlies"
    url_api = "https://api.github.com/repos/%s/releases/latest" % git_repo
    # Getting latest version information from official sources
    print("API used is: %s" % url_api)
    json_load = json.loads(wgets(url_api, proxies=proxies))

    for download in json_load["assets"]:
        if download["browser_download_url"].endswith(".zip") and dict_arch[control.architecture] in download["browser_download_url"] :
            url_dl = download["browser_download_url"]
            version = json_load["tag_name"].split("-")[-1]
            filename = download["name"]
            break

    if not isfile(filename):
        package_updated = True
        wget(url_dl,filename,proxies=proxies)

     # Extract .exe from downloaded .zip
    with zipfile.ZipFile(filename, 'r') as zip_ref:
        zip_ref.extractall('.')
        # Assuming the .exe file is extracted to the current directory, adjust as needed
        extracted_files = zip_ref.namelist()
        exe_file = next((f for f in extracted_files if f.endswith('.exe')), None)
        if exe_file:
            # Optionally move or do something with the extracted .exe file
            # For example, you could move it to a specific directory
            os.rename(exe_file, f'./{exe_file}')   
             
    # Clean up the downloaded .zip file
    if isfile(filename):
        remove_file(filename)
    
    #nettoyer les fichiers temporaires
    for f in glob.glob('*.exe'):
        if f != exe_file:
            remove_file(f)
    
    control.set_software_version(version)
    control.save_control_to_wapt()