# -*- coding: utf-8 -*-
from setuphelpers import *
import glob
import re

r"""
Usable WAPT package functions: install(), uninstall(), session_setup(), audit(), update_package()
{
   "key":"DuckieTV",
   "name":"DuckieTV",
   "version":"",
   "install_date":"",
   "install_location":"",
   "uninstall_string":"C:\\Users\\Administrator\\AppData\\Roaming\\DuckieTV\\uninstall.exe",
   "publisher":"",
   "system_component":0,
   "win64":false
  }
"""

def install():
    # Finding the executable with the version in its name
    bin_name = glob.glob('DuckieTV-*-windows-x64.exe')[0]
    
    # Extracting version from the filename using regex
    version = re.search(r'DuckieTV-([\d.]+)-windows-x64\.exe', bin_name).group(1)
    
    # Logging the extracted version for debugging purposes
    print(f"Extracted version from filename: {version}")
    
    # Installing the software
    install_exe_if_needed(
        bin_name,
        silentflags='/S',
        key='DuckieTV',
        min_version=version,
        get_version=lambda _: version,  # Lambda function that returns the extracted version
        timeout=600,
    )

# Function to set the version in the registry after installation
def get_version(app_registry_dict):
    # Return the default version if not found to force installation
    return app_registry_dict.get("version", "0.0.0.0")
