# -*- coding: utf-8 -*-
from setuphelpers import *
import time


def install():
    # Initializing variables
    package_version = control.version.split("-", 1)[0]
    bin_name = glob.glob("Dropbox*.exe")[0]
    app_uninstallkey = "Dropbox"

    # Installing the software
    if need_install(key=app_uninstallkey, min_version=package_version):
        install_exe_if_needed(
            bin_name,
            silentflags="/S",
            key=app_uninstallkey,
            min_version=package_version,
            timeout=600,
        )
        time.sleep(10)

    # Uninstalling Updater
    app_updater_key = "{099218A5-A723-43DC-8DB5-6173656A1E94}"
    wait_uninstallkey_present(app_updater_key, 10)
    if uninstall_key_exists(app_updater_key):
        run(uninstall_cmd(app_updater_key))
        wait_uninstallkey_absent(app_updater_key)
        time.sleep(10)

    # Disabling app autoupdater
    for task in ["DropboxUpdateTaskMachineCore", "DropboxUpdateTaskMachineUA"]:
        if task_exists(task):
            try:
                run_notfatal(r'schtasks /end /TN "%s"' % task)
                disable_task(task)
            except:
                print("Unable to disable the task: %s" % task)

    set_service_start_mode("dbupdate", "Disabled")
    set_service_start_mode("dbupdatem", "Disabled")

    # app_update_dir = makepath(programfiles32, "Dropbox", "Update")
    # if isdir(app_update_dir):
    #     run_notfatal("net stop DbxSvc")
    #     # PermissionError: [WinError 32] The process cannot access the file because it is being used by another process: 'C:\\Program Files (x86)\\Dropbox\\Update\\Install\\{60588C10-7A38-4A17-9D5F-41029BD94763}\\DropboxClient_172.4.7555.x64.exe'
    #     killalltasks(
    #         control.get_impacted_process_list()
    #         + [bin_name]
    #         + glob.glob(makepath(programfiles32, "Dropbox", "Update", "**", "Dropbox*.exe"))
    #         + glob.glob(makepath(programfiles32, "Dropbox", "Update", "Dropbox*.exe"))
    #     )
    #     run(r'icacls "%s" /grant "%s:(F)" /T' % (app_update_dir, get_user_from_sid("S-1-5-18")))
    #     remove_tree(app_update_dir)
    #     run_notfatal("net start DbxSvc")

    # Changing default start mode of the application services if allowed
    if params.get("disable_autostart_dropbox_service"):
        set_service_start_mode("DbxSvc", "Manual")
    else:
        set_service_start_mode("DbxSvc", "Auto")

    # Disabling app autorun if allowed
    if params.get("disable_autostart_dropbox"):
        if iswin64():
            app_autorun_reg_path = r"SOFTWARE\WOW6432Node\Microsoft\Windows\CurrentVersion\Run"
        else:
            app_autorun_reg_path = r"SOFTWARE\Microsoft\Windows\CurrentVersion\Run"
        if reg_value_exists(HKEY_LOCAL_MACHINE, app_autorun_reg_path, "Dropbox"):
            registry_delete(HKEY_LOCAL_MACHINE, app_autorun_reg_path, "Dropbox")

# def uninstall():
#     for to_uninstall in installed_softwares("Dropbox"):
#         print("Removing: %s (%s)" % (to_uninstall["name"], to_uninstall["version"]))
        #killalltasks(ensure_list(control.impacted_process))
        # run(uninstall_cmd(to_uninstall["key"]))
        # wait_uninstallkey_absent(to_uninstall["key"])
        # if isdir(to_uninstall["C:\Program Files (x86)\Dropbox"]):
        #     remove_tree("C:\Program Files (x86)\Dropbox")