# -*- coding: utf-8 -*-
from setuphelpers import *
import requests


def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    app_name = control.name
    download_url = "https://www.dropbox.com/download?plat=win&type=full"

    # Getting latest version information from download url
    if control.architecture == "x64":
        download_url = requests.head(download_url, proxies=proxies).headers["Location"].replace("x86", "x64")
    else:
        download_url = requests.head(download_url, proxies=proxies).headers["Location"]
    latest_bin = download_url.rsplit("/", 1)[1].replace("%20", " ")
    version = latest_bin.split(" ")[1]

    # Downloading latest binaries
    print("Latest %s version is: %s" % (app_name, version))
    print("Download URL is: %s" % download_url)
    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(download_url, latest_bin, proxies=proxies)
    else:
        print("Binary is present: %s" % latest_bin)

    # Changing version of the package
    if Version(version) > Version(control.get_software_version()):
        print("Software version updated (from: %s to: %s)" % (control.get_software_version(), Version(version)))
        package_updated = True
    else:
        print("Software version up-to-date (%s)" % Version(version))
    control.set_software_version(version)
    control.save_control_to_wapt()

    # Deleting outdated binaries
    remove_outdated_binaries(version)

    # Validating or not update-package-sources
    return package_updated
