# -*- coding: utf-8 -*-
from setuphelpers import *
import requests


def update_package():
    # Declaring local variables
    result = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    app_name = control.name
    download_url = "https://www.dropbox.com/download?plat=mac&type=full"

    # Getting latest version from official website
    download_url = requests.head(download_url, proxies=proxies).headers["Location"]
    latest_bin = download_url.rsplit("/", 1)[1].replace("%20", "_")
    version = latest_bin.split("_")[1].replace(".dmg", "")

    print("Latest %s version is: %s" % (app_name, version))
    print("Download URL is: %s" % download_url)

    # Downloading latest binaries
    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(download_url, latest_bin, proxies=proxies)

    # Changing version of the package
    if Version(version) > Version(control.get_software_version()):
        print("Software version updated (from: %s to: %s)" % (control.get_software_version(), Version(version)))
        result = True
    else:
        print("Software version up-to-date (%s)" % Version(version))

    control.version = "%s-%s" % (Version(version), control.version.split("-", 1)[-1])
    # control.set_software_version(version)
    control.save_control_to_wapt()

    for f in glob.glob("*.dmg"):
        if f != latest_bin:
            remove_file(f)

    # Validating update-package-sources
    return result
