# -*- coding: utf-8 -*-
from setuphelpers import *
from setupdevhelpers import *
import waptlicences


def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    app_name = control.name
    
    api_url = "https://api.github.com/repos/jgraph/drawio-desktop/releases/latest"
    
    print(f"API used is: {api_url}")
    json_load = wgets(api_url, proxies=proxies, as_json=True)
    version = json_load["tag_name"].replace("v", "").replace(".windows", "")

    download_dict = {
        "windows-x64": f"draw.io-{version}-windows-installer.exe",
        "windows-x86": f"draw.io-ia32-{version}-windows-32bit-installer.exe",
        "windows-arm": f"draw.io-arm64-{version}-windows-arm64-installer.exe",
        "debian_based-x64": f"drawio-amd64-{version}.deb",
        "debian_based-arm64": f"drawio-arm64-{version}.deb",
        "redhat_based-x64": f"drawio-x86_64-{version}.rpm",
        "darwin-x64": f"draw.io-x64-{version}.dmg",
        "darwin-arm64": f"draw.io-arm64-{version}.dmg",
    }
    os_type = control.target_os + "-" + ensure_list(control.architecture)[0]

    for asset in json_load["assets"]:
        if asset["name"] == download_dict[os_type]:
            download_url = asset["browser_download_url"]
            latest_bin = asset["name"]
            latest_bin_extension = latest_bin.rsplit('.', 1)[-1]
            break

    # Downloading latest binaries
    print(f"Latest {app_name} version is: {version}")
    print(f"Download URL is: {download_url}")
    if not isfile(latest_bin):
        print(f"Downloading: {latest_bin}")
        wget(download_url, latest_bin, proxies=proxies)
    else:
        print(f"Binary is present: {latest_bin}")

    # Changing version of the package
    if Version(version) > Version(control.get_software_version()):
        print(f"Software version updated (from: {control.get_software_version()} to: {Version(version)})")
        package_updated = True
    else:
        print(f"Software version up-to-date ({Version(version)})")

    for f in glob.glob(f'*.{latest_bin_extension}'):
        if f != latest_bin:
            remove_file(f)

    control.set_software_version(version)
    control.save_control_to_wapt()

    return package_updated