# -*- coding: utf-8 -*-
from setuphelpers import *


def install():
    bin_name = glob.glob("draw.io*.exe")[0]
    install_exe_if_needed(
        bin_name,
        silentflags="/S",
        key="27a75bf3-be48-5c35-934f-8491cf108abe",
        min_version=control.get_software_version(),
    )

    # Removing desktop shortcut if allowed
    if params.get("remove_desktop_shortcut"):
        remove_desktop_shortcut("draw.io")

    # Disable auto update
    set_environ_variable("DRAWIO_DISABLE_UPDATE", "true")
