# -*- coding: utf-8 -*-
from setuphelpers import *

bin_path = makepath("/","usr","local","bin")
install_dir = "/opt"

def install():
    # Declaring local variables
    bin_name = glob.glob(f"doxygen-*.linux.bin.tar.gz")[0]

    # Installing the software 
    run(f"tar -xf {bin_name} -C {install_dir}")
    app_dir = makepath(install_dir,bin_name.split(".linux.bin.tar.gz")[0])

    # Creation of symlink 
    if not isfile(f"{bin_path}/doxygen") :
        print("Create doxygen alias in path")
        os.symlink(f"{app_dir}/bin/doxygen", f"{bin_path}/doxygen")

def uninstall():
    version = control.get_software_version()


    if isfile(f"{bin_path}/doxygen"):
        remove_file(f"{bin_path}/doxygen")
    if isdir(f"/opt/doxygen-{version}") :
        remove_tree(f"/opt/doxygen-{version}")




