# -*- coding: utf-8 -*-
from setuphelpers import *
from setupdevhelpers import *


def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    dotnet_version = ".".join(control.get_software_version().split(".")[:2])

    architecture = ensure_list(control.architecture)
    if "arm64" in architecture:
        archs = ["x86", "x64", "arm64"]
    elif "x64" in architecture:
        archs = ["x86", "x64"]
    else:
        archs = ["x86"]
        
    url = "https://dotnet.microsoft.com/en-us/download/dotnet/%s" % dotnet_version

    for arch in archs:
        # Getting latest version from official sources
        print("URL used is: %s" % url)
        for bs_search in bs_find_all(url, "a", "data-bi-dlnm", ".NET Release Table Download", proxies=proxies, timeout=10):
            if "runtime-desktop-" in bs_search.get("href", "") and arch in bs_search.get("href", ""):
                download_url_page = "https://dotnet.microsoft.com" + bs_search["href"]
                version = download_url_page.split("/")[-1].split("-")[2]
                break

        for bs_search in bs_find_all(download_url_page, "a", "onclick", "recordManualDownload()"):
            if version in bs_search.get("href", "") and "windowsdesktop-runtime" in bs_search.get("href", ""):
                download_url = bs_search["href"]
                latest_bin = download_url.split("/")[-1]
                break

        # Downloading latest binaries
        print("Latest %s version is: %s" % (control.name, version))
        print("Download URL is: %s" % download_url)
        if not isfile(latest_bin):
            print("Downloading: %s" % latest_bin)
            wget(download_url, latest_bin, proxies=proxies)

        # Checking version from file
        if get_os_name() == "Windows" and "windows" in control.target_os.lower():
            version_from_file = get_version_from_binary(latest_bin)
            if Version(version_from_file, 3) == Version(version, 3):
                print(f"INFO: Binary file version ({version_from_file}) corresponds to online version ({version})")
            else:
                error(f"ERROR: Binary file version ({version_from_file}) do NOT corresponds to online version ({version})")

    # Deleting outdated binaries
    remove_outdated_binaries(version)

    # Changing version of the package
    if Version(version, 4) > Version(control.get_software_version(), 4):
        print("Software version updated (from: %s to: %s)" % (control.get_software_version(), Version(version)))
        package_updated = True
    else:
        print("Software version up-to-date (%s)" % Version(version))
    control.set_software_version(version)
    control.save_control_to_wapt()

    # Validating or not update-package-sources
    return package_updated