# -*- coding: utf-8 -*-
from setuphelpers import *

"""
[
  {
   "key":"{0B5020E1-CF85-4FA5-8DD2-CBCFB93ACEA9}",
   "name":"Microsoft .NET Host - 9.0.0 (x64)",
   "version":"72.0.23369",
   "install_date":"2024-12-13 00:00:00",
   "install_location":"",
   "uninstall_string":"MsiExec.exe /X{0B5020E1-CF85-4FA5-8DD2-CBCFB93ACEA9}",
   "publisher":"Microsoft Corporation",
   "system_component":1,
   "win64":true
  },
  {
   "key":"{2638EC94-B0DB-4B3D-9948-85D13BBA0108}",
   "name":"Microsoft .NET Host FX Resolver - 9.0.0 (x64)",
   "version":"72.0.23369",
   "install_date":"2024-12-13 00:00:00",
   "install_location":"",
   "uninstall_string":"MsiExec.exe /X{2638EC94-B0DB-4B3D-9948-85D13BBA0108}",
   "publisher":"Microsoft Corporation",
   "system_component":1,
   "win64":true
  },
  {
   "key":"{996933AF-600E-4B1B-82EC-64D18AEC3219}",
   "name":"Microsoft .NET Runtime - 9.0.0 (x64)",
   "version":"72.0.23369",
   "install_date":"2024-12-13 00:00:00",
   "install_location":"",
   "uninstall_string":"MsiExec.exe /X{996933AF-600E-4B1B-82EC-64D18AEC3219}",
   "publisher":"Microsoft Corporation",
   "system_component":1,
   "win64":true
  },
  {
   "key":"{06DEC9B9-0A81-4E8C-9BE0-3008E1F4F9B8}",
   "name":"Microsoft .NET Host - 9.0.0 (x86)",
   "version":"72.0.23369",
   "install_date":"2024-12-13 00:00:00",
   "install_location":"",
   "uninstall_string":"MsiExec.exe /X{06DEC9B9-0A81-4E8C-9BE0-3008E1F4F9B8}",
   "publisher":"Microsoft Corporation",
   "system_component":1,
   "win64":false
  },
  {
   "key":"{9A1BB4C9-0E9A-4E16-AF28-578656B5632C}",
   "name":"Microsoft .NET Runtime - 9.0.0 (x86)",
   "version":"72.0.23369",
   "install_date":"2024-12-13 00:00:00",
   "install_location":"",
   "uninstall_string":"MsiExec.exe /X{9A1BB4C9-0E9A-4E16-AF28-578656B5632C}",
   "publisher":"Microsoft Corporation",
   "system_component":1,
   "win64":false
  },
  {
   "key":"{C4263979-BE2D-41F5-AB69-D6EE2D5503BD}",
   "name":"Microsoft .NET Host FX Resolver - 9.0.0 (x86)",
   "version":"72.0.23369",
   "install_date":"2024-12-13 00:00:00",
   "install_location":"",
   "uninstall_string":"MsiExec.exe /X{C4263979-BE2D-41F5-AB69-D6EE2D5503BD}",
   "publisher":"Microsoft Corporation",
   "system_component":1,
   "win64":false
  }
]


"""


def install():
    dotnet_version = control.get_software_version().split(".")[0]

    # Installing the software
    silentflags = "/install /quiet /norestart"
    if iswin64():
        install_exe_if_needed(
            glob.glob("windowsdesktop-runtime-*x64.exe")[0],
            silentflags=silentflags,
            name=f"Microsoft Windows Desktop Runtime - {dotnet_version}.*(x64)",
            min_version="",
            force=True,  # force option, since the version is not easy to check, and the installer will take care of it.
        )
    install_exe_if_needed(
        glob.glob("windowsdesktop-runtime-*x86.exe")[0],
        silentflags=silentflags,
        name=f"Microsoft Windows Desktop Runtime - {dotnet_version}.*(x86)",
        min_version="",
        force=True,  # force option, since the version is not easy to check, and the installer will take care of it.
    )

    # Clear uninstallkey to avoid the no-code audit and uninstall
    uninstallkey.clear()


def audit():
    # Declaring local variables
    audit_result = "OK"
    dotnet_version = control.get_software_version().split(".")[0]
    app_check = installed_softwares(name=f"Microsoft Windows Desktop Runtime - {dotnet_version}.*")
    audit_version = True

    # Auditing software
    if not app_check:
        print("%s is not installed" % control.package.split("-", 1)[-1].replace("-", " ").title())
        audit_result = "ERROR"
    elif audit_version:
        for to_audit in app_check:
            if r"ProgramData\Package Cache" in to_audit["uninstall_string"]:
                if Version(to_audit["version"]) < Version(control.get_software_version()):
                    print(f'{to_audit["name"]} is installed in version: {to_audit["version"]} instead of: {control.get_software_version()}.')
                    audit_result = "WARNING"
                else:
                    print("%s is installed and up-to-date." % to_audit["name"])

    return audit_result


def uninstall():
    # Declaring local variables
    dotnet_version = control.get_software_version().split(".")[0]

    for to_uninstall in installed_softwares(name=f"Microsoft Windows Desktop Runtime - {dotnet_version}.*"):
        if r"ProgramData\Package Cache" in to_uninstall["uninstall_string"]:
            print("Removing: %s (%s)" % (to_uninstall["name"], to_uninstall["version"]))
            killalltasks(ensure_list(control.impacted_process))
            run(uninstall_cmd(to_uninstall["key"]) + " /norestart")
            wait_uninstallkey_absent(to_uninstall["key"])
            if isdir(to_uninstall["install_location"]):
                remove_tree(to_uninstall["install_location"])
