# -*- coding: utf-8 -*-
from setuphelpers import *

"""
[
    {
        "key": "{113C0ADC-B9BD-4F95-9653-4F5BC540ED03}",
        "name": "Microsoft Windows Desktop Runtime - 8.0.0 (x64)",
        "version": "64.0.5329",
        "install_date": "2023-11-27 00:00:00",
        "install_location": "",
        "uninstall_string": "MsiExec.exe /X{113C0ADC-B9BD-4F95-9653-4F5BC540ED03}",
        "publisher": "Microsoft Corporation",
        "system_component": 0,
        "win64": true,
    },
    {
        "key": "{3A706840-2882-423C-90EB-B31545E2BC7A}",
        "name": "Microsoft .NET Host FX Resolver - 8.0.0 (x64)",
        "version": "64.0.4211",
        "install_date": "2023-11-27 00:00:00",
        "install_location": "",
        "uninstall_string": "MsiExec.exe /X{3A706840-2882-423C-90EB-B31545E2BC7A}",
        "publisher": "Microsoft Corporation",
        "system_component": 0,
        "win64": true,
    },
    {
        "key": "{76DEEAB3-122F-4231-83C7-0C35363D02F9}",
        "name": "Microsoft .NET Runtime - 8.0.0 (x64)",
        "version": "64.0.4211",
        "install_date": "2023-11-27 00:00:00",
        "install_location": "",
        "uninstall_string": "MsiExec.exe /X{76DEEAB3-122F-4231-83C7-0C35363D02F9}",
        "publisher": "Microsoft Corporation",
        "system_component": 0,
        "win64": true,
    },
    {
        "key": "{D44822A8-FC28-42FC-8B1D-21A78579FC79}",
        "name": "Microsoft .NET Host - 8.0.0 (x64)",
        "version": "64.0.4211",
        "install_date": "2023-11-27 00:00:00",
        "install_location": "",
        "uninstall_string": "MsiExec.exe /X{D44822A8-FC28-42FC-8B1D-21A78579FC79}",
        "publisher": "Microsoft Corporation",
        "system_component": 0,
        "win64": true,
    },
    {
        "key": "{17316079-d65a-4f25-a9f3-56c32781b15d}",
        "name": "Microsoft Windows Desktop Runtime - 8.0.0 (x64)",
        "version": "8.0.0.33101",
        "install_date": "",
        "install_location": "",
        "uninstall_string": '"C:\\ProgramData\\Package Cache\\{17316079-d65a-4f25-a9f3-56c32781b15d}\\windowsdesktop-runtime-8.0.0-win-x64.exe"  /uninstall',
        "publisher": "Microsoft Corporation",
        "system_component": 0,
        "win64": false,
    },
    {
        "key": "{51CB5CFD-606C-4C2E-A21B-23F99C7790A7}",
        "name": "Microsoft Windows Desktop Runtime - 8.0.0 (x86)",
        "version": "64.0.5329",
        "install_date": "2023-11-27 00:00:00",
        "install_location": "",
        "uninstall_string": "MsiExec.exe /X{51CB5CFD-606C-4C2E-A21B-23F99C7790A7}",
        "publisher": "Microsoft Corporation",
        "system_component": 0,
        "win64": false,
    },
    {
        "key": "{B3A56FDD-F6BC-482B-9DF5-2F8FA7759BE8}",
        "name": "Microsoft .NET Host - 8.0.0 (x86)",
        "version": "64.0.4211",
        "install_date": "2023-11-27 00:00:00",
        "install_location": "",
        "uninstall_string": "MsiExec.exe /X{B3A56FDD-F6BC-482B-9DF5-2F8FA7759BE8}",
        "publisher": "Microsoft Corporation",
        "system_component": 0,
        "win64": false,
    },
    {
        "key": "{BA833631-63DD-417E-9818-300E20051F1A}",
        "name": "Microsoft .NET Runtime - 8.0.0 (x86)",
        "version": "64.0.4211",
        "install_date": "2023-11-27 00:00:00",
        "install_location": "",
        "uninstall_string": "MsiExec.exe /X{BA833631-63DD-417E-9818-300E20051F1A}",
        "publisher": "Microsoft Corporation",
        "system_component": 0,
        "win64": false,
    },
    {
        "key": "{DA83EE57-3D79-4C50-A810-691E4CE72184}",
        "name": "Microsoft .NET Host FX Resolver - 8.0.0 (x86)",
        "version": "64.0.4211",
        "install_date": "2023-11-27 00:00:00",
        "install_location": "",
        "uninstall_string": "MsiExec.exe /X{DA83EE57-3D79-4C50-A810-691E4CE72184}",
        "publisher": "Microsoft Corporation",
        "system_component": 0,
        "win64": false,
    },
    {
        "key": "{ec1cadaa-4a22-4433-8eb8-d24a98c67492}",
        "name": "Microsoft Windows Desktop Runtime - 8.0.0 (x86)",
        "version": "8.0.0.33101",
        "install_date": "",
        "install_location": "",
        "uninstall_string": '"C:\\ProgramData\\Package Cache\\{ec1cadaa-4a22-4433-8eb8-d24a98c67492}\\windowsdesktop-runtime-8.0.0-win-x86.exe"  /uninstall',
        "publisher": "Microsoft Corporation",
        "system_component": 0,
        "win64": false,
    },
]


"""


def install():
    dotnet_version = control.get_software_version().split(".")[0]

    # Installing the software
    silentflags = "/install /quiet /norestart"
    if iswin64():
        install_exe_if_needed(
            glob.glob("windowsdesktop-runtime-*x64.exe")[0],
            silentflags=silentflags,
            name=f"Microsoft Windows Desktop Runtime - {dotnet_version}.*(x64)",
            min_version="",
            force=True,  # force option, since the version is not easy to check, and the installer will take care of it.
        )
    install_exe_if_needed(
        glob.glob("windowsdesktop-runtime-*x86.exe")[0],
        silentflags=silentflags,
        name=f"Microsoft Windows Desktop Runtime - {dotnet_version}.*(x86)",
        min_version="",
        force=True,  # force option, since the version is not easy to check, and the installer will take care of it.
    )

    # Clear uninstallkey to avoid the no-code audit and uninstall
    uninstallkey.clear()


def audit():
    # Declaring local variables
    audit_result = "OK"
    dotnet_version = control.get_software_version().split(".")[0]
    app_check = installed_softwares(name=f"Microsoft Windows Desktop Runtime - {dotnet_version}.*")
    audit_version = True

    # Auditing software
    if not app_check:
        print("%s is not installed" % control.package.split("-", 1)[-1].replace("-", " ").title())
        audit_result = "ERROR"
    elif audit_version:
        for to_audit in app_check:
            if r"ProgramData\Package Cache" in to_audit["uninstall_string"]:
                if Version(to_audit["version"]) < Version(control.get_software_version()):
                    print(f'{to_audit["name"]} is installed in version: {to_audit["version"]} instead of: {control.get_software_version()}.')
                    audit_result = "WARNING"
                else:
                    print("%s is installed and up-to-date." % to_audit["name"])

    return audit_result


def uninstall():
    # Declaring local variables
    dotnet_version = control.get_software_version().split(".")[0]

    for to_uninstall in installed_softwares(name=f"Microsoft Windows Desktop Runtime - {dotnet_version}.*"):
        if r"ProgramData\Package Cache" in to_uninstall["uninstall_string"]:
            print("Removing: %s (%s)" % (to_uninstall["name"], to_uninstall["version"]))
            killalltasks(ensure_list(control.impacted_process))
            run(uninstall_cmd(to_uninstall["key"]) + " /norestart")
            wait_uninstallkey_absent(to_uninstall["key"])
            if isdir(to_uninstall["install_location"]):
                remove_tree(to_uninstall["install_location"])
