# -*- coding: utf-8 -*-
from setuphelpers import *


def get_version(app_registry_dict):
    return app_registry_dict['version'].split(' ', 1)[0]


def add_leading_zero(version):
    return '.'.join([i.zfill(2) for i in version.split('.')])


def install():
    bin_name = glob.glob("dosbox-x-*.exe")[0]

    install_exe_if_needed(
        bin_name,
        name=f"DOSBox-X {add_leading_zero(control.get_software_version())} \(32\/64bit for Windows\)",
        silentflags="/VERYSILENT /SP- /SUPPRESSMSGBOXES",
        min_version=control.get_software_version(),
        get_version=get_version
    )