# -*- coding: utf-8 -*-
from setuphelpers import *


def update_package():
    # Declaring local variables
    bin_name_string = "dopdf-full-%s.exe"

    result = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    app_name = control.name
    url_dl = "https://download.dopdf.com/download/setup/dopdf-full.exe"

    # Getting latest informations from official website
    for bs_search in bs_find_all(control.sources, "span", proxies=proxies):
        if bs_search.text.startswith("Version:"):
            version = bs_search.text.split(" ")[2]
    
    print("Latest %s version is: %s" % (app_name, version))
    print("Download url is: %s" % url_dl)

    print("Downloading: dopdf-full.exe")
    wget(url_dl, "dopdf-full.exe", proxies=proxies)

    # Checking version from file
    version_from_file = get_version_from_binary("dopdf-full.exe")
    if Version(version) != Version(version_from_file) and version_from_file != "":
        print("Changing version to the version number of the binary (from: %s to: %s)" % (version, version_from_file))
        version = version_from_file
    else:
        print("Binary file version corresponds to online version")

    filecopyto("dopdf-full.exe", bin_name_string % version_from_file)
    remove_file("dopdf-full.exe")

    # Changing version of the package
    if Version(version) > Version(control.get_software_version()):
        print("Software version updated (from: %s to: %s)" % (control.get_software_version(), Version(version)))
        result = True
    else:
        print("Software version up-to-date (%s)" % Version(version))
    control.version = "%s-%s" % (Version(version), control.version.split("-", 1)[-1])
    # control.set_software_version(version)
    control.save_control_to_wapt()

    # Deleting outdated binaries
    remove_outdated_binaries(version)

    # Validating or not update-package-sources
    return result
