# -*- coding: utf-8 -*-
from setuphelpers import *
import time
r"""
Usable WAPT package functions: install(), uninstall(), session_setup(), audit(), update_package()

https://forum.dopdf.com/general-f1/dopdf-10-silent-install-without-office-add-ins-t5476.html

"""
# Declaring global variables - Warnings: 1) WAPT context is only available in package functions; 2) Global variables are not persistent between calls
bin_name_string = "dopdf-full-%s.exe"
app_name = "doPDF"
# vstor_zip = "vstor_dopdf.zip"


def install():

    # Declaring local variables
    package_version = control.version.split("-", 1)[0]
    major_version = package_version.split(".")[0]
    bin_name = bin_name_string % package_version

    # Disabling Telemetry twice
    registry_setstring(HKEY_LOCAL_MACHINE, r"SOFTWARE\Softland\novaPDF %s\doPdf_Softland" % major_version, "SendTelemetry", "False")
    registry_setstring(HKEY_LOCAL_MACHINE, r"SOFTWARE\Softland\novaPDF %s\doPdf_Softland" % major_version, "ShowTrayIcon", "False")
    registry_setstring(HKEY_LOCAL_MACHINE, r"SOFTWARE\Softland\novaPDF %s\doPdf_Softland" % major_version, "AutomaticUpdate", "0")

    # Uninstall before if install forced
    if force:
        try:
            uninstall()
        except:
            print("WARNING: Uninstallation before installation do not complete")

    # App dependencies
    unzip("vstor_dopdf.zip", ".")
    install_exe_if_needed(r"vstor_dopdf\Setup.exe", "/q /norestart")
    set_service_start_mode("Spooler", "Auto")

    # Installing the software
    print("Installing: %s" % bin_name)
    install_exe_if_needed(
        bin_name,
        silentflags="/SILENT /VERYSILENT /SUPPRESSMSGBOXES /NOCANCEL /NORESTART",
        name=app_name,
        min_version=package_version,
        # timeout=300,
    )
    wait_uninstallkey_present(name=app_name)

    # Avoiding the usage by WAPT of the app built-in Uninstallstring
    uninstallkey.clear()

    # Disabling Telemetry twice
    registry_setstring(HKEY_LOCAL_MACHINE, r"SOFTWARE\Softland\novaPDF %s\doPdf_Softland" % major_version, "SendTelemetry", "False")
    registry_setstring(HKEY_LOCAL_MACHINE, r"SOFTWARE\Softland\novaPDF %s\doPdf_Softland" % major_version, "ShowTrayIcon", "False")
    registry_setstring(HKEY_LOCAL_MACHINE, r"SOFTWARE\Softland\novaPDF %s\doPdf_Softland" % major_version, "AutomaticUpdate", "0")


def uninstall():
    # Uninstalling the package
    for soft in installed_softwares(name=app_name):
        print("Removing: %s " % soft["name"])
        run_notfatal(WAPT.uninstall_cmd(soft["key"]))
        wait_uninstallkey_absent(soft["key"])
    if len(installed_softwares("dopdf")) != 0:
        error("ERROR: %s is not fully uninstalled" % app_name)


def session_setup():
    print("Disabling: Auto-update check")

    # Declaring local variables
    package_version = control.version.split("-", 1)[0]
    major_version = package_version.split(".")[0]

    registry_setstring(HKEY_CURRENT_USER, r"SOFTWARE\Softland\novaPDF %s\doPdf_Softland" % major_version, "AutomaticUpdate", "0")
    registry_setstring(HKEY_CURRENT_USER, r"SOFTWARE\Softland\novaPDF %s\doPdf_Softland" % major_version, "HideNews", "1")
    registry_setstring(HKEY_CURRENT_USER, r"SOFTWARE\Softland\novaPDF %s\doPdf_Softland" % major_version, "SendTelemetry", "True")
    # registry_delete(HKEY_CURRENT_USER, r'SOFTWARE\Softland\novaPDF %s\doPdf_Softland' % major_version, 'UpdateInterval')