# -*- coding: utf-8 -*-
from setuphelpers import *


def update_package():
    # Declaring local variables
    result = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    
    lang_dict = {'fr':'fr-FR',
    'en':'en-US'}
    lang = control.locale
    url_base = "https://download.scenari.software/Dokiel/?productInfos"
    response = requests.get(url_base, proxies=proxies, allow_redirects=True)
    response.raise_for_status()

    # Supposons que la réponse soit un JSON contenant les informations du produit
    product_info = response.json()
    
    # Trouve la version la plus récente dans la liste 'hist'
    version = product_info.get('v', [])
    # Compose l'URL dynamique avec la dernière version
    url_latest_version = f"https://download.scenari.software/Dokiel@{version}/?productInfos"    
    response = requests.get(url_latest_version, proxies=proxies, allow_redirects=True)
    response.raise_for_status()
    # Supposons que la réponse soit un JSON contenant les informations des fichiers
    product_files_info = response.json()
    # Rechercher le fichier .exe pour Windows correspondant à la langue de control.locale
    exe_file = None
    if 'ch' in product_files_info:
        for file in product_files_info['ch']:
            if isinstance(file, dict) and file['n'].endswith('.exe') and file['metas']['os'] == 'windows' and file['metas']['lang'] == lang_dict[control.locale]:
                exe_file = file['metas']['path']
                break
    

    url_download = f"https://download.scenari.software{exe_file}"
    filename = exe_file.split('/')[-1]
    if not isfile(filename):
        package_updated = True
        wget(url_download, filename, proxies=proxies)
        print("Téléchargé:", filename)


    for f in glob.glob("*.exe"):
        if f != filename:
            remove_file(f)
 
    version = str(Version(get_version_from_binary(filename).split('-')[0],3))

    control.set_software_version(version)
    control.save_control_to_wapt()
