# -*- coding: utf-8 -*-
from setuphelpers import *

r"""
Usable WAPT package functions: install(), uninstall(), session_setup(), audit(), update_package()
{
   "key":"b9fb4469-b524-5f97-9c5b-5dfcc39e8ef2",
   "name":"Dokiel 6",
   "version":"6.0.6-final.202404091417",
   "install_date":"",
   "install_location":"",
   "uninstall_string":"\"C:\\Program Files\\Dokiel 6\\Uninstall Dokiel 6.exe\" /allusers",
   "publisher":"scenari",
   "system_component":0,
   "win64":true
  }
"""
# Declaring global variables - Warnings: 1) WAPT context is only available in package functions; 2) Global variables are not persistent between calls


def install():
    # Declaring local variables
    bin_name = glob.glob('Dokiel*_win_x64.exe')[0]
    # Installing the software
    
    install_exe_if_needed(bin_name,
        silentflags='/S',
        name='Dokiel',
        min_version=control.get_software_version(),
        get_version=get_version,
        timeout=600,
    )

def uninstall():
    for to_uninstall in installed_softwares(name="Dokiel"):
        print(f"Removing: {to_uninstall['name']} ({to_uninstall['version']})")
        killalltasks(ensure_list(control.impacted_process))
        run(uninstall_cmd(to_uninstall["key"]))
        wait_uninstallkey_absent(to_uninstall["key"])


def get_version(app_registry_dict):
    return app_registry_dict["version"].split("-")[0]