# -*- coding: utf-8 -*-
from setuphelpers import *

"""


"""


app_name = "docker "
editor_dir = makepath(programfiles, "docker")
app_dir = makepath(editor_dir, "docker")
app_path = makepath(app_dir, "docker","docker.exe")
#icon_path = makepath(app_dir, "resources", "app", "build", "crushee.ico")   #tis-crushee\windows\crushee\resources\resources\build
audit_version = False


def get_installed_version(app_path):
    return get_file_properties(app_path).get("FileVersion", "")


def install():
    # Declaring local variables
    zip_name = glob.glob(f"docker-*.zip")[0]

    unzipped_dir = "docker"


    # Installing software
    killalltasks(ensure_list(control.impacted_process))
    if isdir(app_dir) and force:
        remove_tree(app_dir)
    mkdirs(app_dir)
    print("Extracting: %s to: %s" % (zip_name, unzipped_dir))
    unzip(zip_name, unzipped_dir)
    print('Copy docker to %s' % app_dir)
    copytree2(unzipped_dir, app_dir, onreplace=default_overwrite)

    # Creating custom shortcuts
    create_desktop_shortcut(app_name, target=app_path)
    create_programs_menu_shortcut(app_name, target=app_path)


def audit():
    # Auditing software
    audit_status = "OK"
    installed_version = get_installed_version(app_path)
    if Version(installed_version) < Version(control.get_software_version()) and audit_version:
        print("%s is installed in version (%s) instead of (%s)" % (app_name, installed_version, control.get_software_version()))
        audit_status = "WARNING"
    elif isdir(app_dir) and not dir_is_empty(app_dir):
        print("%s (%s) is installed" % (app_name, installed_version))
        audit_status = "OK"
    else:
        print("%s is not installed" % app_name)
        audit_status = "ERROR"
    return audit_status


def uninstall():
    # Uninstalling software
    killalltasks(ensure_list(control.impacted_process))
    if isdir(app_dir):
        remove_tree(app_dir)
    if dir_is_empty(editor_dir):
        remove_tree(editor_dir)

    # Removing shortcuts
    remove_desktop_shortcut(app_name)
    remove_programs_menu_shortcut(app_name)