# -*- coding: utf-8 -*-
from setuphelpers import *
from setupdevhelpers import *
import os


def update_package():
    install_apt('python3-pip')
    install_apt('git')

    for u in ['master','2.7-jarnaud']:

        if isdir("/tpm/doc-wapt"):
            remove_tree('/tpm/doc-wapt')

        run(fr'git clone --branch %s https://gitea.ad.tranquil.it/doc/doc-wapt.git /tpm/doc-wapt' % u)

        olddir = os.getcwd()
        os.chdir('/tpm/doc-wapt')

        run("make clean")
        run("rm -Rf ./build/")
        run("pip3 install -U setuptools --break-system-packages")
        run("pip3 install -r requirements.txt --upgrade --break-system-packages")
        run("make gettext")
        run("sphinx-intl update -p build/locale/ -l fr")
        run("make clean")
        run("make htmlen")
        run('make -e SPHINXOPTS="-D language=\'fr\'" htmlfr')

        os.chdir(olddir)

        copytree2('/tpm/doc-wapt/build','build-%s' % u)
