// Permet de basculer de mode selon l'OS par defaut de l'utilisateur final
// Si elle a le mode sombre de Windows alors elle verra la doc la première fois avec le mode dark mais si ensuite elle la modifie à la main cela sera conservé

document.addEventListener("DOMContentLoaded", function () {
    const themeToggle = document.querySelector('[data-md-toggle="theme"]');

    // Fonction pour appliquer le thème
    function applyTheme(theme) {
        document.body.setAttribute("data-theme", theme);
        if (themeToggle) {
            themeToggle.setAttribute("aria-pressed", theme === "dark");
        }
    }

    // Vérifie si un thème est enregistré dans le localStorage
    const userTheme = localStorage.getItem("theme");

    if (userTheme === "light" || userTheme === "dark") {
        // Si l'utilisateur a déjà choisi un thème → appliquer ce choix
        applyTheme(userTheme);
    } else {
        // Sinon, détecter la préférence du système (Windows/macOS)
        const prefersDark = window.matchMedia("(prefers-color-scheme: dark)").matches;
        const systemTheme = prefersDark ? "dark" : "light";
        applyTheme(systemTheme);
        localStorage.setItem("theme", systemTheme); // Enregistre le thème choisi par défaut
    }

    // Gestion du bouton de bascule
    if (themeToggle) {
        themeToggle.addEventListener("click", function () {
            const currentTheme = document.body.getAttribute("data-theme");
            const newTheme = currentTheme === "light" ? "dark" : "light";
            applyTheme(newTheme);
            localStorage.setItem("theme", newTheme);
        });
    }

    // Écoute les changements du thème système (si jamais l'utilisateur change sous Windows)
    window.matchMedia("(prefers-color-scheme: dark)").addEventListener("change", (e) => {
        const newSystemTheme = e.matches ? "dark" : "light";

        // Seulement si l'utilisateur n’a pas choisi manuellement
        if (!localStorage.getItem("theme")) {
            applyTheme(newSystemTheme);
        }
    });
});
