# -*- coding: utf-8 -*-
from setuphelpers import *


def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    app_name = control.name

    url_api = "https://api.github.com/repos/dbeaver/dbeaver/releases/latest"

    download_os_dict = {
        'macos-x64': 'macos-x86_64.dmg',
        'macos-arm': 'macos-aarch64.dmg',
    }
    os_type = control.target_os + "-" + ensure_list(control.architecture)[0]

    # Getting latest informations from Github API
    json_load = wgets(url_api, proxies=proxies, as_json=True)

    for download in json_load["assets"]:
        if download["browser_download_url"].endswith(download_os_dict[os_type]):
            download_url = download["browser_download_url"]
            latest_bin = download["name"]
            version = json_load["tag_name"].replace("v", "")
            latest_bin_extension = latest_bin.rsplit('.', 1)[-1]
            break

    # Downloading latest binaries
    print("Latest %s version is: %s" % (app_name, version))
    print("Download URL is: %s" % download_url)
    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(download_url, latest_bin, proxies=proxies)
        package_updated = True
    else:
        print("Binary is present: %s" % latest_bin)

    # Changing version of the package
    if Version(version) > Version(control.get_software_version()):
        print("Software version updated (from: %s to: %s)" % (control.get_software_version(), Version(version)))
        package_updated = True
    else:
        print("Software version up-to-date (%s)" % Version(version))

    control.set_software_version(version)
    control.save_control_to_wapt()

    for f in glob.glob(f'*.{latest_bin_extension}'):
        if f != latest_bin:
            remove_file(f)

    # Validating or not update-package-sources
    return package_updated
