# -*- coding: utf-8 -*-
from setuphelpers import *
from setupdevhelpers import *
import os


def update_package():
    package_dir = os.getcwd()
    # getting version from WAPT public repository:
    for entry in bs_find_all("https://wapt.tranquil.it/wapt/releases/latest/", "a", "href"):
        lnk = entry.attrs["href"]
        if lnk.endswith(".deb"):
            if "amd64" in lnk:
                last_version = lnk.split("-")[2]
                short_version = last_version.rsplit(".", 2)[0]
                break

    # saving version to control file
    control.set_software_version(last_version)
    control.save_control_to_wapt()

    db_structure_diagram = rf"""
    apt remove tis-waptagent -y ; apt install apt-transport-https lsb-release gnupg wget -y ; wget -qO- https://wapt.tranquil.it/$(lsb_release -is)/tiswapt-pub.gpg | tee /usr/share/keyrings/tiswapt-pub.gpg > /dev/null ; echo "deb [signed-by=/usr/share/keyrings/tiswapt-pub.gpg] https://wapt.tranquil.it/$(lsb_release -is)/wapt-{short_version}/ $(lsb_release -c -s) main" > /etc/apt/sources.list.d/wapt.list ; export DEBIAN_FRONTEND=noninteractive ; apt update ; apt install tis-waptserver tis-waptsetup -y ; unset DEBIAN_FRONTEND ; /opt/wapt/waptserver/scripts/postconf.sh -q ; apt install postgresql-autodoc graphviz -y ; cd /tmp ; sudo -u wapt postgresql_autodoc -d wapt ; dot -Tsvg wapt.dot -owapt.svg
    """
    run(db_structure_diagram)
    for file in glob.glob("/tmp/wapt.*"):
        filecopyto(file, package_dir)
