# -*- coding: utf-8 -*-
from setuphelpers import *
from setupdevhelpers import *
import glob
import json
import os


def update_package():
    # Declaration of local variables
    package_updated = False
    proxies = get_proxies_from_wapt_console()
    if not proxies:
        proxies = get_proxies()
    api_url = "https://ddagent-windows-stable.s3.amazonaws.com/installers_v2.json"

    # Get JSON data from API
    api_dict = wgets(api_url, proxies=proxies, as_json=True)

    # Check if key 'datadog-agent' exists in dictionary
    if "datadog-agent" in api_dict:
        # Determine latest version from JSON data
        last_version_key = max(api_dict["datadog-agent"].keys())  # use a lambda to make sure to compare digits
        last_version_info = api_dict["datadog-agent"][last_version_key]

        # Get installer URL for x86_64 architecture
        if "x86_64" in last_version_info:
            installer_url = last_version_info["x86_64"]["url"]
            latest_version = last_version_key

            print(f"Latest version available: {latest_version}")

            if not isfile(f"datadog-agent-{latest_version}.msi"):
                print(f"Downloading new version from {installer_url}")
                wget(installer_url, f"datadog-agent-{latest_version}.msi", proxies=proxies)

                # Cleaning temporary files
                for f in glob.glob("*.msi"):
                    if f != f"datadog-agent-{latest_version}.msi":
                        print(f"Removing file: {f}")
                        remove_file(f)

    version = latest_version.split("-")[0]

    # Changing version of the package
    if Version(version, 4) > Version(control.get_software_version(), 4):
        print("Software version updated (from: %s to: %s)" % (control.get_software_version(), Version(version)))
        package_updated = True
    else:
        print("Software version up-to-date (%s)" % Version(version))
    control.set_software_version(version)
    control.save_control_to_wapt()

    # Validating or not update-package-sources
    return package_updated

    # # Changing version of the package and validating update-package-sources
    # return complete_control_version(control, version)
