"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.raceWith = void 0;
const race_js_1 = require("../observable/race.js");
const Observable_js_1 = require("../Observable.js");
const identity_js_1 = require("../util/identity.js");
function raceWith(...otherSources) {
    return !otherSources.length
        ? identity_js_1.identity
        : (source) => new Observable_js_1.Observable((subscriber) => {
            (0, race_js_1.raceInit)([source, ...otherSources])(subscriber);
        });
}
exports.raceWith = raceWith;//# sourceMappingURL=http://go/sourcemap/sourcemaps/3578107fdf149b00059ddad37048220e41681000/node_modules/rxjs/dist/cjs/internal/operators/raceWith.js.map