(()=>{"use strict";var t={8:(t,e)=>{Object.defineProperty(e,"__esModule",{value:!0}),e.BROWSER_UTILS=void 0,e.BROWSER_UTILS="\nfunction buildPageSnapshot(options = {}) {\n    const maxDepth = options.maxDepth || 30;\n    const interactiveOnly = options.interactive || false;\n    const compact = options.compact || false;\n    const selector = options.selector || null;\n\n    function isElementHiddenForAria(element) {\n        if (!element) return true;\n        const tag = element.tagName?.toUpperCase();\n        if (['STYLE', 'SCRIPT', 'NOSCRIPT', 'TEMPLATE'].includes(tag)) return true;\n        if (element.getAttribute('aria-hidden') === 'true') return true;\n\n        const style = window.getComputedStyle(element);\n        if (!style) return false;\n\n        if (style.visibility === 'hidden' || style.visibility === 'collapse') return true;\n        if (style.display === 'none') return true;\n\n        let parent = element.parentElement;\n        while (parent && parent !== document.body) {\n            if (parent.getAttribute('aria-hidden') === 'true') return true;\n            const parentStyle = window.getComputedStyle(parent);\n            if (parentStyle?.display === 'none') return true;\n            parent = parent.parentElement;\n        }\n\n        return false;\n    }\n\n    function getTextFromIds(ids) {\n        try {\n            if (!ids) return '';\n            const parts = [];\n            ids.split(/\\s+/).forEach(id => {\n                const el = document.getElementById(id);\n                if (el) {\n                    const t = (el.innerText || el.textContent || '').trim();\n                    if (t) parts.push(t);\n                }\n            });\n            return parts.join(' ').trim();\n        } catch (_) { return ''; }\n    }\n\n    function getVisibleText(el) {\n        try {\n            const walker = document.createTreeWalker(\n                el,\n                NodeFilter.SHOW_TEXT,\n                {\n                    acceptNode(node) {\n                        if (!node.textContent || !node.textContent.trim()) {\n                            return NodeFilter.FILTER_REJECT;\n                        }\n                        const parent = node.parentElement;\n                        if (parent && isElementHiddenForAria(parent)) {\n                            return NodeFilter.FILTER_REJECT;\n                        }\n                        return NodeFilter.FILTER_ACCEPT;\n                    }\n                }\n            );\n            const parts = [];\n            while (walker.nextNode()) {\n                const text = walker.currentNode.textContent || '';\n                const clean = text.replace(/\\s+/g, ' ').trim();\n                if (clean) {\n                    parts.push(clean);\n                    if (parts.join(' ').length > 240) {\n                        break;\n                    }\n                }\n            }\n            if (parts.length) {\n                return parts.join(' ').trim().substring(0, 200);\n            }\n            const fallback = (el.innerText || el.textContent || '').replace(/\\s+/g, ' ').trim();\n            return fallback.substring(0, 200);\n        } catch (_) {\n            try {\n                const text = (el.innerText || '').replace(/\\s+/g, ' ').trim();\n                return text.substring(0, 200);\n            } catch (_) {\n                return '';\n            }\n        }\n    }\n\n    function getLabelsText(el) {\n        try {\n            const labels = (el.labels && Array.from(el.labels)) || [];\n            if (!labels.length) return '';\n            const labelText = labels\n                .map(label => getVisibleText(label) || (label.textContent || '').trim())\n                .filter(Boolean)\n                .join(' ')\n                .trim();\n            return labelText.substring(0, 200);\n        } catch (_) {\n            return '';\n        }\n    }\n\n    function getImplicitRole(el) {\n        try {\n            const tag = el.tagName ? el.tagName.toLowerCase() : '';\n            switch (tag) {\n                case 'a':\n                    return el.hasAttribute('href') ? 'link' : null;\n                case 'area':\n                    return el.hasAttribute('href') ? 'link' : null;\n                case 'article':\n                    return 'article';\n                case 'aside':\n                    return 'complementary';\n                case 'button':\n                    return 'button';\n                case 'datalist':\n                    return 'listbox';\n                case 'details':\n                    return 'group';\n                case 'dialog':\n                    return 'dialog';\n                case 'h1': case 'h2': case 'h3': case 'h4': case 'h5': case 'h6':\n                    return 'heading';\n                case 'hr':\n                    return 'separator';\n                case 'img':\n                    return (el.getAttribute('alt') === '' && !el.getAttribute('title')) ? null : 'img';\n                case 'input': {\n                    const type = (el.type || el.getAttribute('type') || 'text').toLowerCase();\n                    if (type === 'button' || type === 'submit' || type === 'reset' || type === 'image') return 'button';\n                    if (type === 'checkbox') return 'checkbox';\n                    if (type === 'radio') return 'radio';\n                    if (type === 'range') return 'slider';\n                    if (type === 'number') return 'spinbutton';\n                    if (type === 'search') return el.hasAttribute('list') ? 'combobox' : 'searchbox';\n                    if (type === 'hidden') return null;\n                    if (['email', 'tel', 'text', 'url', 'password', ''].includes(type)) {\n                        const list = el.getAttribute('list');\n                        if (list) {\n                            const datalist = document.getElementById(list);\n                            if (datalist && datalist.tagName === 'DATALIST') return 'combobox';\n                        }\n                        return 'textbox';\n                    }\n                    return 'textbox';\n                }\n                case 'li':\n                    return 'listitem';\n                case 'main':\n                    return 'main';\n                case 'math':\n                    return 'math';\n                case 'menu':\n                    return 'list';\n                case 'meter':\n                    return 'meter';\n                case 'nav':\n                    return 'navigation';\n                case 'ol': case 'ul':\n                    return 'list';\n                case 'optgroup':\n                    return 'group';\n                case 'option':\n                    return 'option';\n                case 'output':\n                    return 'status';\n                case 'progress':\n                    return 'progressbar';\n                case 'search':\n                    return 'search';\n                case 'select':\n                    return el.hasAttribute('multiple') || (el.size > 1) ? 'listbox' : 'combobox';\n                case 'summary':\n                    return 'button';\n                case 'table':\n                    return 'table';\n                case 'tbody': case 'tfoot': case 'thead':\n                    return 'rowgroup';\n                case 'td':\n                    return 'cell';\n                case 'textarea':\n                    return 'textbox';\n                case 'th':\n                    return 'columnheader';\n                case 'tr':\n                    return 'row';\n                case 'section':\n                    return (el.hasAttribute('aria-label') || el.hasAttribute('aria-labelledby')) ? 'region' : null;\n                case 'form':\n                    return (el.hasAttribute('aria-label') || el.hasAttribute('aria-labelledby')) ? 'form' : null;\n                case 'header':\n                    return 'banner';\n                case 'footer':\n                    return 'contentinfo';\n                case 'svg':\n                    return 'img';\n                default:\n                    return null;\n            }\n        } catch (_) {\n            return null;\n        }\n    }\n\n    function getAriaRole(el) {\n        const explicitRole = el.getAttribute('role');\n        if (explicitRole) {\n            const roles = explicitRole.split(' ').map(r => r.trim()).filter(Boolean);\n            if (roles.length > 0) return roles[0];\n        }\n        return getImplicitRole(el);\n    }\n\n    function computeAccessibleName(el, role) {\n        try {\n            if (!el || el.getAttribute('aria-hidden') === 'true') {\n                return '';\n            }\n\n            const labelledBy = el.getAttribute('aria-labelledby');\n            const fromLabelledBy = getTextFromIds(labelledBy);\n            if (fromLabelledBy) return fromLabelledBy.substring(0, 200);\n\n            const ariaLabel = (el.getAttribute('aria-label') || '').trim();\n            if (ariaLabel) return ariaLabel.substring(0, 200);\n\n            const ariaPlaceholder = (el.getAttribute('aria-placeholder') || '').trim();\n            if (ariaPlaceholder) return ariaPlaceholder.substring(0, 200);\n\n            const labelsText = getLabelsText(el);\n            if (labelsText) return labelsText.substring(0, 200);\n\n            const tag = el.tagName ? el.tagName.toLowerCase() : '';\n\n            if (tag === 'img') {\n                const alt = (el.getAttribute('alt') || '').trim();\n                if (alt) return alt.substring(0, 200);\n            }\n\n            if (tag === 'input') {\n                const type = (el.getAttribute('type') || 'text').toLowerCase();\n                const value = el.value || el.getAttribute('value') || '';\n                const placeholder = (el.getAttribute('placeholder') || '').trim();\n                if (type === 'button' || type === 'submit' || type === 'reset') {\n                    if (value) return String(value).substring(0, 200);\n                }\n                if (placeholder) return placeholder.substring(0, 200);\n                if (value && type !== 'password') return String(value).substring(0, 200);\n            }\n\n            if (tag === 'textarea') {\n                const placeholder = (el.getAttribute('placeholder') || '').trim();\n                if (placeholder) return placeholder.substring(0, 200);\n                if (el.value) return String(el.value).substring(0, 200);\n            }\n\n            if (tag === 'select') {\n                const selected = Array.from(el.selectedOptions || [])\n                    .map(option => getVisibleText(option) || (option.textContent || '').trim())\n                    .filter(Boolean)\n                    .join(', ')\n                    .trim();\n                if (selected) return selected.substring(0, 200);\n            }\n\n            const roleLower = (role || '').toLowerCase();\n            const interactiveRoles = new Set(['button', 'link', 'menuitem', 'option', 'tab', 'checkbox', 'radio', 'switch', 'combobox', 'textbox', 'listbox', 'slider', 'spinbutton', 'cell', 'gridcell', 'row', 'columnheader', 'rowheader']);\n            const interactiveTags = new Set(['button', 'a', 'summary', 'label', 'option', 'textarea', 'select', 'time']);\n            const headingTags = new Set(['h1','h2','h3','h4','h5','h6']);\n            if (interactiveRoles.has(roleLower) || interactiveTags.has(tag) || headingTags.has(tag)) {\n                const visible = getVisibleText(el);\n                if (visible) return visible.substring(0, 200);\n            }\n\n            if (tag === 'p' || tag === 'li' || roleLower === 'heading') {\n                const visible = getVisibleText(el);\n                if (visible) return visible.substring(0, 200);\n            }\n\n            const title = (el.getAttribute('title') || '').trim();\n            if (title) return title.substring(0, 200);\n\n            return '';\n        } catch (_) {\n            return '';\n        }\n    }\n\n    function collectElementStates(el, role) {\n        const states = [];\n        try {\n            if (document.activeElement === el) {\n                states.push('active');\n                states.push('focused');\n            }\n            if (el.matches && el.matches(':checked')) states.push('checked');\n            const ariaChecked = el.getAttribute('aria-checked');\n            if (ariaChecked === 'true') states.push('checked');\n            if (ariaChecked === 'mixed') states.push('indeterminate');\n            if (el.matches && el.matches(':disabled')) states.push('disabled');\n            if (el.disabled) states.push('disabled');\n            let parent = el.parentElement;\n            while (parent) {\n                if (parent.tagName === 'FIELDSET' && parent.disabled) {\n                    states.push('disabled');\n                    break;\n                }\n                parent = parent.parentElement;\n            }\n            if (el.matches && el.matches(':required')) states.push('required');\n            if (el.matches && el.matches(':read-only') && (el.tagName === 'INPUT' || el.tagName === 'TEXTAREA')) states.push('readonly');\n            if (el.readOnly) states.push('readonly');\n            if (el.selected) states.push('selected');\n            const ariaSelected = el.getAttribute('aria-selected');\n            if (ariaSelected === 'true') states.push('selected');\n            const ariaExpanded = el.getAttribute('aria-expanded');\n            if (ariaExpanded === 'true') states.push('expanded');\n            if (ariaExpanded === 'false') states.push('collapsed');\n            const ariaPressed = el.getAttribute('aria-pressed');\n            if (ariaPressed === 'true') states.push('pressed');\n            if (ariaPressed === 'false') states.push('released');\n            if (el.getAttribute && el.getAttribute('aria-current')) states.push('current');\n            if (el.getAttribute && el.getAttribute('aria-invalid') === 'true') states.push('invalid');\n            if (el.getAttribute && el.getAttribute('aria-busy') === 'true') states.push('busy');\n        } catch (_) { }\n        return Array.from(new Set(states));\n    }\n\n    function collectElementDetails(el, role) {\n        const details = {};\n        try {\n            const tag = el.tagName ? el.tagName.toLowerCase() : '';\n            const ariaDescription = (el.getAttribute('aria-description') || '').trim();\n            if (ariaDescription) {\n                details.description = ariaDescription.substring(0, 200);\n            }\n            const describedBy = getTextFromIds(el.getAttribute('aria-describedby'));\n            if (describedBy) {\n                details.description = details.description\n                    ? (details.description + ' ' + describedBy.substring(0, 200)).trim()\n                    : describedBy.substring(0, 200);\n            }\n            if (tag === 'a' && el.hasAttribute('href')) {\n                details.url = el.getAttribute('href');\n            }\n            if ((tag === 'img' || tag === 'svg') && el.hasAttribute('src')) {\n                details.src = el.getAttribute('src');\n            }\n            if (tag === 'input' || tag === 'textarea') {\n                const type = (el.getAttribute('type') || 'text').toLowerCase();\n                const value = el.value || el.getAttribute('value') || '';\n                if (value && (tag !== 'input' || type !== 'password')) {\n                    details.value = String(value).substring(0, 200);\n                }\n                const placeholder = (el.getAttribute('placeholder') || '').trim();\n                if (placeholder) {\n                    details.placeholder = placeholder.substring(0, 200);\n                }\n            }\n            if (tag === 'select') {\n                const selected = Array.from(el.selectedOptions || [])\n                    .map(option => getVisibleText(option) || (option.textContent || '').trim())\n                    .filter(Boolean);\n                if (selected.length) {\n                    details.value = selected.join(', ').substring(0, 200);\n                }\n                const allOptions = Array.from(el.options || []);\n                if (allOptions.length > 0 && allOptions.length <= 20) {\n                    details.options = allOptions.map(opt => {\n                        const label = (opt.textContent || '').trim();\n                        const value = opt.value;\n                        const disabled = opt.disabled;\n                        let optStr = label;\n                        if (value && value !== label) {\n                            optStr += ' (value: ' + value + ')';\n                        }\n                        if (disabled) {\n                            optStr += ' [disabled]';\n                        }\n                        return optStr;\n                    }).join(', ');\n                } else if (allOptions.length > 20) {\n                    details.options = allOptions.slice(0, 10).map(opt => {\n                        const label = (opt.textContent || '').trim();\n                        return label;\n                    }).join(', ') + '... (' + allOptions.length + ' total options)';\n                }\n            }\n            if (role === 'combobox' && el.getAttribute('aria-activedescendant')) {\n                details.activeDescendant = el.getAttribute('aria-activedescendant');\n            }\n        } catch (_) { }\n        return details;\n    }\n\n    function shouldIncludeElement(el) {\n        try {\n            if (!el || el.getAttribute('aria-hidden') === 'true') {\n                return false;\n            }\n            const tag = el.tagName ? el.tagName.toLowerCase() : '';\n            const role = el.getAttribute('role') || getImplicitRole(el);\n            const meaningfulTags = new Set(['a', 'button', 'input', 'select', 'textarea', 'img', 'svg', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'nav', 'main', 'header', 'footer', 'section', 'article', 'form', 'label', 'ul', 'ol', 'li', 'p', 'strong', 'em', 'small', 'time', 'option', 'summary', 'details']);\n            if (meaningfulTags.has(tag)) {\n                return true;\n            }\n            if (role && role !== 'generic') {\n                return true;\n            }\n            if (el.getAttribute('aria-label') || el.getAttribute('aria-labelledby')) {\n                return true;\n            }\n            if (el.matches && el.matches('[contenteditable=\"true\"]')) {\n                return true;\n            }\n            if (el.querySelector && el.querySelector('a, button, input, select, textarea, [role], [contenteditable=\"true\"]')) {\n                return true;\n            }\n        } catch (_) {\n            return true;\n        }\n        return false;\n    }\n\n    const INTERACTIVE_ROLES = new Set([\n        'button', 'link', 'textbox', 'checkbox', 'radio', 'combobox', 'listbox',\n        'menuitem', 'menuitemcheckbox', 'menuitemradio', 'option', 'slider',\n        'spinbutton', 'switch', 'tab', 'treeitem', 'searchbox'\n    ]);\n\n    function isValidRef(ref) {\n        return typeof ref === 'string' && /^e\\d+$/.test(ref);\n    }\n\n    function getMaxRefIndex() {\n        let maxIndex = -1;\n        const existing = document.querySelectorAll('[data-cursor-ref]');\n        for (const el of existing) {\n            const ref = el.getAttribute('data-cursor-ref');\n            if (isValidRef(ref)) {\n                const num = parseInt(ref.substring(1), 10);\n                if (!Number.isNaN(num)) {\n                    maxIndex = Math.max(maxIndex, num);\n                }\n            }\n        }\n        return maxIndex;\n    }\n\n    let refCounter = 0;\n\n    class RoleNameTracker {\n        constructor() {\n            this.counts = new Map();\n            this.refsByKey = new Map();\n        }\n        getKey(role, name) {\n            return role + '::' + (name || '');\n        }\n        getNextIndex(role, name) {\n            const key = this.getKey(role, name);\n            const current = this.counts.get(key) || 0;\n            this.counts.set(key, current + 1);\n            return current;\n        }\n        trackRef(role, name, ref) {\n            const key = this.getKey(role, name);\n            const refs = this.refsByKey.get(key) || [];\n            refs.push(ref);\n            this.refsByKey.set(key, refs);\n        }\n        getDuplicateKeys() {\n            const duplicates = new Set();\n            for (const [key, refs] of this.refsByKey) {\n                if (refs.length > 1) {\n                    duplicates.add(key);\n                }\n            }\n            return duplicates;\n        }\n    }\n\n    function buildInteractiveSnapshot() {\n        const tracker = new RoleNameTracker();\n        const elements = [];\n        const usedRefs = new Set();\n        const interactiveSet = new Set();\n\n        const interactiveSelector = [\n            'input', 'textarea', 'select', 'button', 'a[href]',\n            '[role=\"button\"]', '[role=\"link\"]', '[role=\"textbox\"]', '[role=\"checkbox\"]',\n            '[role=\"radio\"]', '[role=\"combobox\"]', '[role=\"listbox\"]', '[role=\"menuitem\"]',\n            '[role=\"menuitemcheckbox\"]', '[role=\"menuitemradio\"]', '[role=\"option\"]',\n            '[role=\"slider\"]', '[role=\"spinbutton\"]', '[role=\"switch\"]', '[role=\"tab\"]',\n            '[role=\"treeitem\"]', '[role=\"searchbox\"]', '[contenteditable=\"true\"]',\n            'summary', '[tabindex]:not([tabindex=\"-1\"])'\n        ].join(', ');\n\n        const allInteractive = document.querySelectorAll(interactiveSelector);\n\n        for (const el of allInteractive) {\n            if (el.getAttribute('aria-hidden') === 'true') continue;\n            const style = window.getComputedStyle(el);\n            if (style.display === 'none' || style.visibility === 'hidden') continue;\n            const rect = el.getBoundingClientRect();\n            if (rect.width === 0 && rect.height === 0) continue;\n\n            const tag = el.tagName.toLowerCase();\n            interactiveSet.add(el);\n            const roleAttr = el.getAttribute('role') || '';\n            const implicitRole = getImplicitRole(el);\n            const role = roleAttr || implicitRole || 'generic';\n\n            if (!INTERACTIVE_ROLES.has(role) && role !== 'generic') continue;\n\n            const name = computeAccessibleName(el, role);\n            const existingRef = el.getAttribute('data-cursor-ref');\n            let ref = null;\n            if (isValidRef(existingRef) && !usedRefs.has(existingRef)) {\n                ref = existingRef;\n            } else {\n                ref = 'e' + refCounter++;\n            }\n            el.setAttribute('data-cursor-ref', ref);\n            usedRefs.add(ref);\n\n            const nth = tracker.getNextIndex(role, name);\n            tracker.trackRef(role, name, ref);\n\n            const node = { ref, role, name, tag };\n\n            const states = collectElementStates(el, role);\n            if (states.length) node.states = states;\n\n            const details = collectElementDetails(el, role);\n            for (const key in details) {\n                if (details[key] !== undefined && details[key] !== '') {\n                    node[key] = details[key];\n                }\n            }\n\n            node._nth = nth;\n\n            elements.push(node);\n        }\n\n        const duplicateKeys = tracker.getDuplicateKeys();\n        for (const el of elements) {\n            const key = tracker.getKey(el.role, el.name);\n            if (duplicateKeys.has(key) && el._nth > 0) {\n                el.nth = el._nth;\n            }\n            delete el._nth;\n        }\n\n        return { elements, tracker, usedRefs, interactiveSet };\n    }\n\n    function buildContentElements(interactiveSet, usedRefs) {\n        const elements = [];\n        const contentSelector = [\n            'h1', 'h2', 'h3', 'h4', 'h5', 'h6',\n            'label', '[role=\"heading\"]', 'p', 'li',\n            'article', 'nav', 'main', 'header', 'footer', 'section',\n            '[role=\"article\"]', '[role=\"region\"]', '[role=\"main\"]', '[role=\"navigation\"]',\n            '[role=\"cell\"]', '[role=\"gridcell\"]', '[role=\"columnheader\"]', '[role=\"rowheader\"]',\n            '[role=\"listitem\"]'\n        ].join(', ');\n        const allContent = document.querySelectorAll(contentSelector);\n\n        for (const el of allContent) {\n            if (el.getAttribute('aria-hidden') === 'true') continue;\n            if (interactiveSet.has(el)) continue;\n\n            const style = window.getComputedStyle(el);\n            if (style.display === 'none' || style.visibility === 'hidden') continue;\n\n            const tag = el.tagName.toLowerCase();\n            const role = el.getAttribute('role') || getImplicitRole(el);\n            const name = computeAccessibleName(el, role);\n\n            if (!name) continue;\n\n            const existingRef = el.getAttribute('data-cursor-ref');\n            let ref = null;\n            if (isValidRef(existingRef) && !usedRefs.has(existingRef)) {\n                ref = existingRef;\n            } else {\n                ref = 'e' + refCounter++;\n            }\n            el.setAttribute('data-cursor-ref', ref);\n            usedRefs.add(ref);\n\n            const node = { ref, role, name, tag };\n\n            if (role === 'heading') {\n                const ariaLevel = parseInt(el.getAttribute('aria-level') || '', 10);\n                const tagLevelMatch = tag.match(/^h([1-6])$/);\n                const tagLevel = tagLevelMatch ? parseInt(tagLevelMatch[1], 10) : undefined;\n                const level = !Number.isNaN(ariaLevel) ? ariaLevel : tagLevel;\n                if (level) node.level = level;\n            }\n\n            elements.push(node);\n        }\n\n        return elements;\n    }\n\n    refCounter = getMaxRefIndex() + 1;\n\n    const { elements: interactiveElements, tracker, usedRefs, interactiveSet } = buildInteractiveSnapshot();\n    const contentElements = interactiveOnly ? [] : buildContentElements(interactiveSet, usedRefs);\n\n    const allElements = [...interactiveElements, ...contentElements];\n\n    document.querySelectorAll('[data-cursor-ref]').forEach(el => {\n        const ref = el.getAttribute('data-cursor-ref');\n        if (!isValidRef(ref) || !usedRefs.has(ref)) {\n            el.removeAttribute('data-cursor-ref');\n        }\n    });\n\n    const tree = {\n        role: 'document',\n        ref: 'root',\n        name: document.title || '',\n        children: allElements\n    };\n\n    return {\n        tree,\n        stats: {\n            totalRefs: allElements.length,\n            interactiveRefs: interactiveElements.length,\n            maxDepth: maxDepth\n        }\n    };\n}\n"},67:function(t,e,n){var r,o=this&&this.__createBinding||(Object.create?function(t,e,n,r){void 0===r&&(r=n);var o=Object.getOwnPropertyDescriptor(e,n);o&&!("get"in o?!e.__esModule:o.writable||o.configurable)||(o={enumerable:!0,get:function(){return e[n]}}),Object.defineProperty(t,r,o)}:function(t,e,n,r){void 0===r&&(r=n),t[r]=e[n]}),s=this&&this.__setModuleDefault||(Object.create?function(t,e){Object.defineProperty(t,"default",{enumerable:!0,value:e})}:function(t,e){t.default=e}),i=this&&this.__importStar||(r=function(t){return r=Object.getOwnPropertyNames||function(t){var e=[];for(var n in t)Object.prototype.hasOwnProperty.call(t,n)&&(e[e.length]=n);return e},r(t)},function(t){if(t&&t.__esModule)return t;var e={};if(null!=t)for(var n=r(t),i=0;i<n.length;i++)"default"!==n[i]&&o(e,t,n[i]);return s(e,t),e});Object.defineProperty(e,"__esModule",{value:!0}),e.createNavigationTools=function(t){return{async navigate(e){await(0,l.ensureBrowserNavigationAllowed)(e.url),l.CursorIDEBrowserLogger.info(`Navigating to ${e.url}${e.headless?" (headless)":""}`);const n=await a.commands.executeCommand("cursor.browserView.listTabs"),r=n?.tabs??[],o=new Set(n?.headlessTabs??[]);if(e.viewId){const n=r.includes(e.viewId);if(!n&&e.headless){l.CursorIDEBrowserLogger.info(`Creating headless tab with viewId: ${e.viewId}`);const n=await a.commands.executeCommand("cursor.browserView.newHeadlessTab",e.url,e.viewId);return n?.browserId?t.snapshot({viewId:n.browserId,headless:!0,take_screenshot_afterwards:e.take_screenshot_afterwards}):{content:[{type:"text",text:"Failed to create headless browser tab"}]}}return n?(l.viewSnapshotTimestamps.delete(e.viewId),await a.commands.executeCommand("cursor.browserView.navigate",e.url,e.viewId,{headless:e.headless,preserveFocus:!0}),t.snapshot({viewId:e.viewId,headless:e.headless,take_screenshot_afterwards:e.take_screenshot_afterwards})):{content:[{type:"text",text:`Browser view not found: ${e.viewId}. Use browser_navigate without a viewId to create a new tab.`}]}}if(r.length>0&&!e.headless&&!e.newTab){const n=r.find(t=>!o.has(t));if(n)return l.viewSnapshotTimestamps.delete(n),await a.commands.executeCommand("cursor.browserView.navigate",e.url,n,{preserveFocus:!0}),t.snapshot({viewId:n,take_screenshot_afterwards:e.take_screenshot_afterwards})}if(e.headless){const n=await a.commands.executeCommand("cursor.browserView.newHeadlessTab",e.url);return n?.browserId?t.snapshot({viewId:n.browserId,headless:!0,take_screenshot_afterwards:e.take_screenshot_afterwards}):{content:[{type:"text",text:"Failed to create headless browser tab"}]}}const s={preserveFocus:!0};e.position&&(s.position=e.position);const i=await a.commands.executeCommand("cursor.browserView.newTab",e.url,s);return i?.browserId?t.snapshot({viewId:i.browserId,take_screenshot_afterwards:e.take_screenshot_afterwards}):{content:[{type:"text",text:"Failed to create new browser tab"}]}},async goBack(t){const e=await(0,l.resolveViewId)(t.viewId);if(!e)return{content:[{type:"text",text:"No browser tab available. Please navigate to a page first."}]};if(await(0,l.ensureCurrentPageAllowed)("browser_navigate_back",e),!await a.commands.executeCommand("cursor.browserView.goBack",e,t.headless))return{content:[{type:"text",text:"Failed to navigate back. This may happen because:\n- There is no previous page in the browser history\n- The page was opened fresh without prior navigation\n- The history was cleared\n\nSuggestion: Use browser_navigate to go to a specific URL instead."}]};const n={content:[{type:"text",text:"Successfully navigated back"},{type:"metadata",viewId:e}]};return(0,l.maybeAddScreenshotToResult)(n,e,t.take_screenshot_afterwards??!1)},async goForward(t){const e=await(0,l.resolveViewId)(t.viewId);if(!e)return{content:[{type:"text",text:"No browser tab available. Please navigate to a page first."}]};if(await(0,l.ensureCurrentPageAllowed)("browser_navigate_forward",e),!await a.commands.executeCommand("cursor.browserView.goForward",e,t.headless))return{content:[{type:"text",text:"Failed to navigate forward. This may happen because:\n- There is no forward page in the browser history\n- You have not navigated back yet\n- The forward history was cleared by a new navigation\n\nSuggestion: Use browser_navigate to go to a specific URL instead."}]};const n={content:[{type:"text",text:"Successfully navigated forward"},{type:"metadata",viewId:e}]};return(0,l.maybeAddScreenshotToResult)(n,e,t.take_screenshot_afterwards??!1)},async reload(e){const n=await(0,l.resolveViewId)(e.viewId);return n?(await(0,l.ensureCurrentPageAllowed)("browser_reload",n),await a.commands.executeCommand("cursor.browserView.reload",n,e.headless)?t.snapshot({viewId:n,headless:e.headless,take_screenshot_afterwards:e.take_screenshot_afterwards}):{content:[{type:"text",text:"Failed to reload page"}]}):{content:[{type:"text",text:"No browser tab available. Please navigate to a page first."}]}},async tabs(e){switch(e.action){case"list":{const t=await a.commands.executeCommand("cursor.browserView.listTabs");return t&&t.tabs?{content:[{type:"text",text:`Open tabs:\n${(await Promise.all(t.tabs.map(async(t,e)=>{const[n,r]=await Promise.all([a.commands.executeCommand("cursor.browserView.getURL",t),a.commands.executeCommand("cursor.browserView.getTitle",t)]);return`[${e}] "${r||"New Tab"}" - ${n||"about:blank"} (viewId: ${t})`}))).join("\n")}`}]}:{content:[{type:"text",text:"Open tabs:\n(none)"}]}}case"new":{const t={preserveFocus:!0};e.position&&(t.position=e.position);const n=await a.commands.executeCommand("cursor.browserView.newTab",void 0,t),r=n?.browserId,o=[{type:"text",text:"Created new tab"+("side"===e.position?" on the side":"")}];return r&&o.push({type:"metadata",viewId:r,title:"New Tab",url:"about:blank"}),{content:o}}case"close":{const n=await a.commands.executeCommand("cursor.browserView.listTabs"),r=n?.tabs??[],o=void 0!==e.index?r[e.index]:void 0;let s="Tab",i="";if(o){const[t,e]=await Promise.all([a.commands.executeCommand("cursor.browserView.getTitle",o),a.commands.executeCommand("cursor.browserView.getURL",o)]);s=t||"Tab",i=e||""}await a.commands.executeCommand("cursor.browserView.closeTab",o);const l=await a.commands.executeCommand("cursor.browserView.listTabs"),c=l?.activeTab??l?.lastInteractedTab;return c?t.snapshot({viewId:c}):{content:[{type:"text",text:"Tab closed. No remaining tabs."},{type:"metadata",viewId:o||"",title:s,url:i}]}}case"select":{if(void 0===e.index)throw new Error("Tab index is required");const n=await a.commands.executeCommand("cursor.browserView.listTabs"),r=(n?.tabs??[])[e.index];if(!r)throw new Error(`Tab ${e.index} not found`);await a.commands.executeCommand("cursor.browserView.selectTab",r);const[o,s]=await Promise.all([a.commands.executeCommand("cursor.browserView.getTitle",r),a.commands.executeCommand("cursor.browserView.getURL",r)]),i=await t.snapshot({viewId:r}),l=i.content?.find(t=>"metadata"===t.type);return l&&"metadata"===l.type&&(l.title=o||"New Tab",l.url=s||"about:blank"),i}default:throw new Error(`Unknown action: ${e.action}`)}}}};const a=i(n(398)),l=n(376)},148:function(t,e,n){var r,o=this&&this.__createBinding||(Object.create?function(t,e,n,r){void 0===r&&(r=n);var o=Object.getOwnPropertyDescriptor(e,n);o&&!("get"in o?!e.__esModule:o.writable||o.configurable)||(o={enumerable:!0,get:function(){return e[n]}}),Object.defineProperty(t,r,o)}:function(t,e,n,r){void 0===r&&(r=n),t[r]=e[n]}),s=this&&this.__setModuleDefault||(Object.create?function(t,e){Object.defineProperty(t,"default",{enumerable:!0,value:e})}:function(t,e){t.default=e}),i=this&&this.__importStar||(r=function(t){return r=Object.getOwnPropertyNames||function(t){var e=[];for(var n in t)Object.prototype.hasOwnProperty.call(t,n)&&(e[e.length]=n);return e},r(t)},function(t){if(t&&t.__esModule)return t;var e={};if(null!=t)for(var n=r(t),i=0;i<n.length;i++)"default"!==n[i]&&o(e,t,n[i]);return s(e,t),e});Object.defineProperty(e,"__esModule",{value:!0}),e.createStateTools=function(t){return{async consoleMessages(t){const e=await(0,c.resolveViewId)(t.viewId);if(!e)return{content:[{type:"text",text:"No browser tab available. Please navigate to a page first."}]};await(0,c.ensureCurrentPageAllowed)("browser_console_messages",e);const n=await a.commands.executeCommand("cursor.browserView.getConsoleLogs",e);return{content:[{type:"text",text:JSON.stringify(n,null,2)},{type:"metadata",viewId:e}]}},async networkRequests(t){const e=await(0,c.resolveViewId)(t.viewId);if(!e)return{content:[{type:"text",text:"No browser tab available. Please navigate to a page first."}]};await(0,c.ensureCurrentPageAllowed)("browser_network_requests",e);const n=await a.commands.executeCommand("cursor.browserView.getNetworkRequests",e);return{content:[{type:"text",text:JSON.stringify(n,null,2)},{type:"metadata",viewId:e}]}},async takeScreenshot(t){const e=await(0,c.resolveViewId)(t.viewId);if(!e)return{content:[{type:"text",text:"No browser tab available. Please navigate to a page first."}]};await(0,c.ensureCurrentPageAllowed)("browser_take_screenshot",e);let n={...t,viewId:e,headless:t.headless};if(t.filename&&!/\.[a-zA-Z0-9]+$/.test(t.filename)){const e=t.type||"png";n={...n,filename:`${t.filename}.${e}`}}const r=new Promise(t=>{setTimeout(()=>{t({success:!1,error:"screen shot timed out, please try again"})},5e3)}),o=a.commands.executeCommand("cursor.browserView.takeScreenshot",n),s=await Promise.race([o,r]);if(!s.success||s.error)return{content:[{type:"text",text:`Screenshot failed: ${s.error||"Unknown error"}`}]};if(s.dataUrl){try{const t=await a.commands.executeCommand(c.BROWSER_GET_URL_COMMAND,e);await a.commands.executeCommand("cursor.browserView.updateScreenshot",e,s.dataUrl,t)}catch(t){c.CursorIDEBrowserLogger.warn(`Failed to update screenshot service: ${t}`)}const t=s.dataUrl.match(/^data:([^;]+);base64,(.+)$/);if(t){const n=t[1],r=t[2],o=["Screenshot captured successfully"];return s.filename&&o.push(`Filename: ${s.filename}`),s.savedPath&&o.push(`Saved to: ${s.savedPath}`),{content:[{type:"text",text:o.join("\n")},{type:"image",data:r,mimeType:n},{type:"metadata",viewId:e}]}}}return{content:[{type:"text",text:s.savedPath?`Screenshot saved to: ${s.savedPath}`:"Screenshot captured but no image data available"},{type:"metadata",viewId:e}]}},async resize(t){const e=await(0,c.resolveViewId)(t.viewId);if(!e)return{content:[{type:"text",text:"No browser tab available. Please navigate to a page first."}]};await(0,c.ensureCurrentPageAllowed)("browser_resize",e);const{success:n}=await a.commands.executeCommand("cursor.browserView.resize",{...t,viewId:e,headless:t.headless});if(!n)return{content:[{type:"text",text:"Failed to resize browser"}]};const r={content:[{type:"text",text:"Successfully resized browser"},{type:"metadata",viewId:e}]};return(0,c.maybeAddScreenshotToResult)(r,e,t.take_screenshot_afterwards??!1)},async scroll(t){const e=await(0,c.resolveViewId)(t.viewId);if(!e)return{content:[{type:"text",text:"No browser tab available. Please navigate to a page first."}]};await(0,c.ensureCurrentPageAllowed)("browser_scroll",e);let n=t.deltaX??0,r=t.deltaY??0;const o=t.amount??300;if(t.direction)switch(t.direction){case"up":r=-o;break;case"down":r=o;break;case"left":n=-o;break;case"right":n=o}const s=t.scrollIntoView??(t.ref&&0===n&&0===r),i=t.ref?(0,c.parseRef)(t.ref):void 0,a=`\n\t\t\t\t(async function() {\n\t\t\t\t\t${c.ELEMENT_FINDER}\n\n\t\t\t\t\tconst ref = ${JSON.stringify(i)};\n\t\t\t\t\tconst deltaX = ${n};\n\t\t\t\t\tconst deltaY = ${r};\n\t\t\t\t\tconst scrollIntoView = ${s};\n\n\t\t\t\t\tfunction getScrollableAncestors(el) {\n\t\t\t\t\t\tconst ancestors = [];\n\t\t\t\t\t\tlet current = el.parentElement;\n\t\t\t\t\t\twhile (current && current !== document.body && current !== document.documentElement) {\n\t\t\t\t\t\t\tconst style = window.getComputedStyle(current);\n\t\t\t\t\t\t\tconst overflowY = style.overflowY;\n\t\t\t\t\t\t\tconst overflowX = style.overflowX;\n\t\t\t\t\t\t\tconst isScrollable = (\n\t\t\t\t\t\t\t\t(overflowY === 'auto' || overflowY === 'scroll' || overflowX === 'auto' || overflowX === 'scroll') &&\n\t\t\t\t\t\t\t\t(current.scrollHeight > current.clientHeight || current.scrollWidth > current.clientWidth)\n\t\t\t\t\t\t\t);\n\t\t\t\t\t\t\tif (isScrollable) {\n\t\t\t\t\t\t\t\tancestors.push(current);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tcurrent = current.parentElement;\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn ancestors;\n\t\t\t\t\t}\n\n\t\t\t\t\tfunction isElementVisibleInContainer(el, container) {\n\t\t\t\t\t\tconst elRect = el.getBoundingClientRect();\n\t\t\t\t\t\tconst containerRect = container.getBoundingClientRect();\n\t\t\t\t\t\tconst padding = 10;\n\t\t\t\t\t\treturn (\n\t\t\t\t\t\t\telRect.top >= containerRect.top - padding &&\n\t\t\t\t\t\t\telRect.bottom <= containerRect.bottom + padding &&\n\t\t\t\t\t\t\telRect.left >= containerRect.left - padding &&\n\t\t\t\t\t\t\telRect.right <= containerRect.right + padding\n\t\t\t\t\t\t);\n\t\t\t\t\t}\n\n\t\t\t\t\tfunction scrollElementIntoContainer(el, container) {\n\t\t\t\t\t\tconst elRect = el.getBoundingClientRect();\n\t\t\t\t\t\tconst containerRect = container.getBoundingClientRect();\n\t\t\t\t\t\t\n\t\t\t\t\t\tlet scrollTopDelta = 0;\n\t\t\t\t\t\tlet scrollLeftDelta = 0;\n\t\t\t\t\t\t\n\t\t\t\t\t\tconst elCenterY = elRect.top + elRect.height / 2;\n\t\t\t\t\t\tconst containerCenterY = containerRect.top + containerRect.height / 2;\n\t\t\t\t\t\tconst elCenterX = elRect.left + elRect.width / 2;\n\t\t\t\t\t\tconst containerCenterX = containerRect.left + containerRect.width / 2;\n\t\t\t\t\t\t\n\t\t\t\t\t\tscrollTopDelta = elCenterY - containerCenterY;\n\t\t\t\t\t\tscrollLeftDelta = elCenterX - containerCenterX;\n\t\t\t\t\t\t\n\t\t\t\t\t\tif (Math.abs(scrollTopDelta) > 5 || Math.abs(scrollLeftDelta) > 5) {\n\t\t\t\t\t\t\tcontainer.scrollBy({ top: scrollTopDelta, left: scrollLeftDelta, behavior: 'instant' });\n\t\t\t\t\t\t\treturn true;\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (ref) {\n\t\t\t\t\t\tconst { element } = findElementByRef(ref);\n\t\t\t\t\t\tif (!element) {\n\t\t\t\t\t\t\treturn {\n\t\t\t\t\t\t\t\tsuccess: false,\n\t\t\t\t\t\t\t\terror: 'Element not found: ' + ref + '. Take a snapshot to get updated refs.'\n\t\t\t\t\t\t\t};\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif (scrollIntoView) {\n\t\t\t\t\t\t\tconst scrollableAncestors = getScrollableAncestors(element);\n\t\t\t\t\t\t\tlet scrolledContainers = 0;\n\t\t\t\t\t\t\t\n\t\t\t\t\t\t\tfor (const container of scrollableAncestors) {\n\t\t\t\t\t\t\t\tif (!isElementVisibleInContainer(element, container)) {\n\t\t\t\t\t\t\t\t\tscrollElementIntoContainer(element, container);\n\t\t\t\t\t\t\t\t\tscrolledContainers++;\n\t\t\t\t\t\t\t\t\tawait new Promise(r => setTimeout(r, 100));\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\n\t\t\t\t\t\t\telement.scrollIntoView({ behavior: 'smooth', block: 'center', inline: 'center' });\n\t\t\t\t\t\t\tawait new Promise(r => setTimeout(r, 200));\n\t\t\t\t\t\t\t\n\t\t\t\t\t\t\tconst finalRect = element.getBoundingClientRect();\n\t\t\t\t\t\t\tconst isVisible = finalRect.top >= 0 && finalRect.bottom <= window.innerHeight &&\n\t\t\t\t\t\t\t\tfinalRect.left >= 0 && finalRect.right <= window.innerWidth;\n\t\t\t\t\t\t\t\n\t\t\t\t\t\t\treturn {\n\t\t\t\t\t\t\t\tsuccess: true,\n\t\t\t\t\t\t\t\taction: 'scrollIntoView',\n\t\t\t\t\t\t\t\tref: ref,\n\t\t\t\t\t\t\t\tscrolledContainers: scrolledContainers,\n\t\t\t\t\t\t\t\tisNowVisible: isVisible,\n\t\t\t\t\t\t\t\tmessage: 'Scrolled element into view' + (scrolledContainers > 0 ? ' (scrolled ' + scrolledContainers + ' nested container(s))' : '') + (isVisible ? '' : ' (element may still be partially obscured)')\n\t\t\t\t\t\t\t};\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tconst scrollableParent = getScrollableAncestors(element)[0];\n\n\t\t\t\t\t\t\tif (scrollableParent) {\n\t\t\t\t\t\t\t\tconst beforeX = scrollableParent.scrollLeft;\n\t\t\t\t\t\t\t\tconst beforeY = scrollableParent.scrollTop;\n\t\t\t\t\t\t\t\tscrollableParent.scrollBy({ left: deltaX, top: deltaY, behavior: 'smooth' });\n\t\t\t\t\t\t\t\tawait new Promise(r => setTimeout(r, 200));\n\t\t\t\t\t\t\t\tconst actualDeltaX = scrollableParent.scrollLeft - beforeX;\n\t\t\t\t\t\t\t\tconst actualDeltaY = scrollableParent.scrollTop - beforeY;\n\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\tconst containerRef = scrollableParent.getAttribute('data-cursor-ref');\n\t\t\t\t\t\t\t\treturn {\n\t\t\t\t\t\t\t\t\tsuccess: true,\n\t\t\t\t\t\t\t\t\taction: 'scrollContainer',\n\t\t\t\t\t\t\t\t\tref: ref,\n\t\t\t\t\t\t\t\t\tcontainerRef: containerRef || undefined,\n\t\t\t\t\t\t\t\t\tscrolled: { deltaX: actualDeltaX, deltaY: actualDeltaY },\n\t\t\t\t\t\t\t\t\tmessage: 'Scrolled container by (' + actualDeltaX + ', ' + actualDeltaY + ') pixels'\n\t\t\t\t\t\t\t\t};\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\treturn {\n\t\t\t\t\t\t\t\t\tsuccess: false,\n\t\t\t\t\t\t\t\t\terror: 'Element ' + ref + ' is not inside a scrollable container.',\n\t\t\t\t\t\t\t\t\tsuggestion: 'Use scrollIntoView: true to scroll the element into view using the standard scrollIntoView method, or omit the ref to scroll the main page.'\n\t\t\t\t\t\t\t\t};\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t} else {\n\t\t\t\t\t\tconst beforeX = window.scrollX;\n\t\t\t\t\t\tconst beforeY = window.scrollY;\n\t\t\t\t\t\twindow.scrollBy({ left: deltaX, top: deltaY, behavior: 'smooth' });\n\t\t\t\t\t\tawait new Promise(r => setTimeout(r, 200));\n\t\t\t\t\t\tconst actualDeltaX = window.scrollX - beforeX;\n\t\t\t\t\t\tconst actualDeltaY = window.scrollY - beforeY;\n\n\t\t\t\t\t\tif (actualDeltaX === 0 && actualDeltaY === 0 && (deltaX !== 0 || deltaY !== 0)) {\n\t\t\t\t\t\t\treturn {\n\t\t\t\t\t\t\t\tsuccess: true,\n\t\t\t\t\t\t\t\taction: 'scroll',\n\t\t\t\t\t\t\t\twarning: 'Page may have reached scroll boundary',\n\t\t\t\t\t\t\t\tmessage: 'Attempted to scroll page, but no scroll occurred (may be at edge)'\n\t\t\t\t\t\t\t};\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn {\n\t\t\t\t\t\t\tsuccess: true,\n\t\t\t\t\t\t\taction: 'scroll',\n\t\t\t\t\t\t\tscrolled: { deltaX: actualDeltaX, deltaY: actualDeltaY },\n\t\t\t\t\t\t\tmessage: 'Scrolled page by (' + actualDeltaX + ', ' + actualDeltaY + ') pixels'\n\t\t\t\t\t\t};\n\t\t\t\t\t}\n\t\t\t\t})();\n\t\t\t`,l=(0,c.validateBrowserResult)(await(0,c.executeInBrowser)(a,e,t.headless),[]);if(!l.success){const e=(0,c.toAIFriendlyError)(l.error||"Unknown scroll error",{ref:t.ref});return{content:[{type:"text",text:(0,c.formatAIFriendlyError)(e)}]}}const u=["### Action: scroll"];u.push(`- ${l.message}`),l.scrolled&&u.push(`- Actual scroll: (${l.scrolled.deltaX}px, ${l.scrolled.deltaY}px)`),l.warning&&u.push(`- Warning: ${l.warning}`);const d={content:[{type:"text",text:u.join("\n")},{type:"metadata",viewId:e}]};return(0,c.maybeAddScreenshotToResult)(d,e,t.take_screenshot_afterwards??!1)},async handleDialog(t){const e=await(0,c.resolveViewId)(t.viewId);if(!e)return{content:[{type:"text",text:"No browser tab available. Please navigate to a page first."}]};await(0,c.ensureCurrentPageAllowed)("browser_handle_dialog",e);const n=await a.commands.executeCommand("cursor.browserView.configureDialogHandling",{viewId:e,accept:t.accept,promptText:t.promptText,headless:t.headless});if(!n?.success)return{content:[{type:"text",text:"Failed to configure dialog handling."}]};const r=["### Action: handle_dialog"];if(r.push("- Future dialogs will be "+("accept"===n.action?"accepted":"dismissed")),void 0!==n.promptText&&r.push(`- Prompt responses will use: "${n.promptText}"`),n.recentDialogs&&n.recentDialogs.length>0){r.push("\n### Recent dialogs:");for(const t of n.recentDialogs.slice(-5)){const e=new Date(t.timestamp).toLocaleTimeString();r.push(`- [${e}] ${t.type}: "${t.message.substring(0,50)}${t.message.length>50?"...":""}" (${t.handled?t.response:"pending"})`)}}return{content:[{type:"text",text:r.join("\n")},{type:"metadata",viewId:e}]}},async lock(t){const e=await(0,c.resolveViewId)(t.viewId);if(!e)return{content:[{type:"text",text:"No browser tab available. Please navigate to a page first."}]};const n=await a.commands.executeCommand("cursor.browserView.setLocked",e,!0);return n?.success?{content:[{type:"text",text:'Browser locked. User interaction is now blocked. The user can click "Take Control" to unlock if needed.'},await(0,c.createMetadata)(e)]}:{content:[{type:"text",text:"Failed to lock browser."}]}},async unlock(t){const e=await(0,c.resolveViewId)(t.viewId);if(!e)return{content:[{type:"text",text:"No browser tab available."}]};const n=await a.commands.executeCommand("cursor.browserView.setLocked",e,!1);return n?.success?{content:[{type:"text",text:"Browser unlocked. User can now interact with the browser."},await(0,c.createMetadata)(e)]}:{content:[{type:"text",text:"Failed to unlock browser."}]}},async evaluate(t){const e=await(0,c.resolveViewId)(t.viewId);if(!e)return{content:[{type:"text",text:"No browser tab available. Please navigate to a page first."}]};await(0,c.ensureCurrentPageAllowed)("browser_evaluate",e);try{!function(t){for(const{pattern:e,description:n}of u)if(e.test(t))throw new Error(`Script contains blocked pattern (${n}). browser_evaluate cannot access sensitive browser APIs like cookies, localStorage, or credentials.`)}(t.script)}catch(t){return{content:[{type:"text",text:t instanceof Error?t.message:String(t)}]}}const n=`\n\t\t\t\t(async function() {\n\t\t\t\t\tfunction serializeValue(value) {\n\t\t\t\t\t\tconst maxDepth = 3;\n\t\t\t\t\t\tconst maxArray = 20;\n\t\t\t\t\t\tconst maxString = 4000;\n\t\t\t\t\t\tconst seen = new WeakSet();\n\n\t\t\t\t\t\tfunction helper(val, depth) {\n\t\t\t\t\t\t\tif (val === null || val === undefined) return val;\n\t\t\t\t\t\t\tconst type = typeof val;\n\t\t\t\t\t\t\tif (type === 'string') {\n\t\t\t\t\t\t\t\treturn val.length > maxString ? val.substring(0, maxString) + '...' : val;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tif (type === 'number' || type === 'boolean' || type === 'bigint') return val;\n\t\t\t\t\t\t\tif (type === 'function') return '[function]';\n\t\t\t\t\t\t\tif (type === 'symbol') return '[symbol]';\n\t\t\t\t\t\t\tif (val instanceof Node) return '[dom-node]';\n\t\t\t\t\t\t\tif (val instanceof Window) return '[window]';\n\t\t\t\t\t\t\tif (val instanceof Document) return '[document]';\n\t\t\t\t\t\t\tif (depth >= maxDepth) return '[max-depth]';\n\t\t\t\t\t\t\tif (typeof val === 'object') {\n\t\t\t\t\t\t\t\tif (seen.has(val)) return '[circular]';\n\t\t\t\t\t\t\t\tseen.add(val);\n\t\t\t\t\t\t\t\tif (Array.isArray(val)) {\n\t\t\t\t\t\t\t\t\treturn val.slice(0, maxArray).map(item => helper(item, depth + 1));\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\tconst out = {};\n\t\t\t\t\t\t\t\tfor (const key of Object.keys(val)) {\n\t\t\t\t\t\t\t\t\tout[key] = helper(val[key], depth + 1);\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\treturn out;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\treturn String(val);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn helper(value, 0);\n\t\t\t\t\t}\n\n\t\t\t\t\ttry {\n\t\t\t\t\t\tconst script = ${JSON.stringify(t.script)};\n\t\t\t\t\t\tconst AsyncFunction = Object.getPrototypeOf(async function() {}).constructor;\n\t\t\t\t\t\tconst evaluator = new AsyncFunction(script);\n\t\t\t\t\t\tconst value = await evaluator();\n\t\t\t\t\t\tconst serialized = serializeValue(value);\n\t\t\t\t\t\treturn {\n\t\t\t\t\t\t\tsuccess: true,\n\t\t\t\t\t\t\tvalue: typeof serialized === 'string' ? serialized : JSON.stringify(serialized),\n\t\t\t\t\t\t\tvalueType: typeof value\n\t\t\t\t\t\t};\n\t\t\t\t\t} catch (err) {\n\t\t\t\t\t\tconst message = err instanceof Error ? err.message : String(err);\n\t\t\t\t\t\treturn { success: false, error: message };\n\t\t\t\t\t}\n\t\t\t\t})();\n\t\t\t`,r=(0,c.validateBrowserResult)(await(0,c.executeInBrowser)(n,e,t.headless),[]);return r.success?{content:[{type:"text",text:`Evaluation result (${r.valueType}): ${r.value}`},{type:"metadata",viewId:e}]}:{content:[{type:"text",text:`Evaluation failed: ${r.error}`}]}},async getAttribute(t){const e=await(0,c.resolveViewId)(t.viewId);if(!e)return{content:[{type:"text",text:"No browser tab available. Please navigate to a page first."}]};try{await(0,c.ensureCurrentPageAllowed)("browser_get_attribute",e),await(0,c.ensureFreshSnapshot)(e,t.headless,l.BROWSER_UTILS);const n=(0,c.parseRef)(t.ref),r=t.element||"",o=`\n\t\t\t\t\t${c.ELEMENT_FINDER}\n\t\t\t\t\t(function() {\n\t\t\t\t\t\tconst ref = ${JSON.stringify(n)};\n\t\t\t\t\t\tconst expectedDescription = ${JSON.stringify(r)};\n\t\t\t\t\t\tconst attributeName = ${JSON.stringify(t.name)};\n\t\t\t\t\t\tconst { element } = findElementByRef(ref);\n\t\t\t\t\t\tif (!element) {\n\t\t\t\t\t\t\treturn { success: false, error: 'Element not found: ' + ref + '. Take a snapshot to get updated refs.' };\n\t\t\t\t\t\t}\n\t\t\t\t\t\tassertDescriptionMatches(element, ref, expectedDescription);\n\t\t\t\t\t\treturn {\n\t\t\t\t\t\t\tsuccess: true,\n\t\t\t\t\t\t\tname: attributeName,\n\t\t\t\t\t\t\tvalue: element.getAttribute(attributeName)\n\t\t\t\t\t\t};\n\t\t\t\t\t})();\n\t\t\t\t`,s=(0,c.validateBrowserResult)(await(0,c.executeInBrowser)(o,e,t.headless),["name"]);if(!s.success){const e=(0,c.toAIFriendlyError)(s.error||"Failed to read attribute",{ref:t.ref});return{content:[{type:"text",text:(0,c.formatAIFriendlyError)(e)}]}}const i=null===s.value?"(null)":s.value;return{content:[{type:"text",text:`Attribute "${s.name}": ${i}`},{type:"metadata",viewId:e}]}}catch(e){const n=(0,c.toAIFriendlyError)(e instanceof Error?e:new Error(String(e)),{ref:t.ref,action:"get_attribute"});return{content:[{type:"text",text:(0,c.formatAIFriendlyError)(n)}]}}},async getInputValue(t){const e=await(0,c.resolveViewId)(t.viewId);if(!e)return{content:[{type:"text",text:"No browser tab available. Please navigate to a page first."}]};try{await(0,c.ensureCurrentPageAllowed)("browser_get_input_value",e),await(0,c.ensureFreshSnapshot)(e,t.headless,l.BROWSER_UTILS);const n=(0,c.parseRef)(t.ref),r=t.element||"",o=`\n\t\t\t\t\t${c.ELEMENT_FINDER}\n\t\t\t\t\t(function() {\n\t\t\t\t\t\tconst ref = ${JSON.stringify(n)};\n\t\t\t\t\t\tconst expectedDescription = ${JSON.stringify(r)};\n\t\t\t\t\t\tconst { element } = findElementByRef(ref);\n\t\t\t\t\t\tif (!element) {\n\t\t\t\t\t\t\treturn { success: false, error: 'Element not found: ' + ref + '. Take a snapshot to get updated refs.' };\n\t\t\t\t\t\t}\n\t\t\t\t\t\tassertDescriptionMatches(element, ref, expectedDescription);\n\t\t\t\t\t\tconst tag = element.tagName ? element.tagName.toLowerCase() : '';\n\t\t\t\t\t\tconst type = element.getAttribute('type') || '';\n\t\t\t\t\t\tif (tag === 'input' && type.toLowerCase() === 'password') {\n\t\t\t\t\t\t\treturn { success: true, value: null };\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif (element.isContentEditable) {\n\t\t\t\t\t\t\treturn { success: true, value: element.textContent || '' };\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn { success: true, value: element.value !== undefined ? String(element.value) : (element.textContent || '') };\n\t\t\t\t\t})();\n\t\t\t\t`,s=(0,c.validateBrowserResult)(await(0,c.executeInBrowser)(o,e,t.headless),[]);if(!s.success){const e=(0,c.toAIFriendlyError)(s.error||"Failed to read value",{ref:t.ref});return{content:[{type:"text",text:(0,c.formatAIFriendlyError)(e)}]}}return{content:[{type:"text",text:`Input value: ${null===s.value?"(masked)":s.value}`},{type:"metadata",viewId:e}]}}catch(e){const n=(0,c.toAIFriendlyError)(e instanceof Error?e:new Error(String(e)),{ref:t.ref,action:"get_input_value"});return{content:[{type:"text",text:(0,c.formatAIFriendlyError)(n)}]}}},async isVisible(t){const e=await(0,c.resolveViewId)(t.viewId);if(!e)return{content:[{type:"text",text:"No browser tab available. Please navigate to a page first."}]};try{await(0,c.ensureCurrentPageAllowed)("browser_is_visible",e),await(0,c.ensureFreshSnapshot)(e,t.headless,l.BROWSER_UTILS);const n=(0,c.parseRef)(t.ref),r=t.element||"",o=`\n\t\t\t\t\t${c.ELEMENT_FINDER}\n\t\t\t\t\t(function() {\n\t\t\t\t\t\tconst ref = ${JSON.stringify(n)};\n\t\t\t\t\t\tconst expectedDescription = ${JSON.stringify(r)};\n\t\t\t\t\t\tconst { element } = findElementByRef(ref);\n\t\t\t\t\t\tif (!element) {\n\t\t\t\t\t\t\treturn { success: true, state: false, reason: 'Element not found' };\n\t\t\t\t\t\t}\n\t\t\t\t\t\tassertDescriptionMatches(element, ref, expectedDescription);\n\t\t\t\t\t\tif (element.getAttribute('aria-hidden') === 'true') {\n\t\t\t\t\t\t\treturn { success: true, state: false, reason: 'aria-hidden' };\n\t\t\t\t\t\t}\n\t\t\t\t\t\tconst style = window.getComputedStyle(element);\n\t\t\t\t\t\tif (style.display === 'none') {\n\t\t\t\t\t\t\treturn { success: true, state: false, reason: 'display none' };\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif (style.visibility === 'hidden') {\n\t\t\t\t\t\t\treturn { success: true, state: false, reason: 'visibility hidden' };\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif (parseFloat(style.opacity) === 0) {\n\t\t\t\t\t\t\treturn { success: true, state: false, reason: 'opacity 0' };\n\t\t\t\t\t\t}\n\t\t\t\t\t\tconst rect = element.getBoundingClientRect();\n\t\t\t\t\t\tif (rect.width === 0 && rect.height === 0) {\n\t\t\t\t\t\t\treturn { success: true, state: false, reason: 'zero size' };\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn { success: true, state: true };\n\t\t\t\t\t})();\n\t\t\t\t`,s=(0,c.validateBrowserResult)(await(0,c.executeInBrowser)(o,e,t.headless),["state"]);return{content:[{type:"text",text:"Visibility: "+(s.state?"visible":`not visible (${s.reason||"no reason"})`)},{type:"metadata",viewId:e}]}}catch(e){const n=(0,c.toAIFriendlyError)(e instanceof Error?e:new Error(String(e)),{ref:t.ref,action:"is_visible"});return{content:[{type:"text",text:(0,c.formatAIFriendlyError)(n)}]}}},async isEnabled(t){const e=await(0,c.resolveViewId)(t.viewId);if(!e)return{content:[{type:"text",text:"No browser tab available. Please navigate to a page first."}]};try{await(0,c.ensureCurrentPageAllowed)("browser_is_enabled",e),await(0,c.ensureFreshSnapshot)(e,t.headless,l.BROWSER_UTILS);const n=(0,c.parseRef)(t.ref),r=t.element||"",o=`\n\t\t\t\t\t${c.ELEMENT_FINDER}\n\t\t\t\t\t(function() {\n\t\t\t\t\t\tconst ref = ${JSON.stringify(n)};\n\t\t\t\t\t\tconst expectedDescription = ${JSON.stringify(r)};\n\t\t\t\t\t\tconst { element } = findElementByRef(ref);\n\t\t\t\t\t\tif (!element) {\n\t\t\t\t\t\t\treturn { success: true, state: false, reason: 'Element not found' };\n\t\t\t\t\t\t}\n\t\t\t\t\t\tassertDescriptionMatches(element, ref, expectedDescription);\n\t\t\t\t\t\tif (element.disabled) {\n\t\t\t\t\t\t\treturn { success: true, state: false, reason: 'disabled attribute' };\n\t\t\t\t\t\t}\n\t\t\t\t\t\tlet parent = element.parentElement;\n\t\t\t\t\t\twhile (parent) {\n\t\t\t\t\t\t\tif (parent.tagName === 'FIELDSET' && parent.disabled) {\n\t\t\t\t\t\t\t\treturn { success: true, state: false, reason: 'disabled fieldset' };\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tparent = parent.parentElement;\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn { success: true, state: true };\n\t\t\t\t\t})();\n\t\t\t\t`,s=(0,c.validateBrowserResult)(await(0,c.executeInBrowser)(o,e,t.headless),["state"]);return{content:[{type:"text",text:"Enabled: "+(s.state?"enabled":`disabled (${s.reason||"no reason"})`)},{type:"metadata",viewId:e}]}}catch(e){const n=(0,c.toAIFriendlyError)(e instanceof Error?e:new Error(String(e)),{ref:t.ref,action:"is_enabled"});return{content:[{type:"text",text:(0,c.formatAIFriendlyError)(n)}]}}},async isChecked(t){const e=await(0,c.resolveViewId)(t.viewId);if(!e)return{content:[{type:"text",text:"No browser tab available. Please navigate to a page first."}]};try{await(0,c.ensureCurrentPageAllowed)("browser_is_checked",e),await(0,c.ensureFreshSnapshot)(e,t.headless,l.BROWSER_UTILS);const n=(0,c.parseRef)(t.ref),r=t.element||"",o=`\n\t\t\t\t\t${c.ELEMENT_FINDER}\n\t\t\t\t\t(function() {\n\t\t\t\t\t\tconst ref = ${JSON.stringify(n)};\n\t\t\t\t\t\tconst expectedDescription = ${JSON.stringify(r)};\n\t\t\t\t\t\tconst { element } = findElementByRef(ref);\n\t\t\t\t\t\tif (!element) {\n\t\t\t\t\t\t\treturn { success: true, state: false, reason: 'Element not found' };\n\t\t\t\t\t\t}\n\t\t\t\t\t\tassertDescriptionMatches(element, ref, expectedDescription);\n\t\t\t\t\t\tconst ariaChecked = element.getAttribute('aria-checked');\n\t\t\t\t\t\tif (ariaChecked === 'true') {\n\t\t\t\t\t\t\treturn { success: true, state: true };\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif (ariaChecked === 'false') {\n\t\t\t\t\t\t\treturn { success: true, state: false };\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif (element.matches && element.matches(':checked')) {\n\t\t\t\t\t\t\treturn { success: true, state: true };\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn { success: true, state: false };\n\t\t\t\t\t})();\n\t\t\t\t`;return{content:[{type:"text",text:"Checked: "+((0,c.validateBrowserResult)(await(0,c.executeInBrowser)(o,e,t.headless),["state"]).state?"yes":"no")},{type:"metadata",viewId:e}]}}catch(e){const n=(0,c.toAIFriendlyError)(e instanceof Error?e:new Error(String(e)),{ref:t.ref,action:"is_checked"});return{content:[{type:"text",text:(0,c.formatAIFriendlyError)(n)}]}}},async getBoundingBox(t){const e=await(0,c.resolveViewId)(t.viewId);if(!e)return{content:[{type:"text",text:"No browser tab available. Please navigate to a page first."}]};try{await(0,c.ensureCurrentPageAllowed)("browser_get_bounding_box",e),await(0,c.ensureFreshSnapshot)(e,t.headless,l.BROWSER_UTILS);const n=(0,c.parseRef)(t.ref),r=t.element||"",o=`\n\t\t\t\t\t${c.ELEMENT_FINDER}\n\t\t\t\t\t(function() {\n\t\t\t\t\t\tconst ref = ${JSON.stringify(n)};\n\t\t\t\t\t\tconst expectedDescription = ${JSON.stringify(r)};\n\t\t\t\t\t\tconst { element } = findElementByRef(ref);\n\t\t\t\t\t\tif (!element) {\n\t\t\t\t\t\t\treturn { success: false, error: 'Element not found: ' + ref + '. Take a snapshot to get updated refs.' };\n\t\t\t\t\t\t}\n\t\t\t\t\t\tassertDescriptionMatches(element, ref, expectedDescription);\n\t\t\t\t\t\tconst rect = element.getBoundingClientRect();\n\t\t\t\t\t\tconst x = rect.left + window.scrollX;\n\t\t\t\t\t\tconst y = rect.top + window.scrollY;\n\t\t\t\t\t\treturn {\n\t\t\t\t\t\t\tsuccess: true,\n\t\t\t\t\t\t\tbox: {\n\t\t\t\t\t\t\t\tx,\n\t\t\t\t\t\t\t\ty,\n\t\t\t\t\t\t\t\twidth: rect.width,\n\t\t\t\t\t\t\t\theight: rect.height,\n\t\t\t\t\t\t\t\ttop: rect.top,\n\t\t\t\t\t\t\t\tleft: rect.left,\n\t\t\t\t\t\t\t\tright: rect.right,\n\t\t\t\t\t\t\t\tbottom: rect.bottom\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t};\n\t\t\t\t\t})();\n\t\t\t\t`,s=(0,c.validateBrowserResult)(await(0,c.executeInBrowser)(o,e,t.headless),["box"]).box;return{content:[{type:"text",text:`Bounding box: x=${Math.round(s.x)}, y=${Math.round(s.y)}, w=${Math.round(s.width)}, h=${Math.round(s.height)}`},{type:"metadata",viewId:e}]}}catch(e){const n=(0,c.toAIFriendlyError)(e instanceof Error?e:new Error(String(e)),{ref:t.ref,action:"get_bounding_box"});return{content:[{type:"text",text:(0,c.formatAIFriendlyError)(n)}]}}},async highlight(t){const e=await(0,c.resolveViewId)(t.viewId);if(!e)return{content:[{type:"text",text:"No browser tab available. Please navigate to a page first."}]};try{await(0,c.ensureCurrentPageAllowed)("browser_highlight",e),await(0,c.ensureFreshSnapshot)(e,t.headless,l.BROWSER_UTILS);const n=(0,c.parseRef)(t.ref),r=t.element||"",o=t.durationMs??2e3,s=`\n\t\t\t\t\t${c.ELEMENT_FINDER}\n\t\t\t\t\t(function() {\n\t\t\t\t\t\tconst ref = ${JSON.stringify(n)};\n\t\t\t\t\t\tconst expectedDescription = ${JSON.stringify(r)};\n\t\t\t\t\t\tconst durationMs = ${o};\n\t\t\t\t\t\tconst { element } = findElementByRef(ref);\n\t\t\t\t\t\tif (!element) {\n\t\t\t\t\t\t\treturn { success: false, error: 'Element not found: ' + ref + '. Take a snapshot to get updated refs.' };\n\t\t\t\t\t\t}\n\t\t\t\t\t\tassertDescriptionMatches(element, ref, expectedDescription);\n\n\t\t\t\t\t\tconst styleId = 'cursor-highlight-style';\n\t\t\t\t\t\tif (!document.getElementById(styleId)) {\n\t\t\t\t\t\t\tconst style = document.createElement('style');\n\t\t\t\t\t\t\tstyle.id = styleId;\n\t\t\t\t\t\t\tstyle.textContent = '.cursor-highlighted { outline: 2px solid #ff6a00; box-shadow: 0 0 0 2px rgba(255, 106, 0, 0.4); }';\n\t\t\t\t\t\t\tdocument.head.appendChild(style);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\telement.classList.add('cursor-highlighted');\n\t\t\t\t\t\tsetTimeout(() => {\n\t\t\t\t\t\t\telement.classList.remove('cursor-highlighted');\n\t\t\t\t\t\t}, durationMs);\n\n\t\t\t\t\t\treturn { success: true, durationMs };\n\t\t\t\t\t})();\n\t\t\t\t`;return{content:[{type:"text",text:`Highlighted element for ${(0,c.validateBrowserResult)(await(0,c.executeInBrowser)(s,e,t.headless),["durationMs"]).durationMs}ms`},{type:"metadata",viewId:e}]}}catch(e){const n=(0,c.toAIFriendlyError)(e instanceof Error?e:new Error(String(e)),{ref:t.ref,action:"highlight"});return{content:[{type:"text",text:(0,c.formatAIFriendlyError)(n)}]}}}}};const a=i(n(398)),l=n(8),c=n(376),u=[{pattern:/document\.cookie/i,description:"cookie access"},{pattern:/localStorage(?:\s*\[|\s*\.)/i,description:"localStorage access"},{pattern:/sessionStorage(?:\s*\[|\s*\.)/i,description:"sessionStorage access"},{pattern:/\.getItem\s*\(\s*['"][^'"]*['"]\s*\)/i,description:"storage getItem access"},{pattern:/\.setItem\s*\(/i,description:"storage setItem access"},{pattern:/indexedDB/i,description:"IndexedDB access"},{pattern:/navigator\.credentials/i,description:"credentials API access"},{pattern:/navigator\.sendBeacon/i,description:"sendBeacon API"}]},149:(t,e,n)=>{Object.defineProperty(e,"__esModule",{value:!0}),e.createSnapshotTools=function(t){return{async snapshot(t){const e=await(0,o.resolveViewId)(t.viewId);if(!e)return{content:[{type:"text",text:"No browser tab available. Please navigate to a page first."}]};await(0,o.ensureCurrentPageAllowed)("browser_snapshot",e);const n={interactive:t.interactive??!1,maxDepth:t.maxDepth??20,compact:t.compact??!1,selector:t.selector??null},s=`\n\t\t\t\t${r.BROWSER_UTILS}\n\t\t\t\t(function() {\n\t\t\t\t\tconst options = ${JSON.stringify(n)};\n\t\t\t\t\tconst result = buildPageSnapshot(options);\n\t\t\t\t\treturn {\n\t\t\t\t\t\tsuccess: true,\n\t\t\t\t\t\tpageState: {\n\t\t\t\t\t\t\turl: window.location.href,\n\t\t\t\t\t\t\ttitle: document.title,\n\t\t\t\t\t\t\tsnapshot: result.tree\n\t\t\t\t\t\t},\n\t\t\t\t\t\tstats: result.stats\n\t\t\t\t\t};\n\t\t\t\t})();\n\t\t\t`,i=await(0,o.executeInBrowser)(s,e,t.headless);o.viewSnapshotTimestamps.set(e,Date.now());const a=[];i.stats&&(a.push(`- Total refs: ${i.stats.totalRefs}`),a.push(`- Interactive refs: ${i.stats.interactiveRefs}`),t.interactive&&a.push("- Filter: interactive only"),t.compact&&a.push("- Filter: compact mode"),t.selector&&a.push(`- Selector: ${t.selector}`));const l=(0,o.accessibilityTreeToYaml)(i.pageState.snapshot),c=await(0,o.formatPageStateResult)({action:"snapshot",detailLines:a.length>0?a:void 0,pageState:i.pageState,viewId:e,snapshotYaml:l,includeSnapshotDiff:t.includeDiff??!1});return(0,o.setSnapshotYaml)(e,l),(0,o.maybeAddScreenshotToResult)(c,e,t.take_screenshot_afterwards??!1)},async search(e){const n=await(0,o.resolveViewId)(e.viewId);if(!n)return{content:[{type:"text",text:"No browser tab available. Please navigate to a page first."}]};await(0,o.ensureCurrentPageAllowed)("browser_search",n);const r=e.headless,s=`\n\t\t\t\t(function() {\n\t\t\t\t\tconst HIGHLIGHT_CLASS = 'cursor-search-highlight';\n\t\t\t\t\tconst CURRENT_HIGHLIGHT_CLASS = 'cursor-search-highlight-current';\n\n\t\t\t\t\tif (!document.getElementById('cursor-search-styles')) {\n\t\t\t\t\t\tconst style = document.createElement('style');\n\t\t\t\t\t\tstyle.id = 'cursor-search-styles';\n\t\t\t\t\t\tstyle.textContent = \`\n\t\t\t\t\t\t\t.\${HIGHLIGHT_CLASS} {\n\t\t\t\t\t\t\t\tbackground-color: #ffff00 !important;\n\t\t\t\t\t\t\t\tcolor: #000 !important;\n\t\t\t\t\t\t\t\tborder-radius: 2px;\n\t\t\t\t\t\t\t\tpadding: 0 1px;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t.\${CURRENT_HIGHLIGHT_CLASS} {\n\t\t\t\t\t\t\t\tbackground-color: #ff9632 !important;\n\t\t\t\t\t\t\t\tcolor: #000 !important;\n\t\t\t\t\t\t\t\tborder-radius: 2px;\n\t\t\t\t\t\t\t\tpadding: 0 1px;\n\t\t\t\t\t\t\t\toutline: 2px solid #ff6600;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\`;\n\t\t\t\t\t\tdocument.head.appendChild(style);\n\t\t\t\t\t}\n\n\t\t\t\t\tfunction clearHighlights() {\n\t\t\t\t\t\tconst highlights = document.querySelectorAll('.' + HIGHLIGHT_CLASS);\n\t\t\t\t\t\thighlights.forEach(function(el) {\n\t\t\t\t\t\t\tconst parent = el.parentNode;\n\t\t\t\t\t\t\tif (parent) {\n\t\t\t\t\t\t\t\tparent.replaceChild(document.createTextNode(el.textContent || ''), el);\n\t\t\t\t\t\t\t\tparent.normalize();\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t});\n\t\t\t\t\t}\n\n\t\t\t\t\tif (${JSON.stringify(e.clearHighlights)}) {\n\t\t\t\t\t\tclearHighlights();\n\t\t\t\t\t\treturn {\n\t\t\t\t\t\t\tsuccess: true,\n\t\t\t\t\t\t\taction: 'clear',\n\t\t\t\t\t\t\tmessage: 'Search highlights cleared'\n\t\t\t\t\t\t};\n\t\t\t\t\t}\n\n\t\t\t\t\tconst query = ${JSON.stringify(e.query||"")};\n\t\t\t\t\tif (!query) {\n\t\t\t\t\t\treturn {\n\t\t\t\t\t\t\tsuccess: false,\n\t\t\t\t\t\t\terror: 'No search query provided. Use "query" parameter to search, or "clearHighlights: true" to clear existing highlights.'\n\t\t\t\t\t\t};\n\t\t\t\t\t}\n\n\t\t\t\t\tclearHighlights();\n\n\t\t\t\t\tconst caseSensitive = ${JSON.stringify(e.caseSensitive||!1)};\n\t\t\t\t\tconst navigateToMatch = ${JSON.stringify(e.navigateToMatch??0)};\n\n\t\t\t\t\tfunction isElementVisible(el) {\n\t\t\t\t\t\tif (!el) return false;\n\t\t\t\t\t\tif (el.hidden || el.getAttribute('aria-hidden') === 'true') return false;\n\t\t\t\t\t\tconst style = window.getComputedStyle(el);\n\t\t\t\t\t\tif (style.display === 'none' || style.visibility === 'hidden' || style.opacity === '0') {\n\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t}\n\t\t\t\t\t\tconst rect = el.getBoundingClientRect();\n\t\t\t\t\t\tif (rect.width === 0 && rect.height === 0) return false;\n\t\t\t\t\t\tif (el.parentElement && el.parentElement !== document.body) {\n\t\t\t\t\t\t\treturn isElementVisible(el.parentElement);\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn true;\n\t\t\t\t\t}\n\n\t\t\t\t\tfunction getTextNodes(element) {\n\t\t\t\t\t\tconst nodes = [];\n\t\t\t\t\t\tconst walker = document.createTreeWalker(\n\t\t\t\t\t\t\telement,\n\t\t\t\t\t\t\tNodeFilter.SHOW_TEXT,\n\t\t\t\t\t\t\t{\n\t\t\t\t\t\t\t\tacceptNode: function(node) {\n\t\t\t\t\t\t\t\t\tconst parent = node.parentElement;\n\t\t\t\t\t\t\t\t\tif (!parent) return NodeFilter.FILTER_REJECT;\n\t\t\t\t\t\t\t\t\tconst tag = parent.tagName.toLowerCase();\n\t\t\t\t\t\t\t\t\tif (tag === 'script' || tag === 'style' || tag === 'noscript') {\n\t\t\t\t\t\t\t\t\t\treturn NodeFilter.FILTER_REJECT;\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\tif (parent.closest('script, style, noscript')) {\n\t\t\t\t\t\t\t\t\t\treturn NodeFilter.FILTER_REJECT;\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\tif (!isElementVisible(parent)) {\n\t\t\t\t\t\t\t\t\t\treturn NodeFilter.FILTER_REJECT;\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\tconst text = node.textContent || '';\n\t\t\t\t\t\t\t\t\tif (!text.trim()) return NodeFilter.FILTER_REJECT;\n\t\t\t\t\t\t\t\t\treturn NodeFilter.FILTER_ACCEPT;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t);\n\t\t\t\t\t\twhile (walker.nextNode()) {\n\t\t\t\t\t\t\tnodes.push(walker.currentNode);\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn nodes;\n\t\t\t\t\t}\n\n\t\t\t\t\tconst textNodes = getTextNodes(document.body);\n\t\t\t\t\tconst matches = [];\n\t\t\t\t\tconst searchQuery = caseSensitive ? query : query.toLowerCase();\n\n\t\t\t\t\ttextNodes.forEach(function(node) {\n\t\t\t\t\t\tconst text = node.textContent || '';\n\t\t\t\t\t\tconst searchText = caseSensitive ? text : text.toLowerCase();\n\t\t\t\t\t\tlet startIndex = 0;\n\t\t\t\t\t\tlet index;\n\n\t\t\t\t\t\twhile ((index = searchText.indexOf(searchQuery, startIndex)) !== -1) {\n\t\t\t\t\t\t\tmatches.push({\n\t\t\t\t\t\t\t\tnode: node,\n\t\t\t\t\t\t\t\tindex: index,\n\t\t\t\t\t\t\t\ttext: text.substring(index, index + query.length)\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\tstartIndex = index + 1;\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\n\t\t\t\t\tconst processedNodes = new Set();\n\n\t\t\t\t\tmatches.forEach(function(match, matchIndex) {\n\t\t\t\t\t\tif (processedNodes.has(match.node)) return;\n\n\t\t\t\t\t\tconst node = match.node;\n\t\t\t\t\t\tconst text = node.textContent || '';\n\t\t\t\t\t\tconst searchText = caseSensitive ? text : text.toLowerCase();\n\n\t\t\t\t\t\tconst fragment = document.createDocumentFragment();\n\t\t\t\t\t\tlet lastIndex = 0;\n\t\t\t\t\t\tlet localIndex;\n\t\t\t\t\t\tlet localStartIndex = 0;\n\n\t\t\t\t\t\twhile ((localIndex = searchText.indexOf(searchQuery, localStartIndex)) !== -1) {\n\t\t\t\t\t\t\tif (localIndex > lastIndex) {\n\t\t\t\t\t\t\t\tfragment.appendChild(document.createTextNode(text.substring(lastIndex, localIndex)));\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tconst span = document.createElement('span');\n\t\t\t\t\t\t\tspan.className = HIGHLIGHT_CLASS;\n\t\t\t\t\t\t\tspan.textContent = text.substring(localIndex, localIndex + query.length);\n\t\t\t\t\t\t\tfragment.appendChild(span);\n\n\t\t\t\t\t\t\tlastIndex = localIndex + query.length;\n\t\t\t\t\t\t\tlocalStartIndex = localIndex + 1;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif (lastIndex < text.length) {\n\t\t\t\t\t\t\tfragment.appendChild(document.createTextNode(text.substring(lastIndex)));\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif (node.parentNode) {\n\t\t\t\t\t\t\tnode.parentNode.replaceChild(fragment, node);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tprocessedNodes.add(node);\n\t\t\t\t\t});\n\n\t\t\t\t\tconst allHighlights = document.querySelectorAll('.' + HIGHLIGHT_CLASS);\n\t\t\t\t\tconst totalMatches = allHighlights.length;\n\n\t\t\t\t\tlet currentMatchIndex = Math.max(0, Math.min(navigateToMatch, totalMatches - 1));\n\t\t\t\t\tif (totalMatches > 0 && allHighlights[currentMatchIndex]) {\n\t\t\t\t\t\tconst prevCurrent = document.querySelector('.' + CURRENT_HIGHLIGHT_CLASS);\n\t\t\t\t\t\tif (prevCurrent) {\n\t\t\t\t\t\t\tprevCurrent.classList.remove(CURRENT_HIGHLIGHT_CLASS);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tallHighlights[currentMatchIndex].classList.add(CURRENT_HIGHLIGHT_CLASS);\n\n\t\t\t\t\t\tallHighlights[currentMatchIndex].scrollIntoView({\n\t\t\t\t\t\t\tbehavior: 'instant',\n\t\t\t\t\t\t\tblock: 'center',\n\t\t\t\t\t\t\tinline: 'center'\n\t\t\t\t\t\t});\n\t\t\t\t\t}\n\n\t\t\t\t\tconst matchPositions = [];\n\t\t\t\t\tlet visibleMatchIndex = 0;\n\t\t\t\t\tallHighlights.forEach(function(el) {\n\t\t\t\t\t\tconst rect = el.getBoundingClientRect();\n\t\t\t\t\t\tif (rect.width === 0 && rect.height === 0) return;\n\t\t\t\t\t\tconst context = el.parentElement ? (el.parentElement.textContent || '').trim().substring(0, 100) : '';\n\t\t\t\t\t\tmatchPositions.push({\n\t\t\t\t\t\t\tindex: visibleMatchIndex++,\n\t\t\t\t\t\t\ttext: el.textContent,\n\t\t\t\t\t\t\tx: Math.round(rect.left + window.scrollX),\n\t\t\t\t\t\t\ty: Math.round(rect.top + window.scrollY),\n\t\t\t\t\t\t\tcontext: context.length > 80 ? context.substring(0, 80) + '...' : context\n\t\t\t\t\t\t});\n\t\t\t\t\t});\n\n\t\t\t\t\tconst visibleMatches = matchPositions.length;\n\t\t\t\t\treturn {\n\t\t\t\t\t\tsuccess: true,\n\t\t\t\t\t\taction: 'search',\n\t\t\t\t\t\tquery: query,\n\t\t\t\t\t\tcaseSensitive: caseSensitive,\n\t\t\t\t\t\ttotalMatches: totalMatches,\n\t\t\t\t\t\tvisibleMatches: visibleMatches,\n\t\t\t\t\t\tcurrentMatch: totalMatches > 0 ? currentMatchIndex : -1,\n\t\t\t\t\t\tmatches: matchPositions.slice(0, 20),\n\t\t\t\t\t\tmessage: totalMatches > 0\n\t\t\t\t\t\t\t? 'Found ' + visibleMatches + ' visible match' + (visibleMatches !== 1 ? 'es' : '') + (visibleMatches !== totalMatches ? ' (' + (totalMatches - visibleMatches) + ' hidden)' : '') + '. Showing match ' + (currentMatchIndex + 1) + ' of ' + totalMatches + '.'\n\t\t\t\t\t\t\t: 'No matches found for "' + query + '"'\n\t\t\t\t\t};\n\t\t\t\t})();\n\t\t\t`,i=await(0,o.executeInBrowser)(s,n,r);if(!i.success)return{content:[{type:"text",text:`Search failed: ${i.error||"Unknown error"}`}]};const a=[];if(a.push("### Action: browser_search"),a.push(`- ${i.message}`),"search"===i.action&&i.totalMatches&&i.totalMatches>0){a.push(`- Query: "${i.query}"`),a.push("- Case sensitive: "+(i.caseSensitive?"yes":"no")),a.push(`- Current match: ${(i.currentMatch??0)+1} of ${i.totalMatches}`),i.matches&&i.matches.length>0&&(a.push(`\n### Match positions (first ${Math.min(i.matches.length,20)}):`),i.matches.forEach(t=>{a.push(`  [${t.index}] "${t.text}" at (${t.x}, ${t.y})`)})),a.push("\nTo navigate to a specific match, use browser_search with navigateToMatch parameter (0-based index)."),a.push("To clear highlights, use browser_search with clearHighlights: true."),await new Promise(t=>setTimeout(t,100));try{const e=await t.takeScreenshot({viewId:n});if(e.content){const t=e.content.find(t=>"image"===t.type);if(t)return{content:[{type:"text",text:a.join("\n")},t,{type:"metadata",viewId:n}]}}}catch(t){o.CursorIDEBrowserLogger.error("Failed to take screenshot for search result:",t)}}return{content:[{type:"text",text:a.join("\n")},{type:"metadata",viewId:n}]}}}};const r=n(8),o=n(376)},254:(t,e,n)=>{function r(){}function o(t,e,n,r,o){for(var s,i=[];e;)i.push(e),s=e.previousComponent,delete e.previousComponent,e=s;i.reverse();for(var a=0,l=i.length,c=0,u=0;a<l;a++){var d=i[a];if(d.removed){if(d.value=t.join(r.slice(u,u+d.count)),u+=d.count,a&&i[a-1].added){var p=i[a-1];i[a-1]=i[a],i[a]=p}}else{if(!d.added&&o){var f=n.slice(c,c+d.count);f=f.map(function(t,e){var n=r[u+e];return n.length>t.length?n:t}),d.value=t.join(f)}else d.value=t.join(n.slice(c,c+d.count));c+=d.count,d.added||(u+=d.count)}}var h=i[l-1];return l>1&&"string"==typeof h.value&&(h.added||h.removed)&&t.equals("",h.value)&&(i[l-2].value+=h.value,i.pop()),i}n.r(e),n.d(e,{Diff:()=>r,applyPatch:()=>D,applyPatches:()=>L,canonicalize:()=>R,convertChangesToDMP:()=>st,convertChangesToXML:()=>it,createPatch:()=>$,createTwoFilesPatch:()=>F,diffArrays:()=>N,diffChars:()=>i,diffCss:()=>y,diffJson:()=>C,diffLines:()=>h,diffSentences:()=>w,diffTrimmedLines:()=>m,diffWords:()=>d,diffWordsWithSpace:()=>p,formatPatch:()=>M,merge:()=>V,parsePatch:()=>O,reversePatch:()=>ot,structuredPatch:()=>B}),r.prototype={diff:function(t,e){var n,r=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},s=r.callback;"function"==typeof r&&(s=r,r={}),this.options=r;var i=this;function a(t){return s?(setTimeout(function(){s(void 0,t)},0),!0):t}t=this.castInput(t),e=this.castInput(e),t=this.removeEmpty(this.tokenize(t));var l=(e=this.removeEmpty(this.tokenize(e))).length,c=t.length,u=1,d=l+c;r.maxEditLength&&(d=Math.min(d,r.maxEditLength));var p=null!==(n=r.timeout)&&void 0!==n?n:1/0,f=Date.now()+p,h=[{oldPos:-1,lastComponent:void 0}],m=this.extractCommon(h[0],e,t,0);if(h[0].oldPos+1>=c&&m+1>=l)return a([{value:this.join(e),count:e.length}]);var g=-1/0,w=1/0;function b(){for(var n=Math.max(g,-u);n<=Math.min(w,u);n+=2){var r=void 0,s=h[n-1],d=h[n+1];s&&(h[n-1]=void 0);var p=!1;if(d){var f=d.oldPos-n;p=d&&0<=f&&f<l}var b=s&&s.oldPos+1<c;if(p||b){if(r=!b||p&&s.oldPos+1<d.oldPos?i.addToPath(d,!0,void 0,0):i.addToPath(s,void 0,!0,1),m=i.extractCommon(r,e,t,n),r.oldPos+1>=c&&m+1>=l)return a(o(i,r.lastComponent,e,t,i.useLongestToken));h[n]=r,r.oldPos+1>=c&&(w=Math.min(w,n-1)),m+1>=l&&(g=Math.max(g,n+1))}else h[n]=void 0}u++}if(s)!function t(){setTimeout(function(){if(u>d||Date.now()>f)return s();b()||t()},0)}();else for(;u<=d&&Date.now()<=f;){var y=b();if(y)return y}},addToPath:function(t,e,n,r){var o=t.lastComponent;return o&&o.added===e&&o.removed===n?{oldPos:t.oldPos+r,lastComponent:{count:o.count+1,added:e,removed:n,previousComponent:o.previousComponent}}:{oldPos:t.oldPos+r,lastComponent:{count:1,added:e,removed:n,previousComponent:o}}},extractCommon:function(t,e,n,r){for(var o=e.length,s=n.length,i=t.oldPos,a=i-r,l=0;a+1<o&&i+1<s&&this.equals(e[a+1],n[i+1]);)a++,i++,l++;return l&&(t.lastComponent={count:l,previousComponent:t.lastComponent}),t.oldPos=i,a},equals:function(t,e){return this.options.comparator?this.options.comparator(t,e):t===e||this.options.ignoreCase&&t.toLowerCase()===e.toLowerCase()},removeEmpty:function(t){for(var e=[],n=0;n<t.length;n++)t[n]&&e.push(t[n]);return e},castInput:function(t){return t},tokenize:function(t){return t.split("")},join:function(t){return t.join("")}};var s=new r;function i(t,e,n){return s.diff(t,e,n)}function a(t,e){if("function"==typeof t)e.callback=t;else if(t)for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n]);return e}var l=/^[A-Za-z\xC0-\u02C6\u02C8-\u02D7\u02DE-\u02FF\u1E00-\u1EFF]+$/,c=/\S/,u=new r;function d(t,e,n){return n=a(n,{ignoreWhitespace:!0}),u.diff(t,e,n)}function p(t,e,n){return u.diff(t,e,n)}u.equals=function(t,e){return this.options.ignoreCase&&(t=t.toLowerCase(),e=e.toLowerCase()),t===e||this.options.ignoreWhitespace&&!c.test(t)&&!c.test(e)},u.tokenize=function(t){for(var e=t.split(/([^\S\r\n]+|[()[\]{}'"\r\n]|\b)/),n=0;n<e.length-1;n++)!e[n+1]&&e[n+2]&&l.test(e[n])&&l.test(e[n+2])&&(e[n]+=e[n+2],e.splice(n+1,2),n--);return e};var f=new r;function h(t,e,n){return f.diff(t,e,n)}function m(t,e,n){var r=a(n,{ignoreWhitespace:!0});return f.diff(t,e,r)}f.tokenize=function(t){this.options.stripTrailingCr&&(t=t.replace(/\r\n/g,"\n"));var e=[],n=t.split(/(\n|\r\n)/);n[n.length-1]||n.pop();for(var r=0;r<n.length;r++){var o=n[r];r%2&&!this.options.newlineIsToken?e[e.length-1]+=o:(this.options.ignoreWhitespace&&(o=o.trim()),e.push(o))}return e};var g=new r;function w(t,e,n){return g.diff(t,e,n)}g.tokenize=function(t){return t.split(/(\S.+?[.!?])(?=\s+|$)/)};var b=new r;function y(t,e,n){return b.diff(t,e,n)}function v(t){return v="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},v(t)}function x(t,e,n){return e in t?Object.defineProperty(t,e,{value:n,enumerable:!0,configurable:!0,writable:!0}):t[e]=n,t}function E(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter(function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable})),n.push.apply(n,r)}return n}function S(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?E(Object(n),!0).forEach(function(e){x(t,e,n[e])}):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):E(Object(n)).forEach(function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))})}return t}function I(t){return function(t){if(Array.isArray(t))return T(t)}(t)||function(t){if("undefined"!=typeof Symbol&&Symbol.iterator in Object(t))return Array.from(t)}(t)||function(t,e){if(t){if("string"==typeof t)return T(t,e);var n=Object.prototype.toString.call(t).slice(8,-1);return"Object"===n&&t.constructor&&(n=t.constructor.name),"Map"===n||"Set"===n?Array.from(t):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?T(t,e):void 0}}(t)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function T(t,e){(null==e||e>t.length)&&(e=t.length);for(var n=0,r=new Array(e);n<e;n++)r[n]=t[n];return r}b.tokenize=function(t){return t.split(/([{}:;,]|\s+)/)};var k=Object.prototype.toString,_=new r;function C(t,e,n){return _.diff(t,e,n)}function R(t,e,n,r,o){var s,i;for(e=e||[],n=n||[],r&&(t=r(o,t)),s=0;s<e.length;s+=1)if(e[s]===t)return n[s];if("[object Array]"===k.call(t)){for(e.push(t),i=new Array(t.length),n.push(i),s=0;s<t.length;s+=1)i[s]=R(t[s],e,n,r,o);return e.pop(),n.pop(),i}if(t&&t.toJSON&&(t=t.toJSON()),"object"===v(t)&&null!==t){e.push(t),i={},n.push(i);var a,l=[];for(a in t)t.hasOwnProperty(a)&&l.push(a);for(l.sort(),s=0;s<l.length;s+=1)i[a=l[s]]=R(t[a],e,n,r,a);e.pop(),n.pop()}else i=t;return i}_.useLongestToken=!0,_.tokenize=f.tokenize,_.castInput=function(t){var e=this.options,n=e.undefinedReplacement,r=e.stringifyReplacer,o=void 0===r?function(t,e){return void 0===e?n:e}:r;return"string"==typeof t?t:JSON.stringify(R(t,null,null,o),o,"  ")},_.equals=function(t,e){return r.prototype.equals.call(_,t.replace(/,([\r\n])/g,"$1"),e.replace(/,([\r\n])/g,"$1"))};var A=new r;function N(t,e,n){return A.diff(t,e,n)}function O(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=t.split(/\r\n|[\n\v\f\r\x85]/),r=t.match(/\r\n|[\n\v\f\r\x85]/g)||[],o=[],s=0;function i(){var t={};for(o.push(t);s<n.length;){var r=n[s];if(/^(\-\-\-|\+\+\+|@@)\s/.test(r))break;var i=/^(?:Index:|diff(?: -r \w+)+)\s+(.+?)\s*$/.exec(r);i&&(t.index=i[1]),s++}for(a(t),a(t),t.hunks=[];s<n.length;){var c=n[s];if(/^(Index:|diff|\-\-\-|\+\+\+)\s/.test(c))break;if(/^@@/.test(c))t.hunks.push(l());else{if(c&&e.strict)throw new Error("Unknown line "+(s+1)+" "+JSON.stringify(c));s++}}}function a(t){var e=/^(---|\+\+\+)\s+(.*)$/.exec(n[s]);if(e){var r="---"===e[1]?"old":"new",o=e[2].split("\t",2),i=o[0].replace(/\\\\/g,"\\");/^".*"$/.test(i)&&(i=i.substr(1,i.length-2)),t[r+"FileName"]=i,t[r+"Header"]=(o[1]||"").trim(),s++}}function l(){var t=s,o=n[s++].split(/@@ -(\d+)(?:,(\d+))? \+(\d+)(?:,(\d+))? @@/),i={oldStart:+o[1],oldLines:void 0===o[2]?1:+o[2],newStart:+o[3],newLines:void 0===o[4]?1:+o[4],lines:[],linedelimiters:[]};0===i.oldLines&&(i.oldStart+=1),0===i.newLines&&(i.newStart+=1);for(var a=0,l=0;s<n.length&&!(0===n[s].indexOf("--- ")&&s+2<n.length&&0===n[s+1].indexOf("+++ ")&&0===n[s+2].indexOf("@@"));s++){var c=0==n[s].length&&s!=n.length-1?" ":n[s][0];if("+"!==c&&"-"!==c&&" "!==c&&"\\"!==c)break;i.lines.push(n[s]),i.linedelimiters.push(r[s]||"\n"),"+"===c?a++:"-"===c?l++:" "===c&&(a++,l++)}if(a||1!==i.newLines||(i.newLines=0),l||1!==i.oldLines||(i.oldLines=0),e.strict){if(a!==i.newLines)throw new Error("Added line count did not match for hunk at line "+(t+1));if(l!==i.oldLines)throw new Error("Removed line count did not match for hunk at line "+(t+1))}return i}for(;s<n.length;)i();return o}function P(t,e,n){var r=!0,o=!1,s=!1,i=1;return function a(){if(r&&!s){if(o?i++:r=!1,t+i<=n)return i;s=!0}if(!o)return s||(r=!0),e<=t-i?-i++:(o=!0,a())}}function D(t,e){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};if("string"==typeof e&&(e=O(e)),Array.isArray(e)){if(e.length>1)throw new Error("applyPatch only works with a single input.");e=e[0]}var r,o,s=t.split(/\r\n|[\n\v\f\r\x85]/),i=t.match(/\r\n|[\n\v\f\r\x85]/g)||[],a=e.hunks,l=n.compareLine||function(t,e,n,r){return e===r},c=0,u=n.fuzzFactor||0,d=0,p=0;function f(t,e){for(var n=0;n<t.lines.length;n++){var r=t.lines[n],o=r.length>0?r[0]:" ",i=r.length>0?r.substr(1):r;if(" "===o||"-"===o){if(!l(e+1,s[e],o,i)&&++c>u)return!1;e++}}return!0}for(var h=0;h<a.length;h++){for(var m=a[h],g=s.length-m.oldLines,w=0,b=p+m.oldStart-1,y=P(b,d,g);void 0!==w;w=y())if(f(m,b+w)){m.offset=p+=w;break}if(void 0===w)return!1;d=m.offset+m.oldStart+m.oldLines}for(var v=0,x=0;x<a.length;x++){var E=a[x],S=E.oldStart+E.offset+v-1;v+=E.newLines-E.oldLines;for(var I=0;I<E.lines.length;I++){var T=E.lines[I],k=T.length>0?T[0]:" ",_=T.length>0?T.substr(1):T,C=E.linedelimiters&&E.linedelimiters[I]||"\n";if(" "===k)S++;else if("-"===k)s.splice(S,1),i.splice(S,1);else if("+"===k)s.splice(S,0,_),i.splice(S,0,C),S++;else if("\\"===k){var R=E.lines[I-1]?E.lines[I-1][0]:null;"+"===R?r=!0:"-"===R&&(o=!0)}}}if(r)for(;!s[s.length-1];)s.pop(),i.pop();else o&&(s.push(""),i.push("\n"));for(var A=0;A<s.length-1;A++)s[A]=s[A]+i[A];return s.join("")}function L(t,e){"string"==typeof t&&(t=O(t));var n=0;!function r(){var o=t[n++];if(!o)return e.complete();e.loadFile(o,function(t,n){if(t)return e.complete(t);var s=D(n,o,e);e.patched(o,s,function(t){if(t)return e.complete(t);r()})})}()}function B(t,e,n,r,o,s,i){i||(i={}),void 0===i.context&&(i.context=4);var a=h(n,r,i);if(a){a.push({value:"",lines:[]});for(var l=[],c=0,u=0,d=[],p=1,f=1,m=function(t){var e=a[t],o=e.lines||e.value.replace(/\n$/,"").split("\n");if(e.lines=o,e.added||e.removed){var s;if(!c){var h=a[t-1];c=p,u=f,h&&(d=i.context>0?w(h.lines.slice(-i.context)):[],c-=d.length,u-=d.length)}(s=d).push.apply(s,I(o.map(function(t){return(e.added?"+":"-")+t}))),e.added?f+=o.length:p+=o.length}else{if(c)if(o.length<=2*i.context&&t<a.length-2){var m;(m=d).push.apply(m,I(w(o)))}else{var g,b=Math.min(o.length,i.context);(g=d).push.apply(g,I(w(o.slice(0,b))));var y={oldStart:c,oldLines:p-c+b,newStart:u,newLines:f-u+b,lines:d};if(t>=a.length-2&&o.length<=i.context){var v=/\n$/.test(n),x=/\n$/.test(r),E=0==o.length&&d.length>y.oldLines;!v&&E&&n.length>0&&d.splice(y.oldLines,0,"\\ No newline at end of file"),(v||E)&&x||d.push("\\ No newline at end of file")}l.push(y),c=0,u=0,d=[]}p+=o.length,f+=o.length}},g=0;g<a.length;g++)m(g);return{oldFileName:t,newFileName:e,oldHeader:o,newHeader:s,hunks:l}}function w(t){return t.map(function(t){return" "+t})}}function M(t){if(Array.isArray(t))return t.map(M).join("\n");var e=[];t.oldFileName==t.newFileName&&e.push("Index: "+t.oldFileName),e.push("==================================================================="),e.push("--- "+t.oldFileName+(void 0===t.oldHeader?"":"\t"+t.oldHeader)),e.push("+++ "+t.newFileName+(void 0===t.newHeader?"":"\t"+t.newHeader));for(var n=0;n<t.hunks.length;n++){var r=t.hunks[n];0===r.oldLines&&(r.oldStart-=1),0===r.newLines&&(r.newStart-=1),e.push("@@ -"+r.oldStart+","+r.oldLines+" +"+r.newStart+","+r.newLines+" @@"),e.push.apply(e,r.lines)}return e.join("\n")+"\n"}function F(t,e,n,r,o,s,i){return M(B(t,e,n,r,o,s,i))}function $(t,e,n,r,o,s){return F(t,t,e,n,r,o,s)}function H(t,e){if(e.length>t.length)return!1;for(var n=0;n<e.length;n++)if(e[n]!==t[n])return!1;return!0}function j(t){var e=rt(t.lines),n=e.oldLines,r=e.newLines;void 0!==n?t.oldLines=n:delete t.oldLines,void 0!==r?t.newLines=r:delete t.newLines}function V(t,e,n){t=U(t,n),e=U(e,n);var r={};(t.index||e.index)&&(r.index=t.index||e.index),(t.newFileName||e.newFileName)&&(Y(t)?Y(e)?(r.oldFileName=X(r,t.oldFileName,e.oldFileName),r.newFileName=X(r,t.newFileName,e.newFileName),r.oldHeader=X(r,t.oldHeader,e.oldHeader),r.newHeader=X(r,t.newHeader,e.newHeader)):(r.oldFileName=t.oldFileName,r.newFileName=t.newFileName,r.oldHeader=t.oldHeader,r.newHeader=t.newHeader):(r.oldFileName=e.oldFileName||t.oldFileName,r.newFileName=e.newFileName||t.newFileName,r.oldHeader=e.oldHeader||t.oldHeader,r.newHeader=e.newHeader||t.newHeader)),r.hunks=[];for(var o=0,s=0,i=0,a=0;o<t.hunks.length||s<e.hunks.length;){var l=t.hunks[o]||{oldStart:1/0},c=e.hunks[s]||{oldStart:1/0};if(J(l,c))r.hunks.push(K(l,i)),o++,a+=l.newLines-l.oldLines;else if(J(c,l))r.hunks.push(K(c,a)),s++,i+=c.newLines-c.oldLines;else{var u={oldStart:Math.min(l.oldStart,c.oldStart),oldLines:0,newStart:Math.min(l.newStart+i,c.oldStart+a),newLines:0,lines:[]};W(u,l.oldStart,l.lines,c.oldStart,c.lines),s++,o++,r.hunks.push(u)}}return r}function U(t,e){if("string"==typeof t){if(/^@@/m.test(t)||/^Index:/m.test(t))return O(t)[0];if(!e)throw new Error("Must provide a base reference or pass in a patch");return B(void 0,void 0,e,t)}return t}function Y(t){return t.newFileName&&t.newFileName!==t.oldFileName}function X(t,e,n){return e===n?e:(t.conflict=!0,{mine:e,theirs:n})}function J(t,e){return t.oldStart<e.oldStart&&t.oldStart+t.oldLines<e.oldStart}function K(t,e){return{oldStart:t.oldStart,oldLines:t.oldLines,newStart:t.newStart+e,newLines:t.newLines,lines:t.lines}}function W(t,e,n,r,o){var s={offset:e,lines:n,index:0},i={offset:r,lines:o,index:0};for(Z(t,s,i),Z(t,i,s);s.index<s.lines.length&&i.index<i.lines.length;){var a=s.lines[s.index],l=i.lines[i.index];if("-"!==a[0]&&"+"!==a[0]||"-"!==l[0]&&"+"!==l[0])if("+"===a[0]&&" "===l[0]){var c;(c=t.lines).push.apply(c,I(tt(s)))}else if("+"===l[0]&&" "===a[0]){var u;(u=t.lines).push.apply(u,I(tt(i)))}else"-"===a[0]&&" "===l[0]?G(t,s,i):"-"===l[0]&&" "===a[0]?G(t,i,s,!0):a===l?(t.lines.push(a),s.index++,i.index++):z(t,tt(s),tt(i));else q(t,s,i)}Q(t,s),Q(t,i),j(t)}function q(t,e,n){var r,o,s=tt(e),i=tt(n);if(et(s)&&et(i)){var a,l;if(H(s,i)&&nt(n,s,s.length-i.length))return void(a=t.lines).push.apply(a,I(s));if(H(i,s)&&nt(e,i,i.length-s.length))return void(l=t.lines).push.apply(l,I(i))}else if(o=i,(r=s).length===o.length&&H(r,o)){var c;return void(c=t.lines).push.apply(c,I(s))}z(t,s,i)}function G(t,e,n,r){var o,s=tt(e),i=function(t,e){for(var n=[],r=[],o=0,s=!1,i=!1;o<e.length&&t.index<t.lines.length;){var a=t.lines[t.index],l=e[o];if("+"===l[0])break;if(s=s||" "!==a[0],r.push(l),o++,"+"===a[0])for(i=!0;"+"===a[0];)n.push(a),a=t.lines[++t.index];l.substr(1)===a.substr(1)?(n.push(a),t.index++):i=!0}if("+"===(e[o]||"")[0]&&s&&(i=!0),i)return n;for(;o<e.length;)r.push(e[o++]);return{merged:r,changes:n}}(n,s);i.merged?(o=t.lines).push.apply(o,I(i.merged)):z(t,r?i:s,r?s:i)}function z(t,e,n){t.conflict=!0,t.lines.push({conflict:!0,mine:e,theirs:n})}function Z(t,e,n){for(;e.offset<n.offset&&e.index<e.lines.length;){var r=e.lines[e.index++];t.lines.push(r),e.offset++}}function Q(t,e){for(;e.index<e.lines.length;){var n=e.lines[e.index++];t.lines.push(n)}}function tt(t){for(var e=[],n=t.lines[t.index][0];t.index<t.lines.length;){var r=t.lines[t.index];if("-"===n&&"+"===r[0]&&(n="+"),n!==r[0])break;e.push(r),t.index++}return e}function et(t){return t.reduce(function(t,e){return t&&"-"===e[0]},!0)}function nt(t,e,n){for(var r=0;r<n;r++){var o=e[e.length-n+r].substr(1);if(t.lines[t.index+r]!==" "+o)return!1}return t.index+=n,!0}function rt(t){var e=0,n=0;return t.forEach(function(t){if("string"!=typeof t){var r=rt(t.mine),o=rt(t.theirs);void 0!==e&&(r.oldLines===o.oldLines?e+=r.oldLines:e=void 0),void 0!==n&&(r.newLines===o.newLines?n+=r.newLines:n=void 0)}else void 0===n||"+"!==t[0]&&" "!==t[0]||n++,void 0===e||"-"!==t[0]&&" "!==t[0]||e++}),{oldLines:e,newLines:n}}function ot(t){return Array.isArray(t)?t.map(ot).reverse():S(S({},t),{},{oldFileName:t.newFileName,oldHeader:t.newHeader,newFileName:t.oldFileName,newHeader:t.oldHeader,hunks:t.hunks.map(function(t){return{oldLines:t.newLines,oldStart:t.newStart,newLines:t.oldLines,newStart:t.oldStart,linedelimiters:t.linedelimiters,lines:t.lines.map(function(t){return t.startsWith("-")?"+".concat(t.slice(1)):t.startsWith("+")?"-".concat(t.slice(1)):t})}})})}function st(t){for(var e,n,r=[],o=0;o<t.length;o++)n=(e=t[o]).added?1:e.removed?-1:0,r.push([n,e.value]);return r}function it(t){for(var e=[],n=0;n<t.length;n++){var r=t[n];r.added?e.push("<ins>"):r.removed&&e.push("<del>"),e.push(at(r.value)),r.added?e.push("</ins>"):r.removed&&e.push("</del>")}return e.join("")}function at(t){var e=t;return(e=(e=(e=e.replace(/&/g,"&amp;")).replace(/</g,"&lt;")).replace(/>/g,"&gt;")).replace(/"/g,"&quot;")}A.tokenize=function(t){return t.slice()},A.join=A.removeEmpty=function(t){return t}},256:function(t,e,n){var r,o=this&&this.__createBinding||(Object.create?function(t,e,n,r){void 0===r&&(r=n);var o=Object.getOwnPropertyDescriptor(e,n);o&&!("get"in o?!e.__esModule:o.writable||o.configurable)||(o={enumerable:!0,get:function(){return e[n]}}),Object.defineProperty(t,r,o)}:function(t,e,n,r){void 0===r&&(r=n),t[r]=e[n]}),s=this&&this.__setModuleDefault||(Object.create?function(t,e){Object.defineProperty(t,"default",{enumerable:!0,value:e})}:function(t,e){t.default=e}),i=this&&this.__importStar||(r=function(t){return r=Object.getOwnPropertyNames||function(t){var e=[];for(var n in t)Object.prototype.hasOwnProperty.call(t,n)&&(e[e.length]=n);return e},r(t)},function(t){if(t&&t.__esModule)return t;var e={};if(null!=t)for(var n=r(t),i=0;i<n.length;i++)"default"!==n[i]&&o(e,t,n[i]);return s(e,t),e});Object.defineProperty(e,"__esModule",{value:!0}),e.activate=async function(t){l.CursorIDEBrowserLogger.init(),l.CursorIDEBrowserLogger.info("Cursor Browser Automation extension activated"),f=new p,await f.initialize();const e=a.cursor.registerMcpProvider(f);t.subscriptions.push(e);const n=a.commands.registerCommand("cursor.browserAutomation.reinjectUIScript",h);t.subscriptions.push(n),h().catch(()=>{})},e.deactivate=async function(){f&&(await f.dispose(),f=void 0)};const a=i(n(398)),l=n(377),c=n(453),u=n(756),d="internal_browser_evaluate";class p{constructor(){this.id="cursor-ide-browser",this.featureGateName=void 0,this.instructions='The cursor-ide-browser is an MCP server that allows you to navigate the web and interact with the page. Use this for frontend/webapp development and testing code changes.\n\nCRITICAL - Lock/unlock workflow:\n1. browser_lock requires an existing browser tab - you CANNOT lock before browser_navigate\n2. Correct order: browser_navigate -> browser_lock -> (interactions) -> browser_unlock\n3. If a browser tab already exists (check with browser_tabs list), call browser_lock FIRST before any interactions\n4. Only call browser_unlock when completely done with ALL browser operations for this turn\n\nIMPORTANT - Before interacting with any page:\n1. Use browser_tabs with action "list" to see open tabs and their URLs\n2. Use browser_snapshot to get the page structure and element refs before any interaction (click, type, hover, etc.)\n\nIMPORTANT - Waiting strategy:\nWhen waiting for page changes (navigation, content loading, animations, etc.), prefer short incremental waits (1-3 seconds) with browser_snapshot checks in between rather than a single long wait. For example, instead of waiting 10 seconds, do: wait 2s -> snapshot -> check if ready -> if not, wait 2s more -> snapshot again. This allows you to proceed as soon as the page is ready rather than always waiting the maximum time.\n\nNotes:\n- Native dialogs (alert/confirm/prompt) never block automation. By default, confirm() returns true and prompt() returns the default value. To test different responses, call browser_handle_dialog BEFORE the triggering action: use accept: false for "Cancel", or promptText: "value" for custom prompt input.\n- Iframe content is not accessible - only elements outside iframes can be interacted with.\n- Use browser_type to append text, browser_fill to clear and replace. browser_fill also works on contenteditable elements.\n- For nested scroll containers, use browser_scroll with scrollIntoView: true before clicking elements that may be obscured.',this.tools=[{name:"browser_navigate",description:"Navigate to a URL. By default reuses an existing tab; set newTab: true to open in a new tab.",parameters:JSON.stringify({type:"object",properties:{url:{type:"string",description:"The URL to navigate to"},viewId:{type:"string",description:"Target browser tab ID. If omitted, uses the last interacted tab."},position:{type:"string",enum:["active","side"],description:'IMPORTANT: Set to "side" if user mentions "side", "beside", "side panel", or "side by side". Opens browser in side editor group. Defaults to "active" (current editor group).'},take_screenshot_afterwards:{type:"boolean",description:"When true, takes a screenshot after navigation completes. Defaults to false."},newTab:{type:"boolean",description:"When true, creates a new tab before navigating instead of reusing an existing tab. Defaults to false."}},required:["url"]})},{name:"browser_snapshot",description:"Capture accessibility snapshot of the current page, this is better than screenshot",parameters:JSON.stringify({type:"object",properties:{viewId:{type:"string",description:"Target browser tab ID. If omitted, uses the last interacted tab."},interactive:{type:"boolean",description:"When true, only include interactive elements in the snapshot. Defaults to false."},maxDepth:{type:"number",description:"Maximum depth for snapshot output. Defaults to 20."},compact:{type:"boolean",description:"When true, outputs a more compact snapshot format. Defaults to false."},selector:{type:"string",description:"Optional CSS selector to scope the snapshot to a subtree."},includeDiff:{type:"boolean",description:"When true, include a diff vs the previous snapshot for this tab. Defaults to false."},take_screenshot_afterwards:{type:"boolean",description:"When true, takes a screenshot after snapshot completes. Defaults to false."}},required:[]})},{name:"browser_click",description:"Perform click on a web page. Supports single/double click, different mouse buttons, modifier keys, position offsets, and hold duration.",parameters:JSON.stringify({type:"object",properties:{element:{type:"string",description:"Human-readable element description used to obtain permission to interact with the element"},ref:{type:"string",description:"Exact target element reference from the page snapshot"},doubleClick:{type:"boolean",description:"Whether to perform a double click instead of a single click"},button:{type:"string",enum:["left","right","middle"],description:'Mouse button to click. Defaults to "left".'},modifiers:{type:"array",items:{type:"string",enum:["Control","Shift","Alt","Meta","ControlOrMeta"]},description:'Modifier keys to hold during click. "ControlOrMeta" uses Ctrl on Windows/Linux and Cmd on Mac.'},offsetX:{type:"number",description:"Horizontal offset from element's left edge in pixels. If omitted, clicks at horizontal center."},offsetY:{type:"number",description:"Vertical offset from element's top edge in pixels. If omitted, clicks at vertical center."},holdDurationMs:{type:"number",description:"Duration to hold the mouse button down before releasing, in milliseconds. Useful for long-press interactions. Defaults to 0 (immediate release)."},viewId:{type:"string",description:"Target browser tab ID. If omitted, uses the last interacted tab."}},required:["element","ref"]})},{name:"browser_type",description:"Type text into editable element",parameters:JSON.stringify({type:"object",properties:{element:{type:"string",description:"Human-readable element description used to obtain permission to interact with the element"},ref:{type:"string",description:"Exact target element reference from the page snapshot"},text:{type:"string",description:"Text to type into the element"},clear:{type:"boolean",description:"Whether to clear existing content before typing. Use this to replace the current value instead of appending to it. Defaults to false."},submit:{type:"boolean",description:"Whether to submit entered text (press Enter after)"},slowly:{type:"boolean",description:"Whether to type one character at a time. Useful for triggering key handlers in the page. By default entire text is filled in at once."},viewId:{type:"string",description:"Target browser tab ID. If omitted, uses the last interacted tab."}},required:["element","ref","text"]})},{name:"browser_fill",description:"Clear and fill a value into an input element. Unlike browser_type which appends text, this clears the existing value first and sets the new value atomically. Use this when you want to replace the entire content of an input field.",parameters:JSON.stringify({type:"object",properties:{element:{type:"string",description:"Human-readable element description used to obtain permission to interact with the element"},ref:{type:"string",description:"Exact target element reference from the page snapshot"},value:{type:"string",description:"Value to fill into the element (replaces any existing content)"},viewId:{type:"string",description:"Target browser tab ID. If omitted, uses the last interacted tab."}},required:["element","ref","value"]})},{name:"browser_fill_form",description:"Fill multiple form fields at once. Each field uses ref + value. By default, each field is cleared before setting the new value.",parameters:JSON.stringify({type:"object",properties:{fields:{type:"array",items:{type:"object",properties:{element:{type:"string",description:"Human-readable element description used to obtain permission to interact with the element"},ref:{type:"string",description:"Exact target element reference from the page snapshot"},value:{type:"string",description:"Value to fill into the field"},clear:{type:"boolean",description:"Whether to clear existing content before filling. Defaults to true."}},required:["element","ref","value"]}},viewId:{type:"string",description:"Target browser tab ID. If omitted, uses the last interacted tab."},take_screenshot_afterwards:{type:"boolean",description:"When true, takes a screenshot after the fill completes. Defaults to false."}},required:["fields"]})},{name:"browser_hover",description:"Hover over element on page",parameters:JSON.stringify({type:"object",properties:{element:{type:"string",description:"Human-readable element description used to obtain permission to interact with the element"},ref:{type:"string",description:"Exact target element reference from the page snapshot"},viewId:{type:"string",description:"Target browser tab ID. If omitted, uses the last interacted tab."}},required:["element","ref"]})},{name:"browser_select_option",description:"Select an option in a dropdown. Matching priority: exact value match, then exact label match, then partial label match. The snapshot now shows available options for select elements.",parameters:JSON.stringify({type:"object",properties:{element:{type:"string",description:"Human-readable element description used to obtain permission to interact with the element"},ref:{type:"string",description:"Exact target element reference from the page snapshot"},values:{type:"array",items:{type:"string"},description:"Array of values to select. Matches against option value first, then label text, then partial label. Use exact values from the snapshot options list when available."},viewId:{type:"string",description:"Target browser tab ID. If omitted, uses the last interacted tab."}},required:["element","ref","values"]})},{name:"browser_press_key",description:'Press a key on the keyboard. Supports key combinations with modifiers using "+" syntax.',parameters:JSON.stringify({type:"object",properties:{key:{type:"string",description:'Key to press. Single keys: "a", "Enter", "Escape", "Tab", "Backspace", "Delete", "ArrowUp", "ArrowDown", "ArrowLeft", "ArrowRight", "PageUp", "PageDown", "Home", "End", "F1"-"F12", "Space". Key combinations with modifiers using "+": "Control+s", "Ctrl+Shift+p", "Alt+Tab", "Meta+a" (Cmd on Mac). Modifier aliases: Control/Ctrl, Shift, Alt/Option, Meta/Command/Cmd/Win.'},viewId:{type:"string",description:"Target browser tab ID. If omitted, uses the last interacted tab."}},required:["key"]})},{name:"browser_wait_for",description:"Wait for text to appear or disappear, or wait a specified time. Note: time is in SECONDS, not milliseconds.",parameters:JSON.stringify({type:"object",properties:{time:{type:"number",description:"Time to wait in SECONDS (e.g., 2 for 2 seconds, 0.5 for 500ms). Use for fixed delays."},text:{type:"string",description:"Wait for this text to appear on the page."},textGone:{type:"string",description:"Wait for this text to disappear from the page."},timeout:{type:"number",description:"Maximum time to wait for text conditions in MILLISECONDS. Defaults to 30000 (30 seconds)."},viewId:{type:"string",description:"Target browser tab ID. If omitted, uses the last interacted tab."}},required:[]})},{name:"browser_navigate_back",description:"Go back to the previous page in browser history. Returns an error if there is no previous page to navigate to.",parameters:JSON.stringify({type:"object",properties:{viewId:{type:"string",description:"Target browser tab ID. If omitted, uses the last interacted tab."}},required:[]})},{name:"browser_navigate_forward",description:"Go forward to the next page in browser history. Returns an error if there is no forward page to navigate to.",parameters:JSON.stringify({type:"object",properties:{viewId:{type:"string",description:"Target browser tab ID. If omitted, uses the last interacted tab."}},required:[]})},{name:"browser_reload",description:"Reload the current page. Useful after making code changes to see updates.",parameters:JSON.stringify({type:"object",properties:{viewId:{type:"string",description:"Target browser tab ID. If omitted, uses the last interacted tab."},take_screenshot_afterwards:{type:"boolean",description:"When true, takes a screenshot after reload completes. Defaults to false."}},required:[]})},{name:"browser_scroll",description:"Scroll the page or a specific element. Use this to bring elements into view, scroll to content, or navigate long pages. Can scroll in any direction by specifying delta values or using directional shortcuts.",parameters:JSON.stringify({type:"object",properties:{ref:{type:"string",description:"Element reference to scroll into view, or to scroll within (for scrollable containers)"},direction:{type:"string",enum:["up","down","left","right"],description:"Direction to scroll. Shorthand for setting deltaX/deltaY."},amount:{type:"number",description:"Amount to scroll in pixels when using direction. Defaults to 300."},deltaX:{type:"number",description:"Horizontal scroll amount in pixels. Positive scrolls right, negative scrolls left."},deltaY:{type:"number",description:"Vertical scroll amount in pixels. Positive scrolls down, negative scrolls up."},scrollIntoView:{type:"boolean",description:"If true and ref is provided, scrolls the element into view instead of scrolling within it. Defaults to true when ref is provided without delta values."},viewId:{type:"string",description:"Target browser tab ID. If omitted, uses the last interacted tab."}},required:[]})},{name:"browser_get_attribute",description:"Read a specific attribute from an element.",parameters:JSON.stringify({type:"object",properties:{element:{type:"string",description:"Human-readable element description used to obtain permission to inspect the element"},ref:{type:"string",description:"Exact target element reference from the page snapshot"},name:{type:"string",description:"Attribute name to read"},viewId:{type:"string",description:"Target browser tab ID. If omitted, uses the last interacted tab."}},required:["element","ref","name"]})},{name:"browser_get_input_value",description:"Read the current value of an input, textarea, or contenteditable element. Password inputs return a masked value.",parameters:JSON.stringify({type:"object",properties:{element:{type:"string",description:"Human-readable element description used to obtain permission to inspect the element"},ref:{type:"string",description:"Exact target element reference from the page snapshot"},viewId:{type:"string",description:"Target browser tab ID. If omitted, uses the last interacted tab."}},required:["element","ref"]})},{name:"browser_is_visible",description:"Check if an element is currently visible.",parameters:JSON.stringify({type:"object",properties:{element:{type:"string",description:"Human-readable element description used to obtain permission to inspect the element"},ref:{type:"string",description:"Exact target element reference from the page snapshot"},viewId:{type:"string",description:"Target browser tab ID. If omitted, uses the last interacted tab."}},required:["element","ref"]})},{name:"browser_is_enabled",description:"Check if an element is enabled (not disabled by its own state or a parent fieldset).",parameters:JSON.stringify({type:"object",properties:{element:{type:"string",description:"Human-readable element description used to obtain permission to inspect the element"},ref:{type:"string",description:"Exact target element reference from the page snapshot"},viewId:{type:"string",description:"Target browser tab ID. If omitted, uses the last interacted tab."}},required:["element","ref"]})},{name:"browser_is_checked",description:"Check if a checkbox or radio element is checked.",parameters:JSON.stringify({type:"object",properties:{element:{type:"string",description:"Human-readable element description used to obtain permission to inspect the element"},ref:{type:"string",description:"Exact target element reference from the page snapshot"},viewId:{type:"string",description:"Target browser tab ID. If omitted, uses the last interacted tab."}},required:["element","ref"]})},{name:"browser_get_bounding_box",description:"Get bounding box details for an element.",parameters:JSON.stringify({type:"object",properties:{element:{type:"string",description:"Human-readable element description used to obtain permission to inspect the element"},ref:{type:"string",description:"Exact target element reference from the page snapshot"},viewId:{type:"string",description:"Target browser tab ID. If omitted, uses the last interacted tab."}},required:["element","ref"]})},{name:"browser_highlight",description:"Temporarily highlight an element for visual debugging.",parameters:JSON.stringify({type:"object",properties:{element:{type:"string",description:"Human-readable element description used to obtain permission to inspect the element"},ref:{type:"string",description:"Exact target element reference from the page snapshot"},durationMs:{type:"number",description:"Highlight duration in milliseconds. Defaults to 2000."},viewId:{type:"string",description:"Target browser tab ID. If omitted, uses the last interacted tab."}},required:["element","ref"]})},{name:"browser_drag",description:"Perform a drag and drop operation. Drags from a source element to a target element or coordinates.",parameters:JSON.stringify({type:"object",properties:{sourceRef:{type:"string",description:"Reference of the element to drag from"},targetRef:{type:"string",description:"Reference of the element to drop onto"},targetX:{type:"number",description:"X coordinate to drop at (relative to viewport). Use with targetY instead of targetRef for coordinate-based drops."},targetY:{type:"number",description:"Y coordinate to drop at (relative to viewport). Use with targetX instead of targetRef for coordinate-based drops."},viewId:{type:"string",description:"Target browser tab ID. If omitted, uses the last interacted tab."}},required:["sourceRef"]})},{name:"browser_handle_dialog",description:"Configure how native browser dialogs (alert, confirm, prompt) are handled. Dialogs are non-blocking in this environment - they return immediately without showing a visible dialog. Use this tool BEFORE triggering an action that shows a dialog to configure what value it should return. Also returns recent dialog history.",parameters:JSON.stringify({type:"object",properties:{accept:{type:"boolean",description:"For confirm() dialogs: true to simulate clicking OK (returns true), false to simulate clicking Cancel (returns false). Default behavior is true."},promptText:{type:"string",description:"For prompt() dialogs: the text value to return. If not specified, prompt() returns the default value provided by the page."},viewId:{type:"string",description:"Target browser tab ID. If omitted, uses the last interacted tab."}},required:["accept"]})},{name:"browser_resize",description:"Resize the browser window",parameters:JSON.stringify({type:"object",properties:{width:{type:"number",description:"Width of the browser window"},height:{type:"number",description:"Height of the browser window"},viewId:{type:"string",description:"Target browser tab ID. If omitted, uses the last interacted tab."}},required:["width","height"]})},{name:"browser_console_messages",description:"Returns all console messages",parameters:JSON.stringify({type:"object",properties:{viewId:{type:"string",description:"Target browser tab ID. If omitted, uses the last interacted tab."}},required:[]})},{name:"browser_network_requests",description:"Returns all network requests since loading the page",parameters:JSON.stringify({type:"object",properties:{viewId:{type:"string",description:"Target browser tab ID. If omitted, uses the last interacted tab."}},required:[]})},{name:"browser_tabs",description:"List, create, close, or select a browser tab",parameters:JSON.stringify({type:"object",properties:{action:{type:"string",enum:["list","new","close","select"],description:"Operation to perform"},index:{type:"number",description:'Tab index. Required for "select". Optional for "close" (defaults to current tab).'},position:{type:"string",enum:["active","side"],description:'IMPORTANT: Set to "side" if user mentions "side", "beside", "side panel", or "side by side". Opens browser in side editor group. Only for action "new". Defaults to "active".'}},required:["action"]})},{name:"browser_take_screenshot",description:"Take a screenshot of the current page. You can't perform actions based on the screenshot, use browser_snapshot for actions.",parameters:JSON.stringify({type:"object",properties:{type:{type:"string",description:"Image format for the screenshot. Default is png."},filename:{type:"string",description:"File name to save the screenshot to. Defaults to page-{timestamp}.{png|jpeg} if not specified."},element:{type:"string",description:"Description of the element, if taking a screenshot of an element"},ref:{type:"string",description:"CSS selector for the element, if taking a screenshot of an element"},fullPage:{type:"boolean",description:"When true, takes a screenshot of the full scrollable page, instead of the currently visible viewport. Cannot be used with element screenshots."},viewId:{type:"string",description:"Target browser tab ID. If omitted, uses the last interacted tab."}},required:[]})},{name:"browser_search",description:"Search for text on the current page, similar to Cmd+F / Ctrl+F. Highlights all matches, scrolls to the first match, and returns a screenshot showing the match in context along with the count and positions of matches found.",parameters:JSON.stringify({type:"object",properties:{query:{type:"string",description:"The text to search for on the page"},caseSensitive:{type:"boolean",description:"Whether the search should be case-sensitive. Defaults to false."},navigateToMatch:{type:"number",description:"Navigate to a specific match by index (0-based). If not provided, navigates to the first match."},clearHighlights:{type:"boolean",description:"If true, clears all search highlights without performing a new search. Use this to remove previous search highlights."},viewId:{type:"string",description:"Target browser tab ID. If omitted, uses the last interacted tab."}},required:[]})},{name:"browser_lock",description:'Lock the browser to prevent user interaction while you work. Shows a subtle overlay that blocks clicks/scrolls. The user can still click "Take Control" to unlock if needed.',parameters:JSON.stringify({type:"object",properties:{viewId:{type:"string",description:"Target browser tab ID. If omitted, uses the last interacted tab."}},required:[]})},{name:"browser_unlock",description:"Unlock the browser to allow user interaction. Call this when you are done with a sequence of browser operations.",parameters:JSON.stringify({type:"object",properties:{viewId:{type:"string",description:"Target browser tab ID. If omitted, uses the last interacted tab."}},required:[]})}]}async initialize(){l.CursorIDEBrowserLogger.info("Browser Automation MCP Provider initialized with direct execution")}async listOfferings(){const t=[...this.tools];try{await a.cursor.checkFeatureGate(d)&&t.push({name:"browser_evaluate",description:"Execute JavaScript in the page for debugging and inspection. RESTRICTIONS: Cannot access document.cookie, localStorage, sessionStorage, or credentials. Use for DOM inspection and debugging only.",parameters:JSON.stringify({type:"object",properties:{script:{type:"string",description:"JavaScript to evaluate in the page context. Use return to return a value. Cannot access cookies, localStorage, or sessionStorage."},viewId:{type:"string",description:"Target browser tab ID. If omitted, uses the last interacted tab."}},required:["script"]})})}catch(t){l.CursorIDEBrowserLogger.warn(`Failed to check feature gate for browser_evaluate, tool will not be available: ${t}`)}return{tools:t,prompts:[],resources:[]}}async callTool(t,e){l.CursorIDEBrowserLogger.info(`Executing tool: ${t} with args: ${JSON.stringify(e)}`);try{switch(t){case"browser_navigate":return await c.BrowserTools.navigate(e);case"browser_snapshot":return await c.BrowserTools.snapshot(e);case"browser_click":return await c.BrowserTools.click(e);case"browser_type":return await c.BrowserTools.type(e);case"browser_fill":return await c.BrowserTools.fill(e);case"browser_fill_form":return await c.BrowserTools.fillForm(e);case"browser_hover":return await c.BrowserTools.hover(e);case"browser_select_option":return await c.BrowserTools.selectOption(e);case"browser_press_key":return await c.BrowserTools.pressKey(e);case"browser_evaluate":return await a.cursor.checkFeatureGate(d)?await c.BrowserTools.evaluate(e):{content:[{type:"text",text:"browser_evaluate is not available. This tool is currently disabled."}]};case"browser_wait_for":return await c.BrowserTools.waitFor(e);case"browser_navigate_back":return await c.BrowserTools.goBack(e);case"browser_navigate_forward":return await c.BrowserTools.goForward(e);case"browser_reload":return await c.BrowserTools.reload(e);case"browser_scroll":return await c.BrowserTools.scroll(e);case"browser_drag":return await c.BrowserTools.drag(e);case"browser_handle_dialog":return await c.BrowserTools.handleDialog(e);case"browser_resize":return await c.BrowserTools.resize(e);case"browser_console_messages":return await c.BrowserTools.consoleMessages(e);case"browser_network_requests":return await c.BrowserTools.networkRequests(e);case"browser_take_screenshot":return await c.BrowserTools.takeScreenshot(e);case"browser_tabs":return await c.BrowserTools.tabs(e);case"browser_search":return await c.BrowserTools.search(e);case"browser_get_attribute":return await c.BrowserTools.getAttribute(e);case"browser_get_input_value":return await c.BrowserTools.getInputValue(e);case"browser_is_visible":return await c.BrowserTools.isVisible(e);case"browser_is_enabled":return await c.BrowserTools.isEnabled(e);case"browser_is_checked":return await c.BrowserTools.isChecked(e);case"browser_get_bounding_box":return await c.BrowserTools.getBoundingBox(e);case"browser_highlight":return await c.BrowserTools.highlight(e);case"browser_lock":return await c.BrowserTools.lock(e);case"browser_unlock":return await c.BrowserTools.unlock(e);default:throw new Error(`Unknown tool: ${t}`)}}catch(e){throw l.CursorIDEBrowserLogger.error(`Error executing tool ${t}:`,e),e}}async dispose(){l.CursorIDEBrowserLogger.info("Browser Automation MCP Provider disposed")}}let f;async function h(){l.CursorIDEBrowserLogger.info("injectBrowserUIScript called");try{const t=(0,u.generateBrowserUIScript)("browser-tab-id");await a.commands.executeCommand("cursor.browserView.executeJavaScript",t),l.CursorIDEBrowserLogger.info("Browser UI script injected successfully")}catch(t){l.CursorIDEBrowserLogger.error("Failed to inject browser UI script:",t)}}},376:function(t,e,n){var r,o=this&&this.__createBinding||(Object.create?function(t,e,n,r){void 0===r&&(r=n);var o=Object.getOwnPropertyDescriptor(e,n);o&&!("get"in o?!e.__esModule:o.writable||o.configurable)||(o={enumerable:!0,get:function(){return e[n]}}),Object.defineProperty(t,r,o)}:function(t,e,n,r){void 0===r&&(r=n),t[r]=e[n]}),s=this&&this.__setModuleDefault||(Object.create?function(t,e){Object.defineProperty(t,"default",{enumerable:!0,value:e})}:function(t,e){t.default=e}),i=this&&this.__importStar||(r=function(t){return r=Object.getOwnPropertyNames||function(t){var e=[];for(var n in t)Object.prototype.hasOwnProperty.call(t,n)&&(e[e.length]=n);return e},r(t)},function(t){if(t&&t.__esModule)return t;var e={};if(null!=t)for(var n=r(t),i=0;i<n.length;i++)"default"!==n[i]&&o(e,t,n[i]);return s(e,t),e});Object.defineProperty(e,"__esModule",{value:!0}),e.CursorIDEBrowserLogger=e.ELEMENT_FINDER=e.viewSnapshotTimestamps=e.SNAPSHOT_STALENESS_THRESHOLD_MS=e.BROWSER_GET_URL_COMMAND=e.ORIGIN_PAGE_COMMAND=e.ORIGIN_NAVIGATION_COMMAND=e.TEMP_LOG_DIR=e.SNAPSHOT_DIFF_SIZE_THRESHOLD=e.SNAPSHOT_PREVIEW_LINES=e.SNAPSHOT_SIZE_THRESHOLD=void 0,e.parseRef=function(t){if(!t)return t;const e=t.trim();return e.startsWith("@")?e.substring(1):e.startsWith("ref=")?e.substring(4):e},e.toAIFriendlyError=function(t,e){const n="string"==typeof t?t:t.message,r=n.toLowerCase();if(r.includes("strict mode violation")||r.includes("resolved to")&&r.includes("elements")){const t=n.match(/resolved to (\d+) elements/i);return{message:`Selector matched ${t?t[1]:"multiple"} elements${e?.selector?` (${e.selector})`:""}`,suggestion:"Take a snapshot to get specific refs for each element, then use the ref directly instead of the selector.",recovery:"browser_snapshot to get specific refs with nth disambiguation"}}if(r.includes("intercepted")||r.includes("would hit")||r.includes("instead of target")){const t=n.match(/ref:\s*(\w+)/),e=t?t[1]:null,o=r.includes("overflow")||r.includes("scroll")||r.includes("container");let s=e?`Click the intercepting element (ref: ${e}) directly if that is the intended target, or take a snapshot to see the updated element positions.`:"Take a snapshot to see which element is at the click position and use that ref instead.";return o&&(s+=" The element may be inside a scrollable container - try using browser_scroll to scroll the target into view first."),{message:"Click was intercepted by another element"+(e?` (ref: ${e})`:""),suggestion:s,recovery:o?"browser_scroll with target ref, or browser_snapshot":e?`browser_click with ref ${e}`:"browser_snapshot"}}if(r.includes("option")&&r.includes("disabled")&&r.includes("cannot be selected")){const t=n.match(/"([^"]+)".*disabled/i);return{message:`Option "${t?t[1]:"the requested option"}" is disabled and cannot be selected`,suggestion:"The specific option you tried to select is disabled. Check the snapshot for available (non-disabled) options, or wait for the option to become enabled.",recovery:"browser_snapshot to see available options, or select a different option"}}for(const t of h)if(t.allRequired?t.patterns.every(t=>r.includes(t)):t.patterns.some(t=>r.includes(t)))return{message:t.getMessage(e,n),suggestion:t.suggestion,recovery:t.recovery};return{message:n,suggestion:"An unexpected error occurred. Try taking a snapshot to understand the current page state.",recovery:"browser_snapshot"}},e.formatAIFriendlyError=function(t){const e=[`Error: ${t.message}`];return e.push(`\nSuggestion: ${t.suggestion}`),t.recovery&&e.push(`\nRecovery action: ${t.recovery}`),e.join("")},e.ensureBrowserNavigationAllowed=async function(t){await a.commands.executeCommand(e.ORIGIN_NAVIGATION_COMMAND,{url:t})},e.ensureCurrentPageAllowed=async function(t,n){const r=await a.commands.executeCommand(e.BROWSER_GET_URL_COMMAND,n);await a.commands.executeCommand(e.ORIGIN_PAGE_COMMAND,{toolName:t,url:r})},e.accessibilityTreeToYaml=m,e.writeSnapshotToFile=g,e.executeInBrowser=w,e.validateBrowserResult=function(t,e){if(null==t)throw new Error("Browser execution returned null or undefined");if("object"!=typeof t)throw new Error("Browser execution returned non-object: "+typeof t);const n=t;if("boolean"!=typeof n.success)throw new Error('Browser result missing required "success" field');for(const t of e)if(!(t in n))throw new Error(`Browser result missing required field: ${String(t)}`);return t},e.formatPageStateResult=async function(t){const{action:n,detailLines:r,pageState:o,viewId:s,snapshotYaml:i,includeSnapshotDiff:a}=t;if(o?.snapshot){const t=i??m(o.snapshot),l=o.url,c=o.title,u=s?f.get(s):void 0,h=Boolean(a&&u&&u!==t),w=h&&u?(0,d.createPatch)("snapshot",u,t,"previous","current",{context:2}):void 0,b=w?Buffer.byteLength(w,"utf8"):0,v=void 0!==w&&b>0&&b<=e.SNAPSHOT_DIFF_SIZE_THRESHOLD,x=Buffer.byteLength(t,"utf8");if(x>e.SNAPSHOT_SIZE_THRESHOLD)try{const{filePath:o,previewLines:i,totalLines:a}=await g(t),u=[];u.push(`### Action: ${n}`),r&&r.length>0&&u.push(...r),s&&u.push(`- Browser View ID: ${s}`),u.push("\n### Page state",`- Page URL: ${l}`,`- Page Title: ${c}`,`- Page Snapshot: Large snapshot (${x} bytes, ${a} lines) written to file`,`- Snapshot File: [${o}](file://${o})`,`- Preview (first ${i.length} lines):`,"```yaml",i.join("\n"),"```",`\n... (${a-i.length} more lines in file)`),v&&w?u.push("\n### Snapshot diff (previous vs current)","```diff",w,"```"):h&&b>e.SNAPSHOT_DIFF_SIZE_THRESHOLD&&u.push("\n### Snapshot diff (previous vs current)",`- Diff too large to include inline (${b} bytes).`);const d=[{type:"text",text:u.join("\n")}];return s&&d.push(await y(s,{title:c,url:l})),{content:d}}catch(t){p.CursorIDEBrowserLogger.error("Failed to write snapshot to file, returning inline:",t)}const E=[];E.push(`### Action: ${n}`),r&&r.length>0&&E.push(...r),s&&E.push(`- Browser View ID: ${s}`),E.push("\n### Page state",`- Page URL: ${l}`,`- Page Title: ${c}`,"- Page Snapshot:","```yaml",t,"```"),v&&w?E.push("\n### Snapshot diff (previous vs current)","```diff",w,"```"):h&&b>e.SNAPSHOT_DIFF_SIZE_THRESHOLD&&E.push("\n### Snapshot diff (previous vs current)",`- Diff too large to include inline (${b} bytes).`);const S=[{type:"text",text:E.join("\n")}];return s&&S.push(await y(s,{title:c,url:l})),{content:S}}const l=[{type:"text",text:JSON.stringify(t)}];return s&&l.push(await y(s)),{content:l}},e.resolveViewId=async function(t){if(t)return t;const e=await a.commands.executeCommand("cursor.browserView.listTabs");return e?.lastInteractedTab??e?.activeTab??e?.tabs?.[0]},e.shouldAutoSnapshot=b,e.ensureFreshSnapshot=async function(t,n,r){if(b(t)){if(p.CursorIDEBrowserLogger.info(`Auto-snapshotting view ${t} (stale or missing)`),!r)throw new Error("browserUtils must be provided for ensureFreshSnapshot");const o=`${r} buildPageSnapshot();`;await w(o,t,n),e.viewSnapshotTimestamps.set(t,Date.now())}},e.setSnapshotYaml=function(t,e){f.set(t,e)},e.createMetadata=y,e.getScreenshot=v,e.maybeAddScreenshotToResult=async function(t,e,n){if(!n)return t;const r=await v(e);return r&&t.content.push(r),t};const a=i(n(398)),l=i(n(943)),c=i(n(928)),u=i(n(857)),d=n(254),p=n(377);Object.defineProperty(e,"CursorIDEBrowserLogger",{enumerable:!0,get:function(){return p.CursorIDEBrowserLogger}}),e.SNAPSHOT_SIZE_THRESHOLD=25600,e.SNAPSHOT_PREVIEW_LINES=50,e.SNAPSHOT_DIFF_SIZE_THRESHOLD=20480,e.TEMP_LOG_DIR=c.join(u.homedir(),".cursor","browser-logs"),e.ORIGIN_NAVIGATION_COMMAND="cursor.browserOriginAllowlist.ensureNavigationAllowed",e.ORIGIN_PAGE_COMMAND="cursor.browserOriginAllowlist.ensurePageOriginAllowed",e.BROWSER_GET_URL_COMMAND="cursor.browserView.getURL",e.SNAPSHOT_STALENESS_THRESHOLD_MS=1e4,e.viewSnapshotTimestamps=new Map;const f=new Map;e.ELEMENT_FINDER="\nfunction findElementByRef(ref) {\n\tlet element = document.querySelector('[data-cursor-ref=\"' + ref + '\"]');\n\tif (element) {\n\t\tconst rect = element.getBoundingClientRect();\n\t\tif (rect.width > 0 || rect.height > 0) {\n\t\t\treturn { element, method: 'ref-attribute' };\n\t\t}\n\t}\n\treturn { element: null, method: 'not-found' };\n}\n\nfunction getElementDescription(element) {\n\tif (!element) return '';\n\tconst tag = element.tagName?.toLowerCase() || '';\n\tconst role = element.getAttribute('role') || '';\n\tconst ariaLabel = element.getAttribute('aria-label') || '';\n\tconst text = (element.textContent || '').trim().substring(0, 50);\n\tconst parts = [];\n\tif (tag) parts.push(tag);\n\tif (role) parts.push('role=' + role);\n\tif (ariaLabel) parts.push('aria-label=\"' + ariaLabel + '\"');\n\telse if (text) parts.push('text=\"' + text + '\"');\n\treturn parts.length > 0 ? ' (' + parts.join(', ') + ')' : '';\n}\n\nfunction assertDescriptionMatches(element, ref, expectedDescription) {\n\tconst actualDescription = getElementDescription(element);\n\tif (expectedDescription) {\n\t\tconst expectedLower = expectedDescription.toLowerCase();\n\t\tconst actualLower = actualDescription.toLowerCase();\n\n\t\tconst actualTextMatch = actualLower.match(/text=\"([^\"]+)\"/);\n\t\tconst actualText = actualTextMatch ? actualTextMatch[1] : '';\n\n\t\tconst actualTag = element.tagName?.toLowerCase() || '';\n\t\tconst actualRole = element.getAttribute?.('role')?.toLowerCase() || '';\n\n\t\tconst expectedMentionsButton = expectedLower.includes('button');\n\t\tconst actualIsButton = actualTag === 'button' || actualRole === 'button' || actualLower.includes('button');\n\n\t\tif (expectedMentionsButton && !actualIsButton) {\n\t\t\tthrow new Error('Stale element reference: ' + ref + ' expected a button but found ' + actualDescription + '. The page may have changed. Take a new snapshot.');\n\t\t}\n\n\t\tconst expectedWords = expectedLower.replace(/button|link|input|checkbox|radio/g, '').trim().split(/\\s+/).filter(w => w.length > 2);\n\t\tif (expectedWords.length > 0 && actualText) {\n\t\t\tconst hasMatchingWord = expectedWords.some(word => actualText.includes(word));\n\t\t\tif (!hasMatchingWord) {\n\t\t\t\tthrow new Error('Stale element reference: ' + ref + ' now points to' + actualDescription + ' but was expected to be \"' + expectedDescription + '\". The page may have changed. Take a new snapshot.');\n\t\t\t}\n\t\t}\n\t}\n}\n\nfunction validateElementForInteraction(element, ref, action, expectedDescription) {\n\tif (!element) {\n\t\tthrow new Error('Element not found: ' + ref + '. Take a snapshot to get updated refs.');\n\t}\n\n\tassertDescriptionMatches(element, ref, expectedDescription);\n\n\tconst actualDescription = getElementDescription(element);\n\n\tconst rect = element.getBoundingClientRect();\n\tif (rect.width === 0 && rect.height === 0) {\n\t\tthrow new Error('Element ' + ref + actualDescription + ' is not visible (zero dimensions). It may be hidden or collapsed.');\n\t}\n\n\tconst style = window.getComputedStyle(element);\n\tif (style.display === 'none') {\n\t\tthrow new Error('Element ' + ref + actualDescription + ' is hidden (display: none).');\n\t}\n\tif (style.visibility === 'hidden') {\n\t\tthrow new Error('Element ' + ref + actualDescription + ' is hidden (visibility: hidden).');\n\t}\n\tif (parseFloat(style.opacity) === 0) {\n\t\tthrow new Error('Element ' + ref + actualDescription + ' is not visible (opacity: 0). Wait for it to appear.');\n\t}\n\tif (style.pointerEvents === 'none' && action !== 'type' && action !== 'fill') {\n\t\tthrow new Error('Element ' + ref + actualDescription + ' has pointer-events: none and cannot receive ' + action + ' interactions. Try clicking a parent element or waiting for a loading state to complete.');\n\t}\n\n\tif (element.disabled) {\n\t\tthrow new Error('Element ' + ref + actualDescription + ' is disabled and cannot be interacted with. Enable the element first or interact with a different element.');\n\t}\n\tlet parent = element.parentElement;\n\twhile (parent) {\n\t\tif (parent.tagName === 'FIELDSET' && parent.disabled) {\n\t\t\tthrow new Error('Element ' + ref + actualDescription + ' is inside a disabled fieldset and cannot be interacted with. Enable the fieldset first or interact with elements outside it.');\n\t\t}\n\t\tparent = parent.parentElement;\n\t}\n\n\tif (action === 'type' || action === 'fill') {\n\t\tconst tag = element.tagName?.toLowerCase();\n\t\tconst isContentEditable = element.isContentEditable || element.getAttribute('contenteditable') === 'true';\n\t\tconst isReadonly = element.readOnly || element.getAttribute('readonly') !== null;\n\t\tconst isTextInput = (tag === 'input' && !['button', 'submit', 'reset', 'checkbox', 'radio', 'file', 'image', 'hidden'].includes(element.type?.toLowerCase())) ||\n\t\t\ttag === 'textarea' ||\n\t\t\tisContentEditable;\n\t\tif (!isTextInput) {\n\t\t\tthrow new Error('Element ' + ref + actualDescription + ' is not a text input, textarea, or contenteditable element. Use browser_click instead if you want to interact with this element.');\n\t\t}\n\t\tif (isReadonly && !isContentEditable) {\n\t\t\tthrow new Error('Element ' + ref + actualDescription + ' is readonly and cannot be modified. The value is set programmatically and cannot be changed by user input.');\n\t\t}\n\t}\n\n\treturn true;\n}\n\nfunction previewNode(element) {\n\tif (!element) return 'null';\n\tconst tag = element.tagName?.toLowerCase() || 'unknown';\n\tconst attrs = [];\n\tif (element.id) attrs.push('id=\"' + element.id + '\"');\n\tif (element.className && typeof element.className === 'string') {\n\t\tconst classes = element.className.trim().split(/\\s+/).slice(0, 2).join(' ');\n\t\tif (classes) attrs.push('class=\"' + classes + '\"');\n\t}\n\tif (element.getAttribute && element.getAttribute('role')) {\n\t\tattrs.push('role=\"' + element.getAttribute('role') + '\"');\n\t}\n\tif (element.getAttribute && element.getAttribute('data-cursor-ref')) {\n\t\tattrs.push('ref=\"' + element.getAttribute('data-cursor-ref') + '\"');\n\t}\n\tconst text = (element.textContent || '').trim().substring(0, 30);\n\tconst textPart = text ? '>' + text + '...' : '';\n\treturn '<' + tag + (attrs.length ? ' ' + attrs.join(' ') : '') + textPart + '>';\n}\n\nfunction expectHitTarget(hitPoint, targetElement, targetRef) {\n\tconst doc = hitPoint.ownerDocument || document;\n\tlet hitElement = doc.elementFromPoint(hitPoint.x, hitPoint.y);\n\t\n\tif (!hitElement) {\n\t\treturn {\n\t\t\thit: false,\n\t\t\tinterceptedBy: 'nothing (coordinates outside viewport)',\n\t\t\terror: 'Click coordinates (' + hitPoint.x + ', ' + hitPoint.y + ') are outside the visible viewport.',\n\t\t\tsuggestion: 'The element may be scrolled out of view. Try using browser_scroll with scrollIntoView: true first.'\n\t\t};\n\t}\n\n\tif (hitElement === targetElement || targetElement.contains(hitElement)) {\n\t\treturn { hit: true };\n\t}\n\t\n\tif (targetElement.contains(hitElement.parentElement)) {\n\t\treturn { hit: true };\n\t}\n\n\tfunction isScrollContainer(el) {\n\t\tconst style = window.getComputedStyle(el);\n\t\tconst overflowY = style.overflowY;\n\t\tconst overflowX = style.overflowX;\n\t\treturn (overflowY === 'auto' || overflowY === 'scroll' || overflowX === 'auto' || overflowX === 'scroll') &&\n\t\t\t(el.scrollHeight > el.clientHeight || el.scrollWidth > el.clientWidth);\n\t}\n\n\tfunction isElementClippedByContainer(el, container) {\n\t\tconst elRect = el.getBoundingClientRect();\n\t\tconst containerRect = container.getBoundingClientRect();\n\t\treturn elRect.top < containerRect.top || elRect.bottom > containerRect.bottom ||\n\t\t\telRect.left < containerRect.left || elRect.right > containerRect.right;\n\t}\n\n\tlet current = hitElement;\n\twhile (current && current !== targetElement && current !== document.body) {\n\t\tconst tagName = current.tagName?.toLowerCase() || '';\n\t\tconst role = current.getAttribute?.('role') || '';\n\t\tconst style = window.getComputedStyle(current);\n\t\tconst position = style.position;\n\t\tconst zIndex = parseInt(style.zIndex, 10);\n\t\tconst hasHighZIndex = !isNaN(zIndex) && zIndex > 100;\n\t\tconst isFixed = position === 'fixed' || position === 'absolute';\n\t\t\n\t\tconst isDialog = tagName === 'dialog' || role === 'dialog' || role === 'alertdialog';\n\t\tconst isModal = current.getAttribute?.('aria-modal') === 'true';\n\t\tconst isIframe = tagName === 'iframe';\n\t\tconst isNavOrHeader = tagName === 'nav' || tagName === 'header' || role === 'navigation' || role === 'banner';\n\n\t\tif (isIframe) {\n\t\t\tconst hitRef = current.getAttribute('data-cursor-ref');\n\t\t\tconst preview = previewNode(current);\n\t\t\treturn {\n\t\t\t\thit: false,\n\t\t\t\tinterceptedBy: preview,\n\t\t\t\tinterceptedRef: hitRef || undefined,\n\t\t\t\tblockingType: 'iframe',\n\t\t\t\terror: 'Click would hit an iframe instead of the target element.',\n\t\t\t\tsuggestion: 'The target is behind an iframe. Iframe content cannot be interacted with directly. ' + (hitRef ? 'The iframe has ref ' + hitRef + '.' : 'Navigate to the iframe URL directly if you need to interact with its content.')\n\t\t\t};\n\t\t}\n\n\t\tif (isDialog || isModal) {\n\t\t\tconst hitRef = current.getAttribute('data-cursor-ref');\n\t\t\tconst preview = previewNode(current);\n\t\t\treturn {\n\t\t\t\thit: false,\n\t\t\t\tinterceptedBy: preview,\n\t\t\t\tinterceptedRef: hitRef || undefined,\n\t\t\t\tblockingType: 'modal',\n\t\t\t\terror: 'Click would hit a modal/dialog instead of the target element.',\n\t\t\t\tsuggestion: 'A modal or dialog is blocking the target. Close it first by pressing Escape (browser_press_key with key \"Escape\") or clicking its close button.'\n\t\t\t};\n\t\t}\n\n\t\tif (isScrollContainer(current)) {\n\t\t\tif (targetElement.closest && current.contains(targetElement)) {\n\t\t\t\tif (isElementClippedByContainer(targetElement, current)) {\n\t\t\t\t\tconst hitRef = current.getAttribute('data-cursor-ref');\n\t\t\t\t\tconst preview = previewNode(current);\n\t\t\t\t\treturn {\n\t\t\t\t\t\thit: false,\n\t\t\t\t\t\tinterceptedBy: preview,\n\t\t\t\t\t\tinterceptedRef: hitRef || undefined,\n\t\t\t\t\t\tblockingType: 'scroll-container',\n\t\t\t\t\t\terror: 'The target element is clipped by a scroll container (' + preview + '). The element exists but is not visible within its scrollable parent.',\n\t\t\t\t\t\tsuggestion: 'Use browser_scroll with the target ref and scrollIntoView: true to scroll the element into view within its container.' + (hitRef ? ' The scroll container has ref ' + hitRef + '.' : '')\n\t\t\t\t\t};\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\tif (isNavOrHeader && isFixed) {\n\t\t\tconst hitRef = current.getAttribute('data-cursor-ref');\n\t\t\tconst preview = previewNode(current);\n\t\t\treturn {\n\t\t\t\thit: false,\n\t\t\t\tinterceptedBy: preview,\n\t\t\t\tinterceptedRef: hitRef || undefined,\n\t\t\t\tblockingType: 'fixed-header',\n\t\t\t\terror: 'Click would hit a fixed header/navigation bar instead of the target.',\n\t\t\t\tsuggestion: 'A fixed header/navigation bar is blocking the target. Try scrolling the page so the target is not behind the fixed element, or click directly on the header element if that is the intent.'\n\t\t\t};\n\t\t}\n\n\t\tif (hasHighZIndex && isFixed && !isScrollContainer(current)) {\n\t\t\tconst hitRef = current.getAttribute('data-cursor-ref');\n\t\t\tconst preview = previewNode(current);\n\t\t\treturn {\n\t\t\t\thit: false,\n\t\t\t\tinterceptedBy: preview,\n\t\t\t\tinterceptedRef: hitRef || undefined,\n\t\t\t\tblockingType: 'overlay',\n\t\t\t\terror: 'Click would hit an overlay element (' + preview + ') instead of the target.',\n\t\t\t\tsuggestion: hitRef \n\t\t\t\t\t? 'An overlay (ref: ' + hitRef + ') is blocking the target. Either click that element directly, or dismiss/close the overlay first.'\n\t\t\t\t\t: 'An overlay element is blocking the target. Close or dismiss this overlay before interacting with elements behind it. Try pressing Escape or looking for a close button.'\n\t\t\t};\n\t\t}\n\t\t\n\t\tcurrent = current.parentElement;\n\t}\n\n\tif (current !== targetElement && !targetElement.contains(hitElement)) {\n\t\tconst hitRef = hitElement.getAttribute('data-cursor-ref');\n\t\tconst preview = previewNode(hitElement);\n\t\tconst targetRect = targetElement.getBoundingClientRect();\n\t\tconst isTargetOffscreen = targetRect.bottom < 0 || targetRect.top > window.innerHeight || \n\t\t\ttargetRect.right < 0 || targetRect.left > window.innerWidth;\n\t\t\n\t\tif (isTargetOffscreen) {\n\t\t\treturn {\n\t\t\t\thit: false,\n\t\t\t\tinterceptedBy: preview,\n\t\t\t\tinterceptedRef: hitRef || undefined,\n\t\t\t\tblockingType: 'offscreen',\n\t\t\t\terror: 'The target element is outside the visible viewport.',\n\t\t\t\tsuggestion: 'Use browser_scroll with scrollIntoView: true to bring the target into view first.'\n\t\t\t};\n\t\t}\n\t\t\n\t\tconst hitElementStyle = window.getComputedStyle(hitElement);\n\t\tconst hitTagName = hitElement.tagName?.toLowerCase() || '';\n\t\tconst isHitScrollContainer = isScrollContainer(hitElement);\n\t\t\n\t\tif (isHitScrollContainer && hitElement.contains(targetElement)) {\n\t\t\treturn {\n\t\t\t\thit: false,\n\t\t\t\tinterceptedBy: preview,\n\t\t\t\tinterceptedRef: hitRef || undefined,\n\t\t\t\tblockingType: 'scroll-container',\n\t\t\t\terror: 'The target is inside a scroll container but not in the visible scroll area. The click would hit the scroll container instead.',\n\t\t\t\tsuggestion: 'Use browser_scroll with the target ref and scrollIntoView: true to scroll the element into view within its container.'\n\t\t\t};\n\t\t}\n\t\t\n\t\treturn {\n\t\t\thit: false,\n\t\t\tinterceptedBy: preview,\n\t\t\tinterceptedRef: hitRef || undefined,\n\t\t\tblockingType: 'sibling',\n\t\t\terror: 'Click would hit a different element (' + preview + ') instead of the target.',\n\t\t\tsuggestion: hitRef \n\t\t\t\t? 'The element at the click position has ref ' + hitRef + '. Click that ref if it is the intended target, or take a snapshot to see updated element positions.'\n\t\t\t\t: 'Another element is at the click position. Take a snapshot to see the current page layout and find the correct element ref.'\n\t\t};\n\t}\n\t\n\treturn { hit: true };\n}\n";const h=[{patterns:["element not found","cannot find"],getMessage:t=>"Element not found"+(t?.ref?`: ${t.ref}`:""),suggestion:"Take a snapshot first to see the current page state and available element refs. The refs might have changed since the last snapshot.",recovery:"browser_snapshot"},{patterns:["is not a text input","use click instead"],getMessage:t=>"Element is not a text input"+(t?.ref?`: ${t.ref}`:""),suggestion:"This element cannot accept text input. If you need to interact with it, use browser_click instead. If you need to type, find the actual input element.",recovery:"browser_click or browser_snapshot to find correct input"},{patterns:["timeout","timed out"],getMessage:()=>"Operation timed out",suggestion:"The page might be slow to respond. Try waiting a bit and then taking a snapshot to check the current state.",recovery:"browser_wait_for with time parameter"},{patterns:["not visible","hidden","obscured","zero dimensions"],getMessage:t=>"Element is not visible or interactable"+(t?.ref?`: ${t.ref}`:""),suggestion:"The element might be hidden, covered by another element, or outside the viewport. Try scrolling to bring it into view, or dismiss any overlays first.",recovery:"browser_scroll or browser_press_key with Escape to close modal"},{patterns:["multiple elements","ambiguous"],getMessage:t=>"Multiple elements match the selector"+(t?.selector?`: ${t.selector}`:""),suggestion:"Use a more specific selector or take a snapshot to see the element refs, then use the ref directly.",recovery:"browser_snapshot to get specific refs"},{patterns:["pointer-events: none","pointer-events:none"],getMessage:t=>"Element has pointer-events: none CSS property"+(t?.ref?`: ${t.ref}`:""),suggestion:"This element cannot receive pointer events due to its CSS. The element may be decorative or the interaction should target a different element.",recovery:"browser_snapshot to find an alternative clickable element"},{patterns:["blocked by an overlay","blocked by a modal"],getMessage:(t,e)=>e||"Element is blocked by an overlay or modal"+(t?.ref?`: ${t.ref}`:""),suggestion:"Close the modal or overlay first before interacting with elements behind it. If no modal is visible, try taking a fresh snapshot as element refs may be stale.",recovery:"browser_snapshot to refresh refs, or browser_press_key with Escape"},{patterns:["failed to focus"],getMessage:(t,e)=>e||"Failed to focus element"+(t?.ref?`: ${t.ref}`:""),suggestion:"The element could not receive focus. Check if another element is covering it, if it has a negative tabindex, or if it is disabled. Take a snapshot to verify current element state.",recovery:"browser_snapshot to check element state"},{patterns:["navigation","redirect"],getMessage:()=>"Navigation occurred during the operation",suggestion:"Wait for navigation to complete and take a new snapshot to see the updated page state.",recovery:"browser_snapshot after navigation completes"},{patterns:["detached","stale"],getMessage:()=>"Element reference is stale (page has changed)",suggestion:"The page content has changed since the last snapshot. Take a new snapshot to get updated refs.",recovery:"browser_snapshot"},{patterns:["disabled fieldset"],getMessage:t=>"Element is inside a disabled fieldset"+(t?.ref?`: ${t.ref}`:""),suggestion:"The element is inside a <fieldset disabled> and cannot be interacted with. Enable the fieldset first or interact with elements outside of it.",recovery:"browser_snapshot to find alternative elements"},{patterns:["opacity: 0","opacity:0"],getMessage:t=>"Element has opacity: 0 and is not visible"+(t?.ref?`: ${t.ref}`:""),suggestion:"This element is invisible due to CSS opacity. Wait for it to become visible or interact with a different element.",recovery:"browser_wait_for or browser_snapshot"},{patterns:["option","not found"],allRequired:!0,getMessage:()=>"Option value not found in select element",suggestion:"Take a snapshot to see the available options in the select element.",recovery:"browser_snapshot"},{patterns:["readonly","disabled"],getMessage:t=>"Element is readonly or disabled"+(t?.ref?`: ${t.ref}`:""),suggestion:"This element cannot be modified directly. Check if there is a way to enable it first.",recovery:"Check element states in snapshot"},{patterns:["clipped by a scroll container","scroll container"],getMessage:(t,e)=>e||"Element is clipped by a scroll container"+(t?.ref?`: ${t.ref}`:""),suggestion:"The element is inside a scrollable container but not in the visible scroll area. Use browser_scroll with scrollIntoView: true.",recovery:"browser_scroll with ref and scrollIntoView: true"},{patterns:["coordinates","outside","viewport"],allRequired:!0,getMessage:t=>"Click coordinates are outside the visible viewport"+(t?.ref?` for element ${t.ref}`:""),suggestion:"The element may be in a nested scroll container. Try using browser_scroll with the element ref and scrollIntoView: true first.",recovery:"browser_scroll with ref and scrollIntoView: true"}];function m(t,e=0){const n="  ".repeat(e),r=[];if(t.role&&r.push(`${n}- role: ${t.role}`),t.name){const e=String(t.name).replace(/\n/g," ").trim();e.includes(":")||e.includes('"')||e.includes("[")?r.push(`${n}  name: "${e.replace(/"/g,'\\"')}"`):r.push(`${n}  name: ${e}`)}if(t.ref&&r.push(`${n}  ref: ${t.ref}`),void 0!==t.nth&&t.nth>0&&r.push(`${n}  nth: ${t.nth}`),void 0!==t.value&&""!==t.value){const e=String(t.value).replace(/\n/g,"\\n").substring(0,100);e.includes(":")||e.includes('"')||e.includes("[")?r.push(`${n}  value: "${e.replace(/"/g,'\\"')}"`):r.push(`${n}  value: ${e}`)}if(void 0!==t.placeholder&&""!==t.placeholder&&r.push(`${n}  placeholder: ${t.placeholder}`),void 0!==t.options&&""!==t.options){const e=String(t.options).replace(/\n/g," ").substring(0,300);e.includes(":")||e.includes('"')?r.push(`${n}  options: "${e.replace(/"/g,'\\"')}"`):r.push(`${n}  options: [${e}]`)}if(void 0!==t.level&&r.push(`${n}  level: ${t.level}`),t.states&&t.states.length>0&&r.push(`${n}  states: [${t.states.join(", ")}]`),t.children&&t.children.length>0){r.push(`${n}  children:`);for(const n of t.children)r.push(m(n,e+2))}return r.join("\n")}async function g(t){await l.mkdir(e.TEMP_LOG_DIR,{recursive:!0});const n=`snapshot-${(new Date).toISOString().replace(/[:.]/g,"-")}.log`,r=c.join(e.TEMP_LOG_DIR,n),o=t.split("\n"),s=o.length,i=o.slice(0,Math.min(e.SNAPSHOT_PREVIEW_LINES,s));return await l.writeFile(r,t,"utf8"),p.CursorIDEBrowserLogger.info(`Large snapshot redirected to: ${r} (${s} lines, ${i.length} preview lines)`),{filePath:r,previewLines:i,totalLines:s}}async function w(t,e,n){try{return await a.commands.executeCommand("cursor.browserView.executeJavaScript",t,e,n)}catch(t){throw p.CursorIDEBrowserLogger.error("Failed to execute JavaScript in browser:",t),t}}function b(t){const n=e.viewSnapshotTimestamps.get(t);return!n||Date.now()-n>e.SNAPSHOT_STALENESS_THRESHOLD_MS}async function y(t,e){const n=await a.commands.executeCommand("cursor.browserView.isLocked",t);return{type:"metadata",viewId:t,title:e?.title,url:e?.url,locked:n??!1}}async function v(t){try{p.CursorIDEBrowserLogger.info(`[getScreenshot] viewId=${t}, taking screenshot`);const n=await a.commands.executeCommand("cursor.browserView.takeScreenshot",{viewId:t,type:"png",fullPage:!1});if(!n.success||!n.dataUrl)return void p.CursorIDEBrowserLogger.warn(`Failed to take screenshot: ${n.error}`);try{const r=await a.commands.executeCommand(e.BROWSER_GET_URL_COMMAND,t);await a.commands.executeCommand("cursor.browserView.updateScreenshot",t,n.dataUrl,r)}catch(t){p.CursorIDEBrowserLogger.warn(`Failed to update screenshot service: ${t}`)}const r=n.dataUrl.match(/^data:([^;]+);base64,(.+)$/);if(!r)return;const o=r[1];return{type:"image",data:r[2],mimeType:o}}catch(t){return void p.CursorIDEBrowserLogger.warn(`Error taking screenshot: ${t}`)}}},377:function(t,e,n){var r,o=this&&this.__createBinding||(Object.create?function(t,e,n,r){void 0===r&&(r=n);var o=Object.getOwnPropertyDescriptor(e,n);o&&!("get"in o?!e.__esModule:o.writable||o.configurable)||(o={enumerable:!0,get:function(){return e[n]}}),Object.defineProperty(t,r,o)}:function(t,e,n,r){void 0===r&&(r=n),t[r]=e[n]}),s=this&&this.__setModuleDefault||(Object.create?function(t,e){Object.defineProperty(t,"default",{enumerable:!0,value:e})}:function(t,e){t.default=e}),i=this&&this.__importStar||(r=function(t){return r=Object.getOwnPropertyNames||function(t){var e=[];for(var n in t)Object.prototype.hasOwnProperty.call(t,n)&&(e[e.length]=n);return e},r(t)},function(t){if(t&&t.__esModule)return t;var e={};if(null!=t)for(var n=r(t),i=0;i<n.length;i++)"default"!==n[i]&&o(e,t,n[i]);return s(e,t),e});Object.defineProperty(e,"__esModule",{value:!0}),e.CursorIDEBrowserLogger=void 0;const a=i(n(398));class l{constructor(t){this.identifier=t}static init(){this.outputChannel||(this.outputChannel=a.window.createOutputChannel("Cursor IDE Browser Automation"))}static getLogger(t){return this.loggers.has(t)||this.loggers.set(t,new l(t)),this.loggers.get(t)}static info(t){this.log("INFO","general",t)}static warn(t){this.log("WARN","general",t)}static error(t,e){const n=e?`${t}: ${e.message}`:t;this.log("ERROR","general",n),e?.stack&&this.log("ERROR","general",e.stack)}info(t){l.log("INFO",this.identifier,t)}warn(t){l.log("WARN",this.identifier,t)}error(t,e){const n=e?`${t}: ${e.message}`:t;l.log("ERROR",this.identifier,n),e?.stack&&l.log("ERROR",this.identifier,e.stack)}static log(t,e,n){if(this.outputChannel){const r=(new Date).toISOString();this.outputChannel.appendLine(`[${r}] [${t}] [${e}] ${n}`)}}}e.CursorIDEBrowserLogger=l,l.loggers=new Map},398:t=>{t.exports=require("vscode")},453:(t,e,n)=>{Object.defineProperty(e,"__esModule",{value:!0}),e.BrowserTools=void 0;const r=n(67),o=n(149),s=n(513),i=n(709),a=n(696),l=n(148);e.BrowserTools=function(){const t={},e=(0,r.createNavigationTools)(t),n=(0,o.createSnapshotTools)(t),c=(0,s.createInteractionTools)(t),u=(0,i.createInputTools)(t),d=(0,a.createWaitTools)(t),p=(0,l.createStateTools)(t);return Object.assign(t,e),Object.assign(t,n),Object.assign(t,c),Object.assign(t,u),Object.assign(t,d),Object.assign(t,p),t}()},513:(t,e,n)=>{Object.defineProperty(e,"__esModule",{value:!0}),e.createInteractionTools=function(t){return{async click(t){const e=await(0,o.resolveViewId)(t.viewId);if(!e)return{content:[{type:"text",text:"No browser tab available. Please navigate to a page first."}]};try{await(0,o.ensureCurrentPageAllowed)("browser_click",e),await(0,o.ensureFreshSnapshot)(e,t.headless,r.BROWSER_UTILS);const n=(0,o.parseRef)(t.ref),s=t.element||"",i=`\n\t\t\t\t\t${o.ELEMENT_FINDER}\n\t\t\t\t\t${r.BROWSER_UTILS}\n\t\t\t\t\t(async function() {\n\t\t\t\t\t\tconst ref = ${JSON.stringify(n)};\n\t\t\t\t\t\tconst expectedDescription = ${JSON.stringify(s)};\n\t\t\t\t\t\tconst offsetX = ${t.offsetX??"null"};\n\t\t\t\t\t\tconst offsetY = ${t.offsetY??"null"};\n\t\t\t\t\t\tconst holdDurationMs = ${t.holdDurationMs??0};\n\t\t\t\t\t\t\n\t\t\t\t\t\tconst { element } = findElementByRef(ref);\n\t\t\t\t\t\tvalidateElementForInteraction(element, ref, 'click', expectedDescription);\n\n\t\t\t\t\t\tfunction getScrollableAncestors(el) {\n\t\t\t\t\t\t\tconst ancestors = [];\n\t\t\t\t\t\t\tlet current = el.parentElement;\n\t\t\t\t\t\t\twhile (current && current !== document.body && current !== document.documentElement) {\n\t\t\t\t\t\t\t\tconst style = window.getComputedStyle(current);\n\t\t\t\t\t\t\t\tconst overflowY = style.overflowY;\n\t\t\t\t\t\t\t\tconst overflowX = style.overflowX;\n\t\t\t\t\t\t\t\tconst isScrollable = (\n\t\t\t\t\t\t\t\t\t(overflowY === 'auto' || overflowY === 'scroll' || overflowX === 'auto' || overflowX === 'scroll') &&\n\t\t\t\t\t\t\t\t\t(current.scrollHeight > current.clientHeight || current.scrollWidth > current.clientWidth)\n\t\t\t\t\t\t\t\t);\n\t\t\t\t\t\t\t\tif (isScrollable) {\n\t\t\t\t\t\t\t\t\tancestors.push(current);\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\tcurrent = current.parentElement;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\treturn ancestors;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tfunction isElementVisibleInContainer(el, container) {\n\t\t\t\t\t\t\tconst elRect = el.getBoundingClientRect();\n\t\t\t\t\t\t\tconst containerRect = container.getBoundingClientRect();\n\t\t\t\t\t\t\treturn (\n\t\t\t\t\t\t\t\telRect.top >= containerRect.top &&\n\t\t\t\t\t\t\t\telRect.bottom <= containerRect.bottom &&\n\t\t\t\t\t\t\t\telRect.left >= containerRect.left &&\n\t\t\t\t\t\t\t\telRect.right <= containerRect.right\n\t\t\t\t\t\t\t);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tfunction scrollElementIntoContainer(el, container) {\n\t\t\t\t\t\t\tconst elRect = el.getBoundingClientRect();\n\t\t\t\t\t\t\tconst containerRect = container.getBoundingClientRect();\n\t\t\t\t\t\t\t\n\t\t\t\t\t\t\tlet scrollTopDelta = 0;\n\t\t\t\t\t\t\tlet scrollLeftDelta = 0;\n\t\t\t\t\t\t\t\n\t\t\t\t\t\t\tif (elRect.top < containerRect.top) {\n\t\t\t\t\t\t\t\tscrollTopDelta = elRect.top - containerRect.top - 20;\n\t\t\t\t\t\t\t} else if (elRect.bottom > containerRect.bottom) {\n\t\t\t\t\t\t\t\tscrollTopDelta = elRect.bottom - containerRect.bottom + 20;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\n\t\t\t\t\t\t\tif (elRect.left < containerRect.left) {\n\t\t\t\t\t\t\t\tscrollLeftDelta = elRect.left - containerRect.left - 20;\n\t\t\t\t\t\t\t} else if (elRect.right > containerRect.right) {\n\t\t\t\t\t\t\t\tscrollLeftDelta = elRect.right - containerRect.right + 20;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\n\t\t\t\t\t\t\tif (scrollTopDelta !== 0 || scrollLeftDelta !== 0) {\n\t\t\t\t\t\t\t\tcontainer.scrollBy({ top: scrollTopDelta, left: scrollLeftDelta, behavior: 'instant' });\n\t\t\t\t\t\t\t\treturn true;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tconst scrollableAncestors = getScrollableAncestors(element);\n\t\t\t\t\t\tfor (const container of scrollableAncestors) {\n\t\t\t\t\t\t\tif (!isElementVisibleInContainer(element, container)) {\n\t\t\t\t\t\t\t\tscrollElementIntoContainer(element, container);\n\t\t\t\t\t\t\t\tawait new Promise(r => setTimeout(r, 100));\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tlet rect = element.getBoundingClientRect();\n\t\t\t\t\t\tlet cx, cy;\n\t\t\t\t\t\t\n\t\t\t\t\t\tfunction computeClickPoint(r) {\n\t\t\t\t\t\t\tif (offsetX !== null && offsetY !== null) {\n\t\t\t\t\t\t\t\treturn { x: Math.round(r.left + offsetX), y: Math.round(r.top + offsetY) };\n\t\t\t\t\t\t\t} else if (offsetX !== null) {\n\t\t\t\t\t\t\t\treturn { x: Math.round(r.left + offsetX), y: Math.round(r.top + r.height / 2) };\n\t\t\t\t\t\t\t} else if (offsetY !== null) {\n\t\t\t\t\t\t\t\treturn { x: Math.round(r.left + r.width / 2), y: Math.round(r.top + offsetY) };\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\treturn { x: Math.round(r.left + r.width / 2), y: Math.round(r.top + r.height / 2) };\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\t\n\t\t\t\t\t\tlet clickPoint = computeClickPoint(rect);\n\t\t\t\t\t\tcx = clickPoint.x;\n\t\t\t\t\t\tcy = clickPoint.y;\n\n\t\t\t\t\t\tconst scrollPadding = 50;\n\t\t\t\t\t\tconst needsViewportScroll = rect.top < scrollPadding || rect.left < scrollPadding ||\n\t\t\t\t\t\t\trect.bottom > window.innerHeight - scrollPadding || rect.right > window.innerWidth - scrollPadding;\n\n\t\t\t\t\t\tif (needsViewportScroll) {\n\t\t\t\t\t\t\telement.scrollIntoView({ block: 'center', inline: 'center', behavior: 'smooth' });\n\t\t\t\t\t\t\tawait new Promise(r => setTimeout(r, 300));\n\t\t\t\t\t\t\trect = element.getBoundingClientRect();\n\t\t\t\t\t\t\tclickPoint = computeClickPoint(rect);\n\t\t\t\t\t\t\tcx = clickPoint.x;\n\t\t\t\t\t\t\tcy = clickPoint.y;\n\t\t\t\t\t\t}\n\t\t\t\t\t\t\n\t\t\t\t\t\tconst isOutsideViewport = cx < 0 || cy < 0 || cx > window.innerWidth || cy > window.innerHeight;\n\t\t\t\t\t\tif (isOutsideViewport) {\n\t\t\t\t\t\t\tconst containerInfo = scrollableAncestors.length > 0 \n\t\t\t\t\t\t\t\t? ' The element is inside ' + scrollableAncestors.length + ' nested scroll container(s).'\n\t\t\t\t\t\t\t\t: '';\n\t\t\t\t\t\t\treturn {\n\t\t\t\t\t\t\t\tsuccess: false,\n\t\t\t\t\t\t\t\thitTargetFailed: true,\n\t\t\t\t\t\t\t\terror: 'Click coordinates (' + cx + ', ' + cy + ') are outside the visible viewport after scrolling.' + containerInfo,\n\t\t\t\t\t\t\t\tblockingType: 'offscreen',\n\t\t\t\t\t\t\t\tsuggestion: scrollableAncestors.length > 0 \n\t\t\t\t\t\t\t\t\t? 'The element is inside nested scroll containers. Try using browser_scroll with the element ref and scrollIntoView: true, or scroll the parent container first.'\n\t\t\t\t\t\t\t\t\t: 'The element could not be scrolled into view. Try scrolling the page manually first.',\n\t\t\t\t\t\t\t\ttargetRef: ref,\n\t\t\t\t\t\t\t\ttargetPreview: previewNode(element),\n\t\t\t\t\t\t\t\tpageState: {\n\t\t\t\t\t\t\t\t\turl: window.location.href,\n\t\t\t\t\t\t\t\t\ttitle: document.title,\n\t\t\t\t\t\t\t\t\tsnapshot: buildPageSnapshot().tree\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t};\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tconst hitCheck = expectHitTarget({ x: cx, y: cy }, element, ref);\n\t\t\t\t\t\tif (!hitCheck.hit) {\n\t\t\t\t\t\t\treturn {\n\t\t\t\t\t\t\t\tsuccess: false,\n\t\t\t\t\t\t\t\thitTargetFailed: true,\n\t\t\t\t\t\t\t\terror: hitCheck.error || 'Click would not reach the intended element.',\n\t\t\t\t\t\t\t\tinterceptedBy: hitCheck.interceptedBy,\n\t\t\t\t\t\t\t\tinterceptedRef: hitCheck.interceptedRef,\n\t\t\t\t\t\t\t\tblockingType: hitCheck.blockingType,\n\t\t\t\t\t\t\t\tsuggestion: hitCheck.suggestion,\n\t\t\t\t\t\t\t\ttargetRef: ref,\n\t\t\t\t\t\t\t\ttargetPreview: previewNode(element),\n\t\t\t\t\t\t\t\tpageState: {\n\t\t\t\t\t\t\t\t\turl: window.location.href,\n\t\t\t\t\t\t\t\t\ttitle: document.title,\n\t\t\t\t\t\t\t\t\tsnapshot: buildPageSnapshot().tree\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t};\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tconst buttonValue = ${JSON.stringify(t.button)} === 'right' ? 2 :\n\t\t\t\t\t\t\t${JSON.stringify(t.button)} === 'middle' ? 1 : 0;\n\n\t\t\t\t\t\tconst modifiers = ${JSON.stringify(t.modifiers||[])};\n\n\t\t\t\t\t\tconst pointerEventOptions = {\n\t\t\t\t\t\t\tbubbles: true,\n\t\t\t\t\t\t\tcancelable: true,\n\t\t\t\t\t\t\tview: window,\n\t\t\t\t\t\t\tbutton: buttonValue,\n\t\t\t\t\t\t\tbuttons: 1 << buttonValue,\n\t\t\t\t\t\t\tctrlKey: modifiers.includes('Control') || modifiers.includes('ControlOrMeta'),\n\t\t\t\t\t\t\tshiftKey: modifiers.includes('Shift'),\n\t\t\t\t\t\t\taltKey: modifiers.includes('Alt'),\n\t\t\t\t\t\t\tmetaKey: modifiers.includes('Meta') || modifiers.includes('ControlOrMeta'),\n\t\t\t\t\t\t\tclientX: cx,\n\t\t\t\t\t\t\tclientY: cy,\n\t\t\t\t\t\t\tpointerId: 1,\n\t\t\t\t\t\t\tpointerType: 'mouse',\n\t\t\t\t\t\t\tisPrimary: true\n\t\t\t\t\t\t};\n\n\t\t\t\t\t\tconst mouseEventOptions = {\n\t\t\t\t\t\t\tbubbles: true,\n\t\t\t\t\t\t\tcancelable: true,\n\t\t\t\t\t\t\tview: window,\n\t\t\t\t\t\t\tbutton: buttonValue,\n\t\t\t\t\t\t\tbuttons: 1 << buttonValue,\n\t\t\t\t\t\t\tctrlKey: modifiers.includes('Control') || modifiers.includes('ControlOrMeta'),\n\t\t\t\t\t\t\tshiftKey: modifiers.includes('Shift'),\n\t\t\t\t\t\t\taltKey: modifiers.includes('Alt'),\n\t\t\t\t\t\t\tmetaKey: modifiers.includes('Meta') || modifiers.includes('ControlOrMeta'),\n\t\t\t\t\t\t\tclientX: cx,\n\t\t\t\t\t\t\tclientY: cy\n\t\t\t\t\t\t};\n\n\t\t\t\t\t\tconst previousActiveElement = document.activeElement;\n\t\t\t\t\t\tif (previousActiveElement && previousActiveElement !== element && previousActiveElement !== document.body) {\n\t\t\t\t\t\t\tif (typeof previousActiveElement.blur === 'function') {\n\t\t\t\t\t\t\t\tpreviousActiveElement.blur();\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif (typeof element.focus === 'function') {\n\t\t\t\t\t\t\telement.focus();\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tawait new Promise(r => setTimeout(r, 0));\n\n\t\t\t\t\t\telement.dispatchEvent(new PointerEvent('pointerover', pointerEventOptions));\n\t\t\t\t\t\telement.dispatchEvent(new PointerEvent('pointerenter', { ...pointerEventOptions, bubbles: false }));\n\t\t\t\t\t\telement.dispatchEvent(new MouseEvent('mouseover', mouseEventOptions));\n\t\t\t\t\t\telement.dispatchEvent(new MouseEvent('mouseenter', { ...mouseEventOptions, bubbles: false }));\n\n\t\t\t\t\t\telement.dispatchEvent(new PointerEvent('pointermove', pointerEventOptions));\n\t\t\t\t\t\telement.dispatchEvent(new MouseEvent('mousemove', mouseEventOptions));\n\n\t\t\t\t\t\telement.dispatchEvent(new PointerEvent('pointerdown', pointerEventOptions));\n\t\t\t\t\t\telement.dispatchEvent(new MouseEvent('mousedown', mouseEventOptions));\n\n\t\t\t\t\t\tif (typeof element.focus === 'function') {\n\t\t\t\t\t\t\telement.focus();\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif (holdDurationMs > 0) {\n\t\t\t\t\t\t\tawait new Promise(r => setTimeout(r, holdDurationMs));\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\telement.dispatchEvent(new PointerEvent('pointerup', pointerEventOptions));\n\t\t\t\t\t\telement.dispatchEvent(new MouseEvent('mouseup', mouseEventOptions));\n\t\t\t\t\t\telement.dispatchEvent(new MouseEvent('click', mouseEventOptions));\n\n\t\t\t\t\t\tif (${JSON.stringify(t.doubleClick)}) {\n\t\t\t\t\t\t\telement.dispatchEvent(new PointerEvent('pointerdown', pointerEventOptions));\n\t\t\t\t\t\t\telement.dispatchEvent(new MouseEvent('mousedown', mouseEventOptions));\n\t\t\t\t\t\t\telement.dispatchEvent(new PointerEvent('pointerup', pointerEventOptions));\n\t\t\t\t\t\t\telement.dispatchEvent(new MouseEvent('mouseup', mouseEventOptions));\n\t\t\t\t\t\t\telement.dispatchEvent(new MouseEvent('click', mouseEventOptions));\n\t\t\t\t\t\t\telement.dispatchEvent(new MouseEvent('dblclick', mouseEventOptions));\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tawait new Promise(r => setTimeout(r, 0));\n\n\t\t\t\t\t\tconst snapshotResult = buildPageSnapshot();\n\t\t\t\t\t\treturn {\n\t\t\t\t\t\t\tsuccess: true,\n\t\t\t\t\t\t\tdoubleClick: ${JSON.stringify(t.doubleClick)} || false,\n\t\t\t\t\t\t\tbutton: ${JSON.stringify(t.button)} || 'left',\n\t\t\t\t\t\t\toffsetUsed: offsetX !== null || offsetY !== null,\n\t\t\t\t\t\t\tholdDuration: holdDurationMs,\n\t\t\t\t\t\t\tpageState: {\n\t\t\t\t\t\t\t\turl: window.location.href,\n\t\t\t\t\t\t\t\ttitle: document.title,\n\t\t\t\t\t\t\t\tsnapshot: snapshotResult.tree\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t};\n\t\t\t\t\t})();\n\t\t\t\t`,a=(0,o.validateBrowserResult)(await(0,o.executeInBrowser)(i,e,t.headless),["pageState"]);if(!a.success&&a.hitTargetFailed){const n=["Error: Click target intercepted",""];a.error&&(n.push(a.error),n.push("")),a.interceptedBy&&(n.push(`Blocking element: ${a.interceptedBy}`),a.interceptedRef&&n.push(`Blocking element ref: ${a.interceptedRef}`),a.blockingType&&n.push(`Blocking type: ${a.blockingType}`),n.push("")),a.suggestion&&n.push(`Suggestion: ${a.suggestion}`);let r="browser_snapshot to see current element positions";"modal"===a.blockingType?r='browser_press_key with key "Escape" to close modal, or browser_snapshot to find close button':"offscreen"===a.blockingType||"scroll-container"===a.blockingType?r="browser_scroll with ref and scrollIntoView: true":"iframe"===a.blockingType?r="browser_navigate to iframe URL, or browser_snapshot to see alternative elements":a.interceptedRef&&(r=`browser_click with ref "${a.interceptedRef}" if that is the target, or browser_snapshot`),n.push("",`Recovery action: ${r}`),o.viewSnapshotTimestamps.set(e,Date.now());const s=await(0,o.formatPageStateResult)({action:"click (failed)",detailLines:n,pageState:a.pageState});return(0,o.maybeAddScreenshotToResult)(s,e,t.take_screenshot_afterwards??!1)}const l=[];l.push("- Click type: "+(a.doubleClick?"double-click":"single-click")),l.push(`- Button: ${a.button||"left"}`),a.offsetUsed&&l.push(`- Position: offset (${t.offsetX??"center"}, ${t.offsetY??"center"})`),a.holdDuration&&a.holdDuration>0&&l.push(`- Hold duration: ${a.holdDuration}ms`),o.viewSnapshotTimestamps.set(e,Date.now());const c=await(0,o.formatPageStateResult)({action:"click",detailLines:l,pageState:a.pageState});return(0,o.maybeAddScreenshotToResult)(c,e,t.take_screenshot_afterwards??!1)}catch(e){const n=(0,o.toAIFriendlyError)(e instanceof Error?e:new Error(String(e)),{ref:t.ref,action:"click"});return{content:[{type:"text",text:(0,o.formatAIFriendlyError)(n)}]}}},async hover(t){const e=await(0,o.resolveViewId)(t.viewId);if(!e)return{content:[{type:"text",text:"No browser tab available. Please navigate to a page first."}]};try{await(0,o.ensureCurrentPageAllowed)("browser_hover",e),await(0,o.ensureFreshSnapshot)(e,t.headless,r.BROWSER_UTILS);const n=(0,o.parseRef)(t.ref),s=t.element||"",i=`\n\t\t\t\t\t${o.ELEMENT_FINDER}\n\t\t\t\t\t${r.BROWSER_UTILS}\n\t\t\t\t\t(async function() {\n\t\t\t\t\t\tconst ref = ${JSON.stringify(n)};\n\t\t\t\t\t\tconst expectedDescription = ${JSON.stringify(s)};\n\t\t\t\t\t\tconst { element } = findElementByRef(ref);\n\t\t\t\t\t\tvalidateElementForInteraction(element, ref, 'hover', expectedDescription);\n\n\t\t\t\t\t\tconst rect = element.getBoundingClientRect();\n\t\t\t\t\t\tlet cx = Math.round(rect.left + rect.width / 2);\n\t\t\t\t\t\tlet cy = Math.round(rect.top + rect.height / 2);\n\n\t\t\t\t\t\tconst scrollPadding = 50;\n\t\t\t\t\t\tconst needsScroll = rect.top < scrollPadding || rect.left < scrollPadding ||\n\t\t\t\t\t\t\trect.bottom > window.innerHeight - scrollPadding || rect.right > window.innerWidth - scrollPadding;\n\t\t\t\t\t\tif (needsScroll) {\n\t\t\t\t\t\t\telement.scrollIntoView({ block: 'center', inline: 'center', behavior: 'smooth' });\n\t\t\t\t\t\t\tawait new Promise(r => setTimeout(r, 300));\n\t\t\t\t\t\t\tconst newRect = element.getBoundingClientRect();\n\t\t\t\t\t\t\tcx = Math.round(newRect.left + newRect.width / 2);\n\t\t\t\t\t\t\tcy = Math.round(newRect.top + newRect.height / 2);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tconst hitCheck = expectHitTarget({ x: cx, y: cy }, element, ref);\n\t\t\t\t\t\tif (!hitCheck.hit) {\n\t\t\t\t\t\t\treturn {\n\t\t\t\t\t\t\t\tsuccess: false,\n\t\t\t\t\t\t\t\thitTargetFailed: true,\n\t\t\t\t\t\t\t\terror: hitCheck.error || 'Hover would not reach the intended element.',\n\t\t\t\t\t\t\t\tinterceptedBy: hitCheck.interceptedBy,\n\t\t\t\t\t\t\t\tinterceptedRef: hitCheck.interceptedRef,\n\t\t\t\t\t\t\t\tsuggestion: hitCheck.suggestion,\n\t\t\t\t\t\t\t\ttargetRef: ref,\n\t\t\t\t\t\t\t\ttargetPreview: previewNode(element),\n\t\t\t\t\t\t\t\tpageState: {\n\t\t\t\t\t\t\t\t\turl: window.location.href,\n\t\t\t\t\t\t\t\t\ttitle: document.title,\n\t\t\t\t\t\t\t\t\tsnapshot: buildPageSnapshot().tree\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t};\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tconst eventOptions = {\n\t\t\t\t\t\t\tbubbles: true,\n\t\t\t\t\t\t\tcancelable: true,\n\t\t\t\t\t\t\tview: window,\n\t\t\t\t\t\t\tclientX: cx,\n\t\t\t\t\t\t\tclientY: cy,\n\t\t\t\t\t\t\tpointerId: 1,\n\t\t\t\t\t\t\tpointerType: 'mouse',\n\t\t\t\t\t\t\tisPrimary: true\n\t\t\t\t\t\t};\n\n\t\t\t\t\t\telement.dispatchEvent(new PointerEvent('pointerover', eventOptions));\n\t\t\t\t\t\telement.dispatchEvent(new PointerEvent('pointerenter', { ...eventOptions, bubbles: false }));\n\t\t\t\t\t\telement.dispatchEvent(new MouseEvent('mouseover', eventOptions));\n\t\t\t\t\t\telement.dispatchEvent(new MouseEvent('mouseenter', { ...eventOptions, bubbles: false }));\n\n\t\t\t\t\t\telement.dispatchEvent(new PointerEvent('pointermove', eventOptions));\n\t\t\t\t\t\telement.dispatchEvent(new MouseEvent('mousemove', eventOptions));\n\n\t\t\t\t\t\tawait new Promise(r => setTimeout(r, 0));\n\n\t\t\t\t\t\tconst snapshotResult = buildPageSnapshot();\n\t\t\t\t\t\treturn {\n\t\t\t\t\t\t\tsuccess: true,\n\t\t\t\t\t\t\tpageState: {\n\t\t\t\t\t\t\t\turl: window.location.href,\n\t\t\t\t\t\t\t\ttitle: document.title,\n\t\t\t\t\t\t\t\tsnapshot: snapshotResult.tree\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t};\n\t\t\t\t\t})();\n\t\t\t\t`,a=(0,o.validateBrowserResult)(await(0,o.executeInBrowser)(i,e,t.headless),["pageState"]);if(!a.success&&a.hitTargetFailed){const n=["Error: Hover target intercepted","",a.error||"Hover would not reach the intended element.",""];a.suggestion&&n.push(`Suggestion: ${a.suggestion}`),n.push("","Recovery action: Take a snapshot to see current element positions, or interact with the intercepting element directly."),o.viewSnapshotTimestamps.set(e,Date.now());const r=await(0,o.formatPageStateResult)({action:"hover (failed)",detailLines:n,pageState:a.pageState});return(0,o.maybeAddScreenshotToResult)(r,e,t.take_screenshot_afterwards??!1)}o.viewSnapshotTimestamps.set(e,Date.now());const l=await(0,o.formatPageStateResult)({action:"hover",detailLines:[`- Hovered over element: ${n}`],pageState:a.pageState});return(0,o.maybeAddScreenshotToResult)(l,e,t.take_screenshot_afterwards??!1)}catch(e){const n=(0,o.toAIFriendlyError)(e instanceof Error?e:new Error(String(e)),{ref:t.ref,action:"hover"});return{content:[{type:"text",text:(0,o.formatAIFriendlyError)(n)}]}}},async drag(t){const e=await(0,o.resolveViewId)(t.viewId);if(!e)return{content:[{type:"text",text:"No browser tab available. Please navigate to a page first."}]};try{await(0,o.ensureCurrentPageAllowed)("browser_drag",e),await(0,o.ensureFreshSnapshot)(e,t.headless,r.BROWSER_UTILS);const n=(0,o.parseRef)(t.sourceRef),s=t.targetRef?(0,o.parseRef)(t.targetRef):void 0;if(!s&&(void 0===t.targetX||void 0===t.targetY))return{content:[{type:"text",text:"Error: Either targetRef or both targetX and targetY must be provided for drag operation.\n\nSuggestion: Specify where to drop the element using targetRef (for element-to-element drag) or targetX/targetY coordinates."}]};const i=`\n\t\t\t\t\t(async function() {\n\t\t\t\t\t\t${o.ELEMENT_FINDER}\n\n\t\t\t\t\t\tconst sourceRef = ${JSON.stringify(n)};\n\t\t\t\t\t\tconst targetRef = ${JSON.stringify(s)};\n\t\t\t\t\t\tconst targetX = ${t.targetX??"null"};\n\t\t\t\t\t\tconst targetY = ${t.targetY??"null"};\n\n\t\t\t\t\t\tconst { element: sourceElement } = findElementByRef(sourceRef);\n\t\t\t\t\t\tif (!sourceElement) {\n\t\t\t\t\t\t\treturn {\n\t\t\t\t\t\t\t\tsuccess: false,\n\t\t\t\t\t\t\t\terror: 'Source element not found: ' + sourceRef + '. Take a snapshot to get updated refs.',\n\t\t\t\t\t\t\t\tsuggestion: 'The source element reference may be stale. Take a new snapshot to get current element refs.'\n\t\t\t\t\t\t\t};\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tconst sourceStyle = window.getComputedStyle(sourceElement);\n\t\t\t\t\t\tconst isDraggable = sourceElement.draggable || sourceElement.getAttribute('draggable') === 'true';\n\t\t\t\t\t\tif (!isDraggable && sourceStyle.cursor !== 'grab' && sourceStyle.cursor !== 'move') {\n\t\t\t\t\t\t\treturn {\n\t\t\t\t\t\t\t\tsuccess: false,\n\t\t\t\t\t\t\t\terror: 'Source element ' + sourceRef + ' does not appear to be draggable. It lacks the draggable attribute.',\n\t\t\t\t\t\t\t\tsuggestion: 'Verify the element is meant to be dragged. Check if it has draggable="true" attribute or is part of a drag-and-drop library that uses different mechanisms.'\n\t\t\t\t\t\t\t};\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tlet targetElement = null;\n\t\t\t\t\t\tif (targetRef) {\n\t\t\t\t\t\t\tconst targetResult = findElementByRef(targetRef);\n\t\t\t\t\t\t\ttargetElement = targetResult.element;\n\t\t\t\t\t\t\tif (!targetElement) {\n\t\t\t\t\t\t\t\treturn {\n\t\t\t\t\t\t\t\t\tsuccess: false,\n\t\t\t\t\t\t\t\t\terror: 'Target element not found: ' + targetRef + '. Take a snapshot to get updated refs.',\n\t\t\t\t\t\t\t\t\tsuggestion: 'The target element reference may be stale. Take a new snapshot to get current element refs.'\n\t\t\t\t\t\t\t\t};\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tconst sourceRect = sourceElement.getBoundingClientRect();\n\t\t\t\t\t\tconst startX = Math.round(sourceRect.left + sourceRect.width / 2);\n\t\t\t\t\t\tconst startY = Math.round(sourceRect.top + sourceRect.height / 2);\n\n\t\t\t\t\t\tlet dropX, dropY;\n\t\t\t\t\t\tif (targetElement) {\n\t\t\t\t\t\t\tconst targetRect = targetElement.getBoundingClientRect();\n\t\t\t\t\t\t\tdropX = Math.round(targetRect.left + targetRect.width / 2);\n\t\t\t\t\t\t\tdropY = Math.round(targetRect.top + targetRect.height / 2);\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tdropX = targetX;\n\t\t\t\t\t\t\tdropY = targetY;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\tconst dataTransfer = new DataTransfer();\n\t\t\t\t\t\t\tdataTransfer.effectAllowed = 'all';\n\n\t\t\t\t\t\t\tconst pointerOpts = {\n\t\t\t\t\t\t\t\tbubbles: true,\n\t\t\t\t\t\t\t\tcancelable: true,\n\t\t\t\t\t\t\t\tview: window,\n\t\t\t\t\t\t\t\tpointerId: 1,\n\t\t\t\t\t\t\t\tpointerType: 'mouse',\n\t\t\t\t\t\t\t\tisPrimary: true,\n\t\t\t\t\t\t\t\tbutton: 0,\n\t\t\t\t\t\t\t\tbuttons: 1\n\t\t\t\t\t\t\t};\n\n\t\t\t\t\t\t\tsourceElement.dispatchEvent(new PointerEvent('pointerover', { ...pointerOpts, clientX: startX, clientY: startY }));\n\t\t\t\t\t\t\tsourceElement.dispatchEvent(new PointerEvent('pointerenter', { ...pointerOpts, clientX: startX, clientY: startY, bubbles: false }));\n\t\t\t\t\t\t\tsourceElement.dispatchEvent(new MouseEvent('mouseover', { bubbles: true, clientX: startX, clientY: startY }));\n\t\t\t\t\t\t\tsourceElement.dispatchEvent(new MouseEvent('mouseenter', { bubbles: false, clientX: startX, clientY: startY }));\n\n\t\t\t\t\t\t\tsourceElement.dispatchEvent(new PointerEvent('pointerdown', { ...pointerOpts, clientX: startX, clientY: startY }));\n\t\t\t\t\t\t\tsourceElement.dispatchEvent(new MouseEvent('mousedown', { bubbles: true, cancelable: true, clientX: startX, clientY: startY, button: 0 }));\n\n\t\t\t\t\t\t\tawait new Promise(r => setTimeout(r, 50));\n\n\t\t\t\t\t\t\tconst dragStartEvent = new DragEvent('dragstart', {\n\t\t\t\t\t\t\t\tbubbles: true,\n\t\t\t\t\t\t\t\tcancelable: true,\n\t\t\t\t\t\t\t\tclientX: startX,\n\t\t\t\t\t\t\t\tclientY: startY,\n\t\t\t\t\t\t\t\tdataTransfer: dataTransfer\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\tconst dragStarted = sourceElement.dispatchEvent(dragStartEvent);\n\n\t\t\t\t\t\t\tif (!dragStarted) {\n\t\t\t\t\t\t\t\treturn {\n\t\t\t\t\t\t\t\t\tsuccess: false,\n\t\t\t\t\t\t\t\t\terror: 'Drag start was prevented by the page.',\n\t\t\t\t\t\t\t\t\tsuggestion: 'The page may have event handlers preventing drag. Try using browser_evaluate to trigger the drag programmatically.'\n\t\t\t\t\t\t\t\t};\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tsourceElement.dispatchEvent(new DragEvent('drag', {\n\t\t\t\t\t\t\t\tbubbles: true,\n\t\t\t\t\t\t\t\tcancelable: true,\n\t\t\t\t\t\t\t\tclientX: startX,\n\t\t\t\t\t\t\t\tclientY: startY,\n\t\t\t\t\t\t\t\tdataTransfer: dataTransfer\n\t\t\t\t\t\t\t}));\n\n\t\t\t\t\t\t\tawait new Promise(r => setTimeout(r, 50));\n\n\t\t\t\t\t\t\tconst dropTarget = targetElement || document.elementFromPoint(dropX, dropY);\n\t\t\t\t\t\t\tif (!dropTarget) {\n\t\t\t\t\t\t\t\treturn {\n\t\t\t\t\t\t\t\t\tsuccess: false,\n\t\t\t\t\t\t\t\t\terror: 'No element found at drop coordinates (' + dropX + ', ' + dropY + ').',\n\t\t\t\t\t\t\t\t\tsuggestion: 'Verify the target coordinates are within the viewport and point to a valid drop zone.'\n\t\t\t\t\t\t\t\t};\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tdropTarget.dispatchEvent(new DragEvent('dragenter', {\n\t\t\t\t\t\t\t\tbubbles: true,\n\t\t\t\t\t\t\t\tcancelable: true,\n\t\t\t\t\t\t\t\tclientX: dropX,\n\t\t\t\t\t\t\t\tclientY: dropY,\n\t\t\t\t\t\t\t\tdataTransfer: dataTransfer\n\t\t\t\t\t\t\t}));\n\n\t\t\t\t\t\t\tconst dragOverEvent = new DragEvent('dragover', {\n\t\t\t\t\t\t\t\tbubbles: true,\n\t\t\t\t\t\t\t\tcancelable: true,\n\t\t\t\t\t\t\t\tclientX: dropX,\n\t\t\t\t\t\t\t\tclientY: dropY,\n\t\t\t\t\t\t\t\tdataTransfer: dataTransfer\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\tdropTarget.dispatchEvent(dragOverEvent);\n\n\t\t\t\t\t\t\tawait new Promise(r => setTimeout(r, 50));\n\n\t\t\t\t\t\t\tconst dropEvent = new DragEvent('drop', {\n\t\t\t\t\t\t\t\tbubbles: true,\n\t\t\t\t\t\t\t\tcancelable: true,\n\t\t\t\t\t\t\t\tclientX: dropX,\n\t\t\t\t\t\t\t\tclientY: dropY,\n\t\t\t\t\t\t\t\tdataTransfer: dataTransfer\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\tconst dropAccepted = dropTarget.dispatchEvent(dropEvent);\n\n\t\t\t\t\t\t\tsourceElement.dispatchEvent(new DragEvent('dragend', {\n\t\t\t\t\t\t\t\tbubbles: true,\n\t\t\t\t\t\t\t\tcancelable: false,\n\t\t\t\t\t\t\t\tclientX: dropX,\n\t\t\t\t\t\t\t\tclientY: dropY,\n\t\t\t\t\t\t\t\tdataTransfer: dataTransfer\n\t\t\t\t\t\t\t}));\n\n\t\t\t\t\t\t\tsourceElement.dispatchEvent(new PointerEvent('pointerup', { ...pointerOpts, clientX: dropX, clientY: dropY }));\n\t\t\t\t\t\t\tsourceElement.dispatchEvent(new MouseEvent('mouseup', { bubbles: true, clientX: dropX, clientY: dropY }));\n\n\t\t\t\t\t\t\treturn {\n\t\t\t\t\t\t\t\tsuccess: true,\n\t\t\t\t\t\t\t\taction: 'drag',\n\t\t\t\t\t\t\t\tsource: sourceRef,\n\t\t\t\t\t\t\t\ttarget: targetRef || ('(' + dropX + ', ' + dropY + ')'),\n\t\t\t\t\t\t\t\tdropAccepted: dropAccepted,\n\t\t\t\t\t\t\t\tmessage: 'Drag completed from ' + sourceRef + ' to ' + (targetRef || 'coordinates (' + dropX + ', ' + dropY + ')') + (dropAccepted ? '' : ' (drop may not have been accepted by target)')\n\t\t\t\t\t\t\t};\n\t\t\t\t\t\t} catch (err) {\n\t\t\t\t\t\t\treturn {\n\t\t\t\t\t\t\t\tsuccess: false,\n\t\t\t\t\t\t\t\terror: 'Drag operation failed: ' + (err instanceof Error ? err.message : String(err)),\n\t\t\t\t\t\t\t\tsuggestion: 'The drag-and-drop may use a library (like react-dnd or sortablejs) that requires specific event sequences. Try using browser_evaluate to interact with the library directly.'\n\t\t\t\t\t\t\t};\n\t\t\t\t\t\t}\n\t\t\t\t\t})();\n\t\t\t\t`,a=(0,o.validateBrowserResult)(await(0,o.executeInBrowser)(i,e,t.headless),[]);if(!a.success){return{content:[{type:"text",text:`Error: ${a.error||"Unknown drag error"}\n\nSuggestion: ${a.suggestion||"Take a snapshot to verify the elements are draggable."}\n\nRecovery action: browser_snapshot`}]}}const l={content:[{type:"text",text:`### Action: drag\n- ${a.message}\n- Source: ${a.source}\n- Target: ${a.target}`},{type:"metadata",viewId:e}]};return(0,o.maybeAddScreenshotToResult)(l,e,t.take_screenshot_afterwards??!1)}catch(e){const n=(0,o.toAIFriendlyError)(e instanceof Error?e:new Error(String(e)),{ref:t.sourceRef,action:"drag"});return{content:[{type:"text",text:(0,o.formatAIFriendlyError)(n)}]}}}}};const r=n(8),o=n(376)},696:(t,e,n)=>{Object.defineProperty(e,"__esModule",{value:!0}),e.createWaitTools=function(t){return{async waitFor(t){const e=await(0,r.resolveViewId)(t.viewId);if(!e)return{content:[{type:"text",text:"No browser tab available. Please navigate to a page first."}]};if(await(0,r.ensureCurrentPageAllowed)("browser_wait_for",e),void 0!==t.time){await new Promise(e=>setTimeout(e,1e3*t.time));const n={content:[{type:"text",text:`Successfully waited for: ${t.time} seconds`},{type:"metadata",viewId:e}]};return(0,r.maybeAddScreenshotToResult)(n,e,t.take_screenshot_afterwards??!1)}const n=t.timeout??3e4;if(t.selector||t.ref){const o=t.ref?(0,r.parseRef)(t.ref):null,s=`\n\t\t\t\t\t${r.ELEMENT_FINDER}\n\t\t\t\t\t(function() {\n\t\t\t\t\t\tconst selector = ${JSON.stringify(t.selector)};\n\t\t\t\t\t\tconst ref = ${JSON.stringify(o)};\n\t\t\t\t\t\tconst state = ${JSON.stringify(t.state||"visible")};\n\t\t\t\t\t\tconst timeout = ${n};\n\t\t\t\t\t\tconst startTime = Date.now();\n\n\t\t\t\t\t\tfunction checkElementState() {\n\t\t\t\t\t\t\tlet element = null;\n\n\t\t\t\t\t\t\tif (ref) {\n\t\t\t\t\t\t\t\telement = document.querySelector('[data-cursor-ref="' + ref + '"]');\n\t\t\t\t\t\t\t} else if (selector) {\n\t\t\t\t\t\t\t\telement = document.querySelector(selector);\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tconst isAttached = element !== null;\n\n\t\t\t\t\t\t\tif (!isAttached) {\n\t\t\t\t\t\t\t\treturn {\n\t\t\t\t\t\t\t\t\tattached: false,\n\t\t\t\t\t\t\t\t\tvisible: false,\n\t\t\t\t\t\t\t\t\thidden: true,\n\t\t\t\t\t\t\t\t\tdetached: true\n\t\t\t\t\t\t\t\t};\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tconst rect = element.getBoundingClientRect();\n\t\t\t\t\t\t\tconst style = window.getComputedStyle(element);\n\t\t\t\t\t\t\tconst isVisible =\n\t\t\t\t\t\t\t\trect.width > 0 &&\n\t\t\t\t\t\t\t\trect.height > 0 &&\n\t\t\t\t\t\t\t\tstyle.display !== 'none' &&\n\t\t\t\t\t\t\t\tstyle.visibility !== 'hidden' &&\n\t\t\t\t\t\t\t\tstyle.opacity !== '0';\n\n\t\t\t\t\t\t\treturn {\n\t\t\t\t\t\t\t\tattached: true,\n\t\t\t\t\t\t\t\tvisible: isVisible,\n\t\t\t\t\t\t\t\thidden: !isVisible,\n\t\t\t\t\t\t\t\tdetached: false,\n\t\t\t\t\t\t\t\telement: element\n\t\t\t\t\t\t\t};\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn new Promise((resolve) => {\n\t\t\t\t\t\t\tlet observer = null;\n\t\t\t\t\t\t\tlet timeoutId = null;\n\n\t\t\t\t\t\t\tfunction cleanup() {\n\t\t\t\t\t\t\t\tif (observer) {\n\t\t\t\t\t\t\t\t\tobserver.disconnect();\n\t\t\t\t\t\t\t\t\tobserver = null;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\tif (timeoutId) {\n\t\t\t\t\t\t\t\t\tclearTimeout(timeoutId);\n\t\t\t\t\t\t\t\t\ttimeoutId = null;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tfunction checkCondition() {\n\t\t\t\t\t\t\t\tconst elementState = checkElementState();\n\t\t\t\t\t\t\t\tconst conditionMet = elementState[state];\n\n\t\t\t\t\t\t\t\tif (conditionMet) {\n\t\t\t\t\t\t\t\t\tcleanup();\n\t\t\t\t\t\t\t\t\tresolve({\n\t\t\t\t\t\t\t\t\t\tsuccess: true,\n\t\t\t\t\t\t\t\t\t\twaitType: 'element',\n\t\t\t\t\t\t\t\t\t\tstate: state,\n\t\t\t\t\t\t\t\t\t\tselector: selector || ref,\n\t\t\t\t\t\t\t\t\t\telapsed: Date.now() - startTime\n\t\t\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\t\t\treturn true;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tif (checkCondition()) return;\n\n\t\t\t\t\t\t\tobserver = new MutationObserver(() => {\n\t\t\t\t\t\t\t\tcheckCondition();\n\t\t\t\t\t\t\t});\n\n\t\t\t\t\t\t\tobserver.observe(document.body, {\n\t\t\t\t\t\t\t\tchildList: true,\n\t\t\t\t\t\t\t\tsubtree: true,\n\t\t\t\t\t\t\t\tattributes: true,\n\t\t\t\t\t\t\t\tattributeFilter: ['style', 'class', 'hidden', 'aria-hidden', 'data-cursor-ref']\n\t\t\t\t\t\t\t});\n\n\t\t\t\t\t\t\tconst pollInterval = setInterval(() => {\n\t\t\t\t\t\t\t\tif (checkCondition()) {\n\t\t\t\t\t\t\t\t\tclearInterval(pollInterval);\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}, 250);\n\n\t\t\t\t\t\t\ttimeoutId = setTimeout(() => {\n\t\t\t\t\t\t\t\tcleanup();\n\t\t\t\t\t\t\t\tclearInterval(pollInterval);\n\t\t\t\t\t\t\t\tconst currentState = checkElementState();\n\t\t\t\t\t\t\t\tresolve({\n\t\t\t\t\t\t\t\t\tsuccess: false,\n\t\t\t\t\t\t\t\t\twaitType: 'element',\n\t\t\t\t\t\t\t\t\tstate: state,\n\t\t\t\t\t\t\t\t\tselector: selector || ref,\n\t\t\t\t\t\t\t\t\terror: 'Timeout waiting for element to be ' + state,\n\t\t\t\t\t\t\t\t\tcurrentState: {\n\t\t\t\t\t\t\t\t\t\tattached: currentState.attached,\n\t\t\t\t\t\t\t\t\t\tvisible: currentState.visible\n\t\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\telapsed: Date.now() - startTime\n\t\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\t}, timeout);\n\t\t\t\t\t\t});\n\t\t\t\t\t})();\n\t\t\t\t`,i=(0,r.validateBrowserResult)(await(0,r.executeInBrowser)(s,e,t.headless),["waitType","state","selector","elapsed"]);if(!i.success){const t=i.currentState?` (currently: attached=${i.currentState.attached}, visible=${i.currentState.visible})`:"";return{content:[{type:"text",text:`Error: ${i.error}${t}\n\nSuggestion: The element may not exist yet or may have different visibility. Take a snapshot to see the current page state.\n\nRecovery action: browser_snapshot`}]}}const a={content:[{type:"text",text:`Successfully waited for element ${i.selector} to be ${i.state} (${i.elapsed}ms)`},{type:"metadata",viewId:e}]};return(0,r.maybeAddScreenshotToResult)(a,e,t.take_screenshot_afterwards??!1)}const o=`\n\t\t\t\t(function() {\n\t\t\t\t\tconst targetText = ${JSON.stringify(t.text||t.textGone)};\n\t\t\t\t\tconst waitForDisappear = ${JSON.stringify(!!t.textGone)};\n\t\t\t\t\tconst timeout = ${n};\n\t\t\t\t\tconst startTime = Date.now();\n\n\t\t\t\t\treturn new Promise((resolve) => {\n\t\t\t\t\t\tlet observer = null;\n\t\t\t\t\t\tlet timeoutId = null;\n\n\t\t\t\t\t\tfunction cleanup() {\n\t\t\t\t\t\t\tif (observer) {\n\t\t\t\t\t\t\t\tobserver.disconnect();\n\t\t\t\t\t\t\t\tobserver = null;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tif (timeoutId) {\n\t\t\t\t\t\t\t\tclearTimeout(timeoutId);\n\t\t\t\t\t\t\t\ttimeoutId = null;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tfunction checkCondition() {\n\t\t\t\t\t\t\tconst bodyText = document.body.innerText || document.body.textContent || '';\n\t\t\t\t\t\t\tconst found = bodyText.includes(targetText);\n\t\t\t\t\t\t\tconst conditionMet = waitForDisappear ? !found : found;\n\n\t\t\t\t\t\t\tif (conditionMet) {\n\t\t\t\t\t\t\t\tcleanup();\n\t\t\t\t\t\t\t\tresolve({\n\t\t\t\t\t\t\t\t\tsuccess: true,\n\t\t\t\t\t\t\t\t\twaitType: 'text',\n\t\t\t\t\t\t\t\t\ttype: waitForDisappear ? 'text_gone' : 'text_appear',\n\t\t\t\t\t\t\t\t\ttext: targetText,\n\t\t\t\t\t\t\t\t\telapsed: Date.now() - startTime\n\t\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\t\treturn true;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif (checkCondition()) return;\n\n\t\t\t\t\t\tobserver = new MutationObserver(() => {\n\t\t\t\t\t\t\tcheckCondition();\n\t\t\t\t\t\t});\n\n\t\t\t\t\t\tobserver.observe(document.body, {\n\t\t\t\t\t\t\tchildList: true,\n\t\t\t\t\t\t\tsubtree: true,\n\t\t\t\t\t\t\tcharacterData: true\n\t\t\t\t\t\t});\n\n\t\t\t\t\t\tconst pollInterval = setInterval(() => {\n\t\t\t\t\t\t\tif (checkCondition()) {\n\t\t\t\t\t\t\t\tclearInterval(pollInterval);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}, 250);\n\n\t\t\t\t\t\ttimeoutId = setTimeout(() => {\n\t\t\t\t\t\t\tcleanup();\n\t\t\t\t\t\t\tclearInterval(pollInterval);\n\t\t\t\t\t\t\tresolve({\n\t\t\t\t\t\t\t\tsuccess: false,\n\t\t\t\t\t\t\t\twaitType: 'text',\n\t\t\t\t\t\t\t\terror: 'Timeout waiting for text',\n\t\t\t\t\t\t\t\ttype: waitForDisappear ? 'text_gone' : 'text_appear',\n\t\t\t\t\t\t\t\ttext: targetText,\n\t\t\t\t\t\t\t\telapsed: Date.now() - startTime\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t}, timeout);\n\t\t\t\t\t});\n\t\t\t\t})();\n\t\t\t`,s=(0,r.validateBrowserResult)(await(0,r.executeInBrowser)(o,e,t.headless),["waitType","type","text","elapsed"]);if(!s.success)return{content:[{type:"text",text:`Error: ${s.error}\n\nThe text "${s.text}" ${"text_gone"===s.type?"is still present":"was not found"} after ${s.elapsed}ms.\n\nSuggestion: Take a snapshot to see the current page content.\n\nRecovery action: browser_snapshot`}]};const i={content:[{type:"text",text:`Successfully waited for text ${"text_gone"===s.type?"to disappear":"to appear"}: "${s.text}" (${s.elapsed}ms)`},{type:"metadata",viewId:e}]};return(0,r.maybeAddScreenshotToResult)(i,e,t.take_screenshot_afterwards??!1)}}};const r=n(376)},709:(t,e,n)=>{Object.defineProperty(e,"__esModule",{value:!0}),e.createInputTools=function(t){return{async type(t){const e=await(0,o.resolveViewId)(t.viewId);if(!e)return{content:[{type:"text",text:"No browser tab available. Please navigate to a page first."}]};try{await(0,o.ensureCurrentPageAllowed)("browser_type",e),await(0,o.ensureFreshSnapshot)(e,t.headless,r.BROWSER_UTILS);const n=(0,o.parseRef)(t.ref),s=t.element||"",i=`\n\t\t\t\t\t${o.ELEMENT_FINDER}\n\t\t\t\t\t${r.BROWSER_UTILS}\n\t\t\t\t\t(async function() {\n\t\t\t\t\t\tconst ref = ${JSON.stringify(n)};\n\t\t\t\t\t\tconst expectedDescription = ${JSON.stringify(s)};\n\t\t\t\t\t\tconst { element } = findElementByRef(ref);\n\t\t\t\t\t\tvalidateElementForInteraction(element, ref, 'type', expectedDescription);\n\n\t\t\t\t\t\tconst rect = element.getBoundingClientRect();\n\t\t\t\t\t\tconst scrollPadding = 50;\n\t\t\t\t\t\tconst needsScroll = rect.top < scrollPadding || rect.left < scrollPadding ||\n\t\t\t\t\t\t\trect.bottom > window.innerHeight - scrollPadding || rect.right > window.innerWidth - scrollPadding;\n\t\t\t\t\t\tif (needsScroll) {\n\t\t\t\t\t\t\telement.scrollIntoView({ block: 'center', inline: 'center', behavior: 'smooth' });\n\t\t\t\t\t\t\tawait new Promise(r => setTimeout(r, 300));\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tconst tagName = element.tagName.toUpperCase();\n\t\t\t\t\t\tconst isContentEditable = element.isContentEditable;\n\n\t\t\t\t\t\tconst valueBefore = isContentEditable ? element.textContent : element.value;\n\n\t\t\t\t\t\tconst previousActiveElement = document.activeElement;\n\t\t\t\t\t\tif (previousActiveElement && previousActiveElement !== element && previousActiveElement !== document.body) {\n\t\t\t\t\t\t\tif (typeof previousActiveElement.blur === 'function') {\n\t\t\t\t\t\t\t\tpreviousActiveElement.blur();\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\telement.focus();\n\n\t\t\t\t\t\tawait new Promise(r => setTimeout(r, 0));\n\n\t\t\t\t\t\tif (document.activeElement !== element) {\n\t\t\t\t\t\t\telement.click();\n\t\t\t\t\t\t\telement.focus();\n\t\t\t\t\t\t\tawait new Promise(r => setTimeout(r, 0));\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif (document.activeElement !== element) {\n\t\t\t\t\t\t\tconst elementTag = element.tagName?.toLowerCase() || 'element';\n\t\t\t\t\t\t\tconst focusBlockers = [];\n\n\t\t\t\t\t\t\tconst style = window.getComputedStyle(element);\n\t\t\t\t\t\t\tif (element.tabIndex < 0) focusBlockers.push('negative tabindex');\n\t\t\t\t\t\t\tif (style.display === 'none') focusBlockers.push('display: none');\n\t\t\t\t\t\t\tif (style.visibility === 'hidden') focusBlockers.push('visibility: hidden');\n\t\t\t\t\t\t\tif (element.disabled) focusBlockers.push('disabled attribute');\n\n\t\t\t\t\t\t\tconst hitCheck = document.elementFromPoint(\n\t\t\t\t\t\t\t\trect.left + rect.width / 2,\n\t\t\t\t\t\t\t\trect.top + rect.height / 2\n\t\t\t\t\t\t\t);\n\t\t\t\t\t\t\tif (hitCheck && hitCheck !== element && !element.contains(hitCheck)) {\n\t\t\t\t\t\t\t\tconst hitPreview = hitCheck.tagName?.toLowerCase() + (hitCheck.getAttribute('data-cursor-ref') ? ' (ref: ' + hitCheck.getAttribute('data-cursor-ref') + ')' : '');\n\t\t\t\t\t\t\t\tfocusBlockers.push('another element at position: ' + hitPreview);\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tconst reason = focusBlockers.length > 0\n\t\t\t\t\t\t\t\t? ' Possible reasons: ' + focusBlockers.join(', ') + '.'\n\t\t\t\t\t\t\t\t: ' The element may not be focusable, or another element may be intercepting focus.';\n\t\t\t\t\t\t\tthrow new Error('Failed to focus ' + elementTag + ' ' + ref + '.' + reason + ' Try taking a fresh snapshot to verify the element state.');\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tconst text = ${JSON.stringify(t.text)};\n\t\t\t\t\t\tconst clearFirst = ${JSON.stringify(t.clear)} || false;\n\t\t\t\t\t\tconst slowly = ${JSON.stringify(t.slowly)} || false;\n\t\t\t\t\t\tconst submit = ${JSON.stringify(t.submit)} || false;\n\n\t\t\t\t\t\tfunction setNativeValue(el, value) {\n\t\t\t\t\t\t\tconst elTagName = el.tagName.toUpperCase();\n\t\t\t\t\t\t\tlet valueSetter = null;\n\n\t\t\t\t\t\t\tif (elTagName === 'INPUT') {\n\t\t\t\t\t\t\t\tvalueSetter = Object.getOwnPropertyDescriptor(window.HTMLInputElement.prototype, 'value')?.set;\n\t\t\t\t\t\t\t} else if (elTagName === 'TEXTAREA') {\n\t\t\t\t\t\t\t\tvalueSetter = Object.getOwnPropertyDescriptor(window.HTMLTextAreaElement.prototype, 'value')?.set;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tif (valueSetter) {\n\t\t\t\t\t\t\t\tvalueSetter.call(el, value);\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\tel.value = value;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tfunction dispatchInputEvent(el) {\n\t\t\t\t\t\t\tconst inputEvent = new InputEvent('input', { bubbles: true, cancelable: true, inputType: 'insertText', data: text });\n\t\t\t\t\t\t\tel.dispatchEvent(inputEvent);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif (clearFirst) {\n\t\t\t\t\t\t\tif (isContentEditable) {\n\t\t\t\t\t\t\t\telement.textContent = '';\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\tsetNativeValue(element, '');\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telement.dispatchEvent(new Event('input', { bubbles: true }));\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif (slowly) {\n\t\t\t\t\t\t\tconst delay = 50;\n\t\t\t\t\t\t\tconst existingValue = clearFirst ? '' : (isContentEditable ? (element.textContent || '') : (element.value || ''));\n\t\t\t\t\t\t\tfor (let i = 0; i < text.length; i++) {\n\t\t\t\t\t\t\t\tconst char = text[i];\n\t\t\t\t\t\t\t\tif (isContentEditable) {\n\t\t\t\t\t\t\t\t\tconst selection = window.getSelection();\n\t\t\t\t\t\t\t\t\tconst range = document.createRange();\n\t\t\t\t\t\t\t\t\trange.selectNodeContents(element);\n\t\t\t\t\t\t\t\t\trange.collapse(false);\n\t\t\t\t\t\t\t\t\tselection.removeAllRanges();\n\t\t\t\t\t\t\t\t\tselection.addRange(range);\n\t\t\t\t\t\t\t\t\tdocument.execCommand('insertText', false, char);\n\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\tsetNativeValue(element, existingValue + text.substring(0, i + 1));\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\telement.dispatchEvent(new KeyboardEvent('keydown', { key: char, bubbles: true, cancelable: true }));\n\t\t\t\t\t\t\t\tdispatchInputEvent(element);\n\t\t\t\t\t\t\t\telement.dispatchEvent(new KeyboardEvent('keyup', { key: char, bubbles: true, cancelable: true }));\n\t\t\t\t\t\t\t\tawait new Promise(r => setTimeout(r, delay));\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tif (isContentEditable) {\n\t\t\t\t\t\t\t\tconst existingContent = clearFirst ? '' : (element.textContent || '');\n\t\t\t\t\t\t\t\telement.textContent = existingContent + text;\n\t\t\t\t\t\t\t\telement.dispatchEvent(new Event('input', { bubbles: true }));\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\tconst existingValue = clearFirst ? '' : (element.value || '');\n\t\t\t\t\t\t\t\tsetNativeValue(element, existingValue + text);\n\t\t\t\t\t\t\t\tdispatchInputEvent(element);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\telement.dispatchEvent(new Event('change', { bubbles: true }));\n\n\t\t\t\t\t\tif (submit) {\n\t\t\t\t\t\t\telement.dispatchEvent(new KeyboardEvent('keydown', { key: 'Enter', keyCode: 13, code: 'Enter', which: 13, bubbles: true, cancelable: true }));\n\t\t\t\t\t\t\telement.dispatchEvent(new KeyboardEvent('keypress', { key: 'Enter', keyCode: 13, code: 'Enter', which: 13, bubbles: true, cancelable: true }));\n\t\t\t\t\t\t\telement.dispatchEvent(new KeyboardEvent('keyup', { key: 'Enter', keyCode: 13, code: 'Enter', which: 13, bubbles: true, cancelable: true }));\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tconst valueAfter = isContentEditable ? element.textContent : element.value;\n\t\t\t\t\t\tconst valueChanged = valueBefore !== valueAfter;\n\t\t\t\t\t\tconst valueMatchesExpected = isContentEditable\n\t\t\t\t\t\t\t? (element.textContent || '').includes(text)\n\t\t\t\t\t\t\t: element.value === text || element.value.endsWith(text);\n\n\t\t\t\t\t\tconst maxLength = element.maxLength;\n\t\t\t\t\t\tconst hasMaxLength = maxLength > 0 && maxLength !== 2147483647;\n\t\t\t\t\t\tconst exceedsMaxLength = hasMaxLength && (valueAfter?.length || 0) > maxLength;\n\n\t\t\t\t\t\tconst snapshotResult = buildPageSnapshot();\n\t\t\t\t\t\treturn {\n\t\t\t\t\t\t\tsuccess: true,\n\t\t\t\t\t\t\tslowly,\n\t\t\t\t\t\t\tsubmitted: submit,\n\t\t\t\t\t\t\ttextLength: text.length,\n\t\t\t\t\t\t\tvalueChanged,\n\t\t\t\t\t\t\tvalueMatchesExpected,\n\t\t\t\t\t\t\tactualValue: valueAfter ? String(valueAfter).substring(0, 100) : '',\n\t\t\t\t\t\t\tmaxLength: hasMaxLength ? maxLength : null,\n\t\t\t\t\t\t\texceedsMaxLength,\n\t\t\t\t\t\t\tpageState: {\n\t\t\t\t\t\t\t\turl: window.location.href,\n\t\t\t\t\t\t\t\ttitle: document.title,\n\t\t\t\t\t\t\t\tsnapshot: snapshotResult.tree\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t};\n\t\t\t\t\t})();\n\t\t\t\t`,a=await(0,o.executeInBrowser)(i,e,t.headless),l=[];l.push(`- Characters typed: ${a.textLength}`),l.push("- Typing mode: "+(a.slowly?"slow (character-by-character)":"fast")),t.clear&&l.push("- Cleared existing content: yes"),a.submitted&&l.push("- Form submitted: yes (Enter key pressed)"),a.valueChanged||l.push("- WARNING: Value did not change after typing"),!a.valueMatchesExpected&&a.valueChanged&&l.push(`- Note: Final value differs from input (actual: "${a.actualValue}")`),a.exceedsMaxLength&&null!==a.maxLength&&l.push(`- Note: Input exceeds maxlength attribute (${a.maxLength}). Browser automation bypasses maxlength validation. Server-side validation may still reject this value.`),o.viewSnapshotTimestamps.set(e,Date.now());const c=await(0,o.formatPageStateResult)({action:"type",detailLines:l,pageState:a.pageState});return(0,o.maybeAddScreenshotToResult)(c,e,t.take_screenshot_afterwards??!1)}catch(e){const n=(0,o.toAIFriendlyError)(e instanceof Error?e:new Error(String(e)),{ref:t.ref,action:"type"});return{content:[{type:"text",text:(0,o.formatAIFriendlyError)(n)}]}}},async fill(t){const e=await(0,o.resolveViewId)(t.viewId);if(!e)return{content:[{type:"text",text:"No browser tab available. Please navigate to a page first."}]};try{await(0,o.ensureCurrentPageAllowed)("browser_fill",e),await(0,o.ensureFreshSnapshot)(e,t.headless,r.BROWSER_UTILS);const n=(0,o.parseRef)(t.ref),s=t.element||"",i=`\n\t\t\t\t\t${o.ELEMENT_FINDER}\n\t\t\t\t\t${r.BROWSER_UTILS}\n\t\t\t\t\t(async function() {\n\t\t\t\t\t\tconst ref = ${JSON.stringify(n)};\n\t\t\t\t\t\tconst expectedDescription = ${JSON.stringify(s)};\n\t\t\t\t\t\tconst { element } = findElementByRef(ref);\n\t\t\t\t\t\tvalidateElementForInteraction(element, ref, 'fill', expectedDescription);\n\n\t\t\t\t\t\tconst rect = element.getBoundingClientRect();\n\t\t\t\t\t\tconst scrollPadding = 50;\n\t\t\t\t\t\tconst needsScroll = rect.top < scrollPadding || rect.left < scrollPadding ||\n\t\t\t\t\t\t\trect.bottom > window.innerHeight - scrollPadding || rect.right > window.innerWidth - scrollPadding;\n\t\t\t\t\t\tif (needsScroll) {\n\t\t\t\t\t\t\telement.scrollIntoView({ block: 'center', inline: 'center', behavior: 'smooth' });\n\t\t\t\t\t\t\tawait new Promise(r => setTimeout(r, 300));\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tconst tagName = element.tagName.toUpperCase();\n\t\t\t\t\t\tconst isContentEditable = element.isContentEditable;\n\n\t\t\t\t\t\tconst previousActiveElement = document.activeElement;\n\t\t\t\t\t\tif (previousActiveElement && previousActiveElement !== element && previousActiveElement !== document.body) {\n\t\t\t\t\t\t\tif (typeof previousActiveElement.blur === 'function') {\n\t\t\t\t\t\t\t\tpreviousActiveElement.blur();\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\telement.focus();\n\t\t\t\t\t\tawait new Promise(r => setTimeout(r, 0));\n\n\t\t\t\t\t\tif (document.activeElement !== element) {\n\t\t\t\t\t\t\telement.click();\n\t\t\t\t\t\t\telement.focus();\n\t\t\t\t\t\t\tawait new Promise(r => setTimeout(r, 0));\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tconst value = ${JSON.stringify(t.value)};\n\n\t\t\t\t\t\tfunction setNativeValue(el, val) {\n\t\t\t\t\t\t\tconst elTagName = el.tagName.toUpperCase();\n\t\t\t\t\t\t\tlet valueSetter = null;\n\n\t\t\t\t\t\t\tif (elTagName === 'INPUT') {\n\t\t\t\t\t\t\t\tvalueSetter = Object.getOwnPropertyDescriptor(window.HTMLInputElement.prototype, 'value')?.set;\n\t\t\t\t\t\t\t} else if (elTagName === 'TEXTAREA') {\n\t\t\t\t\t\t\t\tvalueSetter = Object.getOwnPropertyDescriptor(window.HTMLTextAreaElement.prototype, 'value')?.set;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tif (valueSetter) {\n\t\t\t\t\t\t\t\tvalueSetter.call(el, val);\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\tel.value = val;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif (isContentEditable) {\n\t\t\t\t\t\t\telement.textContent = '';\n\t\t\t\t\t\t\telement.textContent = value;\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tsetNativeValue(element, '');\n\t\t\t\t\t\t\tsetNativeValue(element, value);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\telement.dispatchEvent(new Event('input', { bubbles: true }));\n\t\t\t\t\t\telement.dispatchEvent(new Event('change', { bubbles: true }));\n\n\t\t\t\t\t\tconst snapshotResult = buildPageSnapshot();\n\t\t\t\t\t\treturn {\n\t\t\t\t\t\t\tsuccess: true,\n\t\t\t\t\t\t\tvalue: value,\n\t\t\t\t\t\t\tpageState: {\n\t\t\t\t\t\t\t\turl: window.location.href,\n\t\t\t\t\t\t\t\ttitle: document.title,\n\t\t\t\t\t\t\t\tsnapshot: snapshotResult.tree\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t};\n\t\t\t\t\t})();\n\t\t\t\t`,a=await(0,o.executeInBrowser)(i,e,t.headless);o.viewSnapshotTimestamps.set(e,Date.now());const l=await(0,o.formatPageStateResult)({action:"fill",detailLines:[`- Filled with value: "${a.value.substring(0,50)}${a.value.length>50?"...":""}"`],pageState:a.pageState});return(0,o.maybeAddScreenshotToResult)(l,e,t.take_screenshot_afterwards??!1)}catch(e){const n=(0,o.toAIFriendlyError)(e instanceof Error?e:new Error(String(e)),{ref:t.ref,action:"fill"});return{content:[{type:"text",text:(0,o.formatAIFriendlyError)(n)}]}}},async fillForm(t){const e=await(0,o.resolveViewId)(t.viewId);if(!e)return{content:[{type:"text",text:"No browser tab available. Please navigate to a page first."}]};if(!t.fields||!Array.isArray(t.fields))return{content:[{type:"text",text:'Error: Missing required "fields" parameter.\n\nThe browser_fill_form tool requires a "fields" array containing the fields to fill.\n\nExample usage:\n{ fields: [{ ref: "e123", value: "John Doe" }, { ref: "e456", value: "john@example.com" }] }\n\nEach field should have a "ref" (element reference) and "value" (text to fill).'}]};if(0===t.fields.length)return{content:[{type:"text",text:'Error: Empty "fields" array provided.\n\nProvide at least one field to fill. Take a snapshot to identify the form fields and their refs.'}]};try{await(0,o.ensureCurrentPageAllowed)("browser_fill_form",e),await(0,o.ensureFreshSnapshot)(e,t.headless,r.BROWSER_UTILS);const n=t.fields.map(t=>({ref:(0,o.parseRef)(t.ref),value:t.value,element:t.element||"",clear:t.clear})),s=`\n\t\t\t\t\t${o.ELEMENT_FINDER}\n\t\t\t\t\t${r.BROWSER_UTILS}\n\t\t\t\t\t(async function() {\n\t\t\t\t\t\tconst fields = ${JSON.stringify(n)};\n\t\t\t\t\t\tconst filled = [];\n\t\t\t\t\t\tconst failed = [];\n\n\t\t\t\t\t\tfunction setNativeValue(el, val) {\n\t\t\t\t\t\t\tconst elTagName = el.tagName.toUpperCase();\n\t\t\t\t\t\t\tlet valueSetter = null;\n\n\t\t\t\t\t\t\tif (elTagName === 'INPUT') {\n\t\t\t\t\t\t\t\tvalueSetter = Object.getOwnPropertyDescriptor(window.HTMLInputElement.prototype, 'value')?.set;\n\t\t\t\t\t\t\t} else if (elTagName === 'TEXTAREA') {\n\t\t\t\t\t\t\t\tvalueSetter = Object.getOwnPropertyDescriptor(window.HTMLTextAreaElement.prototype, 'value')?.set;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tif (valueSetter) {\n\t\t\t\t\t\t\t\tvalueSetter.call(el, val);\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\tel.value = val;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tfor (const field of fields) {\n\t\t\t\t\t\t\tconst ref = field.ref;\n\t\t\t\t\t\t\tconst expectedDescription = field.element || '';\n\t\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\t\tconst { element } = findElementByRef(ref);\n\t\t\t\t\t\t\t\tvalidateElementForInteraction(element, ref, 'fill', expectedDescription);\n\n\t\t\t\t\t\t\t\tconst rect = element.getBoundingClientRect();\n\t\t\t\t\t\t\t\tconst scrollPadding = 50;\n\t\t\t\t\t\t\t\tconst needsScroll = rect.top < scrollPadding || rect.left < scrollPadding ||\n\t\t\t\t\t\t\t\t\trect.bottom > window.innerHeight - scrollPadding || rect.right > window.innerWidth - scrollPadding;\n\t\t\t\t\t\t\t\tif (needsScroll) {\n\t\t\t\t\t\t\t\t\telement.scrollIntoView({ block: 'center', inline: 'center', behavior: 'smooth' });\n\t\t\t\t\t\t\t\t\tawait new Promise(r => setTimeout(r, 300));\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\tconst isContentEditable = element.isContentEditable;\n\t\t\t\t\t\t\t\tconst clearFirst = field.clear !== undefined ? field.clear : true;\n\t\t\t\t\t\t\t\tconst value = String(field.value);\n\n\t\t\t\t\t\t\t\tif (clearFirst) {\n\t\t\t\t\t\t\t\t\tif (isContentEditable) {\n\t\t\t\t\t\t\t\t\t\telement.textContent = '';\n\t\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\t\tsetNativeValue(element, '');\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\tif (isContentEditable) {\n\t\t\t\t\t\t\t\t\tconst existingContent = clearFirst ? '' : (element.textContent || '');\n\t\t\t\t\t\t\t\t\telement.textContent = existingContent + value;\n\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\tconst existingValue = clearFirst ? '' : (element.value || '');\n\t\t\t\t\t\t\t\t\tsetNativeValue(element, existingValue + value);\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\telement.dispatchEvent(new Event('input', { bubbles: true }));\n\t\t\t\t\t\t\t\telement.dispatchEvent(new Event('change', { bubbles: true }));\n\n\t\t\t\t\t\t\t\tconst preview = value.length > 60 ? value.substring(0, 60) + '...' : value;\n\t\t\t\t\t\t\t\tfilled.push({ ref, valuePreview: preview });\n\t\t\t\t\t\t\t} catch (err) {\n\t\t\t\t\t\t\t\tconst message = err instanceof Error ? err.message : String(err);\n\t\t\t\t\t\t\t\tfailed.push({ ref, error: message });\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tconst snapshotResult = buildPageSnapshot();\n\t\t\t\t\t\treturn {\n\t\t\t\t\t\t\tsuccess: failed.length === 0,\n\t\t\t\t\t\t\tfilled,\n\t\t\t\t\t\t\tfailed,\n\t\t\t\t\t\t\tpageState: {\n\t\t\t\t\t\t\t\turl: window.location.href,\n\t\t\t\t\t\t\t\ttitle: document.title,\n\t\t\t\t\t\t\t\tsnapshot: snapshotResult.tree\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t};\n\t\t\t\t\t})();\n\t\t\t\t`,i=(0,o.validateBrowserResult)(await(0,o.executeInBrowser)(s,e,t.headless),["filled","failed","pageState"]),a=[];if(a.push(`- Fields filled: ${i.filled.length}`),i.failed.length>0){a.push(`- Fields failed: ${i.failed.length}`);const t=i.failed.slice(0,5).map(t=>`${t.ref}: ${t.error}`);a.push(`- Failed refs: ${t.join("; ")}`)}o.viewSnapshotTimestamps.set(e,Date.now());const l=await(0,o.formatPageStateResult)({action:"fill_form",detailLines:a,pageState:i.pageState});return(0,o.maybeAddScreenshotToResult)(l,e,t.take_screenshot_afterwards??!1)}catch(t){const e=(0,o.toAIFriendlyError)(t instanceof Error?t:new Error(String(t)),{action:"fill_form"});return{content:[{type:"text",text:(0,o.formatAIFriendlyError)(e)}]}}},async selectOption(t){const e=await(0,o.resolveViewId)(t.viewId);if(!e)return{content:[{type:"text",text:"No browser tab available. Please navigate to a page first."}]};if(!t.values||!Array.isArray(t.values))return{content:[{type:"text",text:'Error: Missing required "values" parameter.\n\nThe browser_select_option tool requires a "values" array containing the option(s) to select.\n\nExample usage:\n- Single select: { ref: "e123", values: ["optionValue"] }\n- Multi-select: { ref: "e123", values: ["value1", "value2"] }\n\nValues can be option values or labels. Take a snapshot to see available options.'}]};if(0===t.values.length)return{content:[{type:"text",text:'Error: Empty "values" array provided.\n\nProvide at least one value to select. Take a snapshot to see available options for this select element.'}]};try{await(0,o.ensureCurrentPageAllowed)("browser_select_option",e),await(0,o.ensureFreshSnapshot)(e,t.headless,r.BROWSER_UTILS);const n=(0,o.parseRef)(t.ref),s=`\n\t\t\t\t\t${o.ELEMENT_FINDER}\n\t\t\t\t\t${r.BROWSER_UTILS}\n\t\t\t\t\t(async function() {\n\t\t\t\t\t\tconst ref = ${JSON.stringify(n)};\n\t\t\t\t\t\tconst { element } = findElementByRef(ref);\n\t\t\t\t\t\tif (!element) throw new Error('Element not found: ' + ref + '. Take a snapshot to get updated refs.');\n\n\t\t\t\t\t\tconst selectElement = element;\n\t\t\t\t\t\tif (selectElement.tagName.toUpperCase() !== 'SELECT') {\n\t\t\t\t\t\t\tthrow new Error('Element ' + ref + ' is not a select element (found: ' + selectElement.tagName.toLowerCase() + ').');\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif (selectElement.disabled) {\n\t\t\t\t\t\t\tthrow new Error('Select element ' + ref + ' is disabled and cannot be interacted with.');\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tconst rect = selectElement.getBoundingClientRect();\n\t\t\t\t\t\tconst scrollPadding = 50;\n\t\t\t\t\t\tconst needsScroll = rect.top < scrollPadding || rect.left < scrollPadding ||\n\t\t\t\t\t\t\trect.bottom > window.innerHeight - scrollPadding || rect.right > window.innerWidth - scrollPadding;\n\t\t\t\t\t\tif (needsScroll) {\n\t\t\t\t\t\t\tselectElement.scrollIntoView({ block: 'center', inline: 'center', behavior: 'smooth' });\n\t\t\t\t\t\t\tawait new Promise(r => setTimeout(r, 300));\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tselectElement.focus();\n\t\t\t\t\t\tawait new Promise(r => setTimeout(r, 0));\n\n\t\t\t\t\t\tconst values = ${JSON.stringify(t.values)};\n\n\t\t\t\t\t\tconst availableOptions = Array.from(selectElement.options).map(o => ({\n\t\t\t\t\t\t\tvalue: o.value,\n\t\t\t\t\t\t\tlabel: o.textContent?.trim() || o.label || '',\n\t\t\t\t\t\t\tdisabled: o.disabled\n\t\t\t\t\t\t}));\n\n\t\t\t\t\t\tif (values.length > 1 && !selectElement.multiple) {\n\t\t\t\t\t\t\tthrow new Error('Cannot select multiple values on a single-select dropdown. The select element does not have the "multiple" attribute. Use a single value instead, or interact with the correct multi-select element.');\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif (!selectElement.multiple) {\n\t\t\t\t\t\t\tselectElement.value = '';\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tArray.from(selectElement.options).forEach(option => {\n\t\t\t\t\t\t\t\toption.selected = false;\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tconst selectedValues = [];\n\t\t\t\t\t\tconst matchedBy = [];\n\t\t\t\t\t\tfor (const value of values) {\n\t\t\t\t\t\t\tlet optionFound = false;\n\t\t\t\t\t\t\tfor (const option of selectElement.options) {\n\t\t\t\t\t\t\t\tif (option.value === value) {\n\t\t\t\t\t\t\t\t\tif (option.disabled) {\n\t\t\t\t\t\t\t\t\t\tthrow new Error('Option "' + value + '" is disabled and cannot be selected.');\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\toption.selected = true;\n\t\t\t\t\t\t\t\t\tselectedValues.push(option.value);\n\t\t\t\t\t\t\t\t\tmatchedBy.push('value');\n\t\t\t\t\t\t\t\t\toptionFound = true;\n\t\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tif (!optionFound) {\n\t\t\t\t\t\t\t\tfor (const option of selectElement.options) {\n\t\t\t\t\t\t\t\t\tconst labelText = (option.textContent?.trim() || option.label || '').toLowerCase();\n\t\t\t\t\t\t\t\t\tif (labelText === value.toLowerCase()) {\n\t\t\t\t\t\t\t\t\t\tif (option.disabled) {\n\t\t\t\t\t\t\t\t\t\t\tthrow new Error('Option with label "' + value + '" is disabled and cannot be selected.');\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\toption.selected = true;\n\t\t\t\t\t\t\t\t\t\tselectedValues.push(option.value);\n\t\t\t\t\t\t\t\t\t\tmatchedBy.push('label');\n\t\t\t\t\t\t\t\t\t\toptionFound = true;\n\t\t\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tif (!optionFound) {\n\t\t\t\t\t\t\t\tfor (const option of selectElement.options) {\n\t\t\t\t\t\t\t\t\tconst labelText = (option.textContent?.trim() || option.label || '').toLowerCase();\n\t\t\t\t\t\t\t\t\tif (labelText.includes(value.toLowerCase())) {\n\t\t\t\t\t\t\t\t\t\tif (option.disabled) {\n\t\t\t\t\t\t\t\t\t\t\tthrow new Error('Option containing "' + value + '" is disabled and cannot be selected.');\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\toption.selected = true;\n\t\t\t\t\t\t\t\t\t\tselectedValues.push(option.value);\n\t\t\t\t\t\t\t\t\t\tmatchedBy.push('partial label');\n\t\t\t\t\t\t\t\t\t\toptionFound = true;\n\t\t\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tif (!optionFound) {\n\t\t\t\t\t\t\t\tconst optionList = availableOptions.slice(0, 8).map(o =>\n\t\t\t\t\t\t\t\t\t'"' + o.label + '"' + (o.value !== o.label ? ' (value: ' + o.value + ')' : '') + (o.disabled ? ' [disabled]' : '')\n\t\t\t\t\t\t\t\t).join(', ');\n\t\t\t\t\t\t\t\tconst isMultiple = selectElement.multiple ? ' (multi-select)' : ' (single-select)';\n\t\t\t\t\t\t\t\tthrow new Error('Option "' + value + '" not found in select element' + isMultiple + '. Available options: ' + optionList + (availableOptions.length > 8 ? '...' : '') + '. Try using the exact option value or label.');\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tselectElement.dispatchEvent(new Event('input', { bubbles: true }));\n\t\t\t\t\t\tselectElement.dispatchEvent(new Event('change', { bubbles: true }));\n\n\t\t\t\t\t\tconst snapshotResult = buildPageSnapshot();\n\t\t\t\t\t\treturn {\n\t\t\t\t\t\t\tsuccess: true,\n\t\t\t\t\t\t\tselectedValues,\n\t\t\t\t\t\t\tmatchedBy,\n\t\t\t\t\t\t\tavailableOptions: availableOptions.slice(0, 10),\n\t\t\t\t\t\t\tpageState: {\n\t\t\t\t\t\t\t\turl: window.location.href,\n\t\t\t\t\t\t\t\ttitle: document.title,\n\t\t\t\t\t\t\t\tsnapshot: snapshotResult.tree\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t};\n\t\t\t\t\t})();\n\t\t\t\t`,i=(0,o.validateBrowserResult)(await(0,o.executeInBrowser)(s,e,t.headless),["selectedValues","matchedBy","pageState"]),a=[];if(i.selectedValues.length>0){const t=i.selectedValues.map((t,e)=>`${t} (matched by ${i.matchedBy[e]||"value"})`);a.push(`- Selected: ${t.join(", ")}`)}else a.push("- Selected values: (none)");o.viewSnapshotTimestamps.set(e,Date.now());const l=await(0,o.formatPageStateResult)({action:"select_option",detailLines:a,pageState:i.pageState});return(0,o.maybeAddScreenshotToResult)(l,e,t.take_screenshot_afterwards??!1)}catch(e){const n=(0,o.toAIFriendlyError)(e instanceof Error?e:new Error(String(e)),{ref:t.ref,action:"selectOption"});return{content:[{type:"text",text:(0,o.formatAIFriendlyError)(n)}]}}},async pressKey(t){const e=await(0,o.resolveViewId)(t.viewId);if(!e)return{content:[{type:"text",text:"No browser tab available. Please navigate to a page first."}]};await(0,o.ensureCurrentPageAllowed)("browser_press_key",e);const n=`\n\t\t\t\t(function() {\n\t\t\t\t\tconst keyInput = ${JSON.stringify(t.key)};\n\n\t\t\t\t\tconst keyCodeMap = {\n\t\t\t\t\t\t'PageDown': 34, 'PageUp': 33, 'End': 35, 'Home': 36,\n\t\t\t\t\t\t'ArrowLeft': 37, 'ArrowUp': 38, 'ArrowRight': 39, 'ArrowDown': 40,\n\t\t\t\t\t\t'Enter': 13, 'Escape': 27, 'Tab': 9, 'Backspace': 8, 'Delete': 46,\n\t\t\t\t\t\t'Space': 32, ' ': 32, 'F1': 112, 'F2': 113, 'F3': 114, 'F4': 115,\n\t\t\t\t\t\t'F5': 116, 'F6': 117, 'F7': 118, 'F8': 119, 'F9': 120, 'F10': 121,\n\t\t\t\t\t\t'F11': 122, 'F12': 123, 'Insert': 45, 'NumLock': 144, 'ScrollLock': 145,\n\t\t\t\t\t\t'Pause': 19, 'CapsLock': 20\n\t\t\t\t\t};\n\n\t\t\t\t\tconst codeMap = {\n\t\t\t\t\t\t'a': 'KeyA', 'b': 'KeyB', 'c': 'KeyC', 'd': 'KeyD', 'e': 'KeyE',\n\t\t\t\t\t\t'f': 'KeyF', 'g': 'KeyG', 'h': 'KeyH', 'i': 'KeyI', 'j': 'KeyJ',\n\t\t\t\t\t\t'k': 'KeyK', 'l': 'KeyL', 'm': 'KeyM', 'n': 'KeyN', 'o': 'KeyO',\n\t\t\t\t\t\t'p': 'KeyP', 'q': 'KeyQ', 'r': 'KeyR', 's': 'KeyS', 't': 'KeyT',\n\t\t\t\t\t\t'u': 'KeyU', 'v': 'KeyV', 'w': 'KeyW', 'x': 'KeyX', 'y': 'KeyY', 'z': 'KeyZ',\n\t\t\t\t\t\t'0': 'Digit0', '1': 'Digit1', '2': 'Digit2', '3': 'Digit3', '4': 'Digit4',\n\t\t\t\t\t\t'5': 'Digit5', '6': 'Digit6', '7': 'Digit7', '8': 'Digit8', '9': 'Digit9',\n\t\t\t\t\t\t' ': 'Space', 'Space': 'Space',\n\t\t\t\t\t\t'Enter': 'Enter', 'Tab': 'Tab', 'Escape': 'Escape', 'Backspace': 'Backspace',\n\t\t\t\t\t\t'Delete': 'Delete', 'Insert': 'Insert',\n\t\t\t\t\t\t'ArrowUp': 'ArrowUp', 'ArrowDown': 'ArrowDown', 'ArrowLeft': 'ArrowLeft', 'ArrowRight': 'ArrowRight',\n\t\t\t\t\t\t'Home': 'Home', 'End': 'End', 'PageUp': 'PageUp', 'PageDown': 'PageDown',\n\t\t\t\t\t\t'F1': 'F1', 'F2': 'F2', 'F3': 'F3', 'F4': 'F4', 'F5': 'F5', 'F6': 'F6',\n\t\t\t\t\t\t'F7': 'F7', 'F8': 'F8', 'F9': 'F9', 'F10': 'F10', 'F11': 'F11', 'F12': 'F12',\n\t\t\t\t\t\t'-': 'Minus', '=': 'Equal', '[': 'BracketLeft', ']': 'BracketRight',\n\t\t\t\t\t\t'\\\\': 'Backslash', ';': 'Semicolon', "'": 'Quote', ',': 'Comma',\n\t\t\t\t\t\t'.': 'Period', '/': 'Slash', '\`': 'Backquote'\n\t\t\t\t\t};\n\n\t\t\t\t\tconst scrollAmounts = {\n\t\t\t\t\t\t'PageDown': { x: 0, y: window.innerHeight * 0.8 },\n\t\t\t\t\t\t'PageUp': { x: 0, y: -window.innerHeight * 0.8 },\n\t\t\t\t\t\t'ArrowDown': { x: 0, y: 40 },\n\t\t\t\t\t\t'ArrowUp': { x: 0, y: -40 },\n\t\t\t\t\t\t'End': { x: 0, y: document.documentElement.scrollHeight - window.scrollY },\n\t\t\t\t\t\t'Home': { x: 0, y: -window.scrollY },\n\t\t\t\t\t\t'Space': { x: 0, y: window.innerHeight * 0.8 },\n\t\t\t\t\t\t' ': { x: 0, y: window.innerHeight * 0.8 },\n\t\t\t\t\t};\n\n\t\t\t\t\tconst modifierAliases = {\n\t\t\t\t\t\t'Control': ['Control', 'Ctrl', 'control', 'ctrl'],\n\t\t\t\t\t\t'Shift': ['Shift', 'shift'],\n\t\t\t\t\t\t'Alt': ['Alt', 'alt', 'Option', 'option'],\n\t\t\t\t\t\t'Meta': ['Meta', 'meta', 'Command', 'command', 'Cmd', 'cmd', 'Win', 'win']\n\t\t\t\t\t};\n\n\t\t\t\t\tfunction parseKeyCombo(input) {\n\t\t\t\t\t\tconst parts = input.split('+').map(p => p.trim());\n\t\t\t\t\t\tconst modifiers = { ctrlKey: false, shiftKey: false, altKey: false, metaKey: false };\n\t\t\t\t\t\tlet mainKey = '';\n\n\t\t\t\t\t\tfor (const part of parts) {\n\t\t\t\t\t\t\tlet isModifier = false;\n\t\t\t\t\t\t\tfor (const [mod, aliases] of Object.entries(modifierAliases)) {\n\t\t\t\t\t\t\t\tif (aliases.includes(part)) {\n\t\t\t\t\t\t\t\t\tif (mod === 'Control') modifiers.ctrlKey = true;\n\t\t\t\t\t\t\t\t\telse if (mod === 'Shift') modifiers.shiftKey = true;\n\t\t\t\t\t\t\t\t\telse if (mod === 'Alt') modifiers.altKey = true;\n\t\t\t\t\t\t\t\t\telse if (mod === 'Meta') modifiers.metaKey = true;\n\t\t\t\t\t\t\t\t\tisModifier = true;\n\t\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tif (!isModifier) {\n\t\t\t\t\t\t\t\tmainKey = part;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn { modifiers, mainKey };\n\t\t\t\t\t}\n\n\t\t\t\t\tconst { modifiers, mainKey } = parseKeyCombo(keyInput);\n\t\t\t\t\tconst key = mainKey || keyInput;\n\n\t\t\t\t\tconst keyLower = key.toLowerCase();\n\t\t\t\t\tconst code = codeMap[key] || codeMap[keyLower] || (key.length === 1 ? 'Key' + key.toUpperCase() : key);\n\t\t\t\t\tconst keyCode = keyCodeMap[key] || (key.length === 1 ? key.toUpperCase().charCodeAt(0) : 0);\n\n\t\t\t\t\tconst activeElement = document.activeElement || document.body;\n\n\t\t\t\t\tconst scrollKeys = ['PageDown', 'PageUp', 'Home', 'End'];\n\t\t\t\t\tif (scrollKeys.includes(key) && !modifiers.ctrlKey && !modifiers.altKey && !modifiers.metaKey) {\n\t\t\t\t\t\tconst isScrollable = (el) => {\n\t\t\t\t\t\t\tif (!el || !(el instanceof HTMLElement)) return false;\n\t\t\t\t\t\t\tconst style = getComputedStyle(el);\n\t\t\t\t\t\t\tconst overflowY = style.overflowY;\n\t\t\t\t\t\t\treturn (overflowY === 'auto' || overflowY === 'scroll') && el.scrollHeight > el.clientHeight;\n\t\t\t\t\t\t};\n\n\t\t\t\t\t\tlet scrollable = null;\n\t\t\t\t\t\tlet current = activeElement;\n\t\t\t\t\t\twhile (current && current !== document.body) {\n\t\t\t\t\t\t\tif (isScrollable(current)) {\n\t\t\t\t\t\t\t\tscrollable = current;\n\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tcurrent = current.parentElement;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif (!scrollable) {\n\t\t\t\t\t\t\tscrollable = document.scrollingElement || document.documentElement;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tconst viewportHeight = scrollable.clientHeight;\n\n\t\t\t\t\t\tswitch (key) {\n\t\t\t\t\t\t\tcase 'PageDown':\n\t\t\t\t\t\t\t\tscrollable.scrollBy({ top: viewportHeight, behavior: 'instant' });\n\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\tcase 'PageUp':\n\t\t\t\t\t\t\t\tscrollable.scrollBy({ top: -viewportHeight, behavior: 'instant' });\n\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\tcase 'Home':\n\t\t\t\t\t\t\t\tscrollable.scrollTo({ top: 0, behavior: 'instant' });\n\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\tcase 'End':\n\t\t\t\t\t\t\t\tscrollable.scrollTo({ top: scrollable.scrollHeight, behavior: 'instant' });\n\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t}\n\t\t\t\t\t} else if (scrollAmounts[key] && !modifiers.ctrlKey && !modifiers.altKey && !modifiers.metaKey) {\n\t\t\t\t\t\twindow.scrollBy({ left: scrollAmounts[key].x, top: scrollAmounts[key].y, behavior: 'smooth' });\n\t\t\t\t\t}\n\n\t\t\t\t\tconst eventInit = {\n\t\t\t\t\t\tkey: key,\n\t\t\t\t\t\tcode: code,\n\t\t\t\t\t\tkeyCode: keyCode,\n\t\t\t\t\t\twhich: keyCode,\n\t\t\t\t\t\tbubbles: true,\n\t\t\t\t\t\tcancelable: true,\n\t\t\t\t\t\tctrlKey: modifiers.ctrlKey,\n\t\t\t\t\t\tshiftKey: modifiers.shiftKey,\n\t\t\t\t\t\taltKey: modifiers.altKey,\n\t\t\t\t\t\tmetaKey: modifiers.metaKey\n\t\t\t\t\t};\n\n\t\t\t\t\tactiveElement.dispatchEvent(new KeyboardEvent('keydown', eventInit));\n\n\t\t\t\t\tif (key.length === 1 && !modifiers.ctrlKey && !modifiers.altKey && !modifiers.metaKey) {\n\t\t\t\t\t\tactiveElement.dispatchEvent(new KeyboardEvent('keypress', eventInit));\n\n\t\t\t\t\t\tif (activeElement.tagName === 'INPUT' || activeElement.tagName === 'TEXTAREA' || activeElement.isContentEditable) {\n\t\t\t\t\t\t\tconst inputEvent = new InputEvent('beforeinput', {\n\t\t\t\t\t\t\t\tbubbles: true,\n\t\t\t\t\t\t\t\tcancelable: true,\n\t\t\t\t\t\t\t\tinputType: 'insertText',\n\t\t\t\t\t\t\t\tdata: key\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\tactiveElement.dispatchEvent(inputEvent);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\tactiveElement.dispatchEvent(new KeyboardEvent('keyup', eventInit));\n\n\t\t\t\t\tconst modifierStr = [\n\t\t\t\t\t\tmodifiers.ctrlKey ? 'Ctrl' : '',\n\t\t\t\t\t\tmodifiers.shiftKey ? 'Shift' : '',\n\t\t\t\t\t\tmodifiers.altKey ? 'Alt' : '',\n\t\t\t\t\t\tmodifiers.metaKey ? 'Meta' : ''\n\t\t\t\t\t].filter(Boolean).join('+');\n\n\t\t\t\t\treturn {\n\t\t\t\t\t\taction: 'press_key',\n\t\t\t\t\t\tsuccess: true,\n\t\t\t\t\t\tkey: key,\n\t\t\t\t\t\tcode: code,\n\t\t\t\t\t\tmodifiers: modifierStr || 'none',\n\t\t\t\t\t\tfullCombo: modifierStr ? modifierStr + '+' + key : key\n\t\t\t\t\t};\n\t\t\t\t})();\n\t\t\t`,r=(0,o.validateBrowserResult)(await(0,o.executeInBrowser)(n,e,t.headless),["key","code","fullCombo"]);if(!r.success)return{content:[{type:"text",text:`Failed to press key: ${r.key}`}]};const s={content:[{type:"text",text:`Successfully pressed key: ${r.fullCombo} (code: ${r.code})`},{type:"metadata",viewId:e}]};return(0,o.maybeAddScreenshotToResult)(s,e,t.take_screenshot_afterwards??!1)}}};const r=n(8),o=n(376)},756:(t,e)=>{Object.defineProperty(e,"__esModule",{value:!0}),e.generateBrowserUIScript=function(t){return`\n(function() {\n\t// Prevent double injection\n\tif (window.__cursorBrowserAutomationInjected) {\n\t\treturn;\n\t}\n\n\t// Only inject in top-level frame\n\tif (window !== window.top) {\n\t\treturn;\n\t}\n\n\twindow.__cursorBrowserAutomationInjected = true;\n\n\tconst tabId = ${JSON.stringify(t)};\n\n\t// =============================================================================\n\t// Area Screenshot Selection\n\t// =============================================================================\n\t// IMPORTANT: BrowserEditorContent.tsx may also inject area screenshot handling\n\t// via BROWSER_AREA_SCREENSHOT_SCRIPT. Check if it's already injected to avoid\n\t// duplicate screenshot captures.\n\n\tconst areaScreenshotAlreadyInjected = window.__cursorAreaScreenshotInjected === true;\n\n\tlet isDragging = false;\n\tlet dragStartX = null;\n\tlet dragStartY = null;\n\tlet dragSelectionBox = null;\n\tlet areaDragListeners = null;\n\n\tfunction enableAreaSelection() {\n\t\t// Skip if BrowserEditorContent already handles area screenshots\n\t\tif (areaScreenshotAlreadyInjected) {\n\t\t\treturn;\n\t\t}\n\n\t\tconst mousedownListener = (e) => {\n\t\t\t// Only start drag if not clicking on any overlay elements\n\t\t\tif (e.target.getAttribute &&\n\t\t\t\te.target.getAttribute('data-cursor-overlay') === 'true'\n\t\t\t) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\te.preventDefault();\n\t\t\te.stopPropagation();\n\n\t\t\tisDragging = true;\n\t\t\tdragStartX = e.clientX;\n\t\t\tdragStartY = e.clientY;\n\n\t\t\t// Hide any existing overlays\n\t\t\tconst overlays = document.querySelectorAll('[data-cursor-overlay="true"]');\n\t\t\toverlays.forEach(el => el.style.display = 'none');\n\n\t\t\tif (!dragSelectionBox) {\n\t\t\t\tdragSelectionBox = document.createElement('div');\n\t\t\t\tdragSelectionBox.style.cssText = 'position:fixed;background:rgba(58,150,221,0.1);border:2px dashed #3a96dd;pointer-events:none;z-index:2147483647;';\n\t\t\t\tdocument.body.appendChild(dragSelectionBox);\n\t\t\t}\n\t\t\tdragSelectionBox.style.left = dragStartX + 'px';\n\t\t\tdragSelectionBox.style.top = dragStartY + 'px';\n\t\t\tdragSelectionBox.style.width = '0px';\n\t\t\tdragSelectionBox.style.height = '0px';\n\t\t};\n\n\t\tconst mousemoveListener = (e) => {\n\t\t\tif (!isDragging || !dragSelectionBox) return;\n\n\t\t\tconst currentX = e.clientX;\n\t\t\tconst currentY = e.clientY;\n\n\t\t\tconst left = Math.min(dragStartX, currentX);\n\t\t\tconst top = Math.min(dragStartY, currentY);\n\t\t\tconst width = Math.abs(currentX - dragStartX);\n\t\t\tconst height = Math.abs(currentY - dragStartY);\n\n\t\t\tdragSelectionBox.style.left = left + 'px';\n\t\t\tdragSelectionBox.style.top = top + 'px';\n\t\t\tdragSelectionBox.style.width = width + 'px';\n\t\t\tdragSelectionBox.style.height = height + 'px';\n\t\t};\n\n\t\tconst mouseupListener = (e) => {\n\t\t\tif (!isDragging) return;\n\t\t\te.preventDefault();\n\t\t\te.stopPropagation();\n\n\t\t\tconst currentX = e.clientX;\n\t\t\tconst currentY = e.clientY;\n\n\t\t\tconst left = Math.min(dragStartX, currentX);\n\t\t\tconst top = Math.min(dragStartY, currentY);\n\t\t\tconst width = Math.abs(currentX - dragStartX);\n\t\t\tconst height = Math.abs(currentY - dragStartY);\n\n\t\t\tif (width > 5 || height > 5) {\n\t\t\t\tconst bounds = {\n\t\t\t\t\tx: Math.round(left),\n\t\t\t\t\ty: Math.round(top),\n\t\t\t\t\twidth: Math.round(width),\n\t\t\t\t\theight: Math.round(height)\n\t\t\t\t};\n\n\t\t\t\tif (dragSelectionBox) {\n\t\t\t\t\tdragSelectionBox.remove();\n\t\t\t\t\tdragSelectionBox = null;\n\t\t\t\t}\n\n\t\t\t\tdisableAreaSelection();\n\n\t\t\t\t// Send area screenshot selection\n\t\t\t\trequestAnimationFrame(() => {\n\t\t\t\t\trequestAnimationFrame(() => {\n\t\t\t\t\t\tif (window.cursorBrowser) {\n\t\t\t\t\t\t\twindow.cursorBrowser.send('area-screenshot-selected', {\n\t\t\t\t\t\t\t\tbounds: bounds\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Area selection is complete, element selection will continue to work\n\t\t\t\t\t\t// No need to re-enable as the overlay system maintains its own state\n\t\t\t\t\t});\n\t\t\t\t});\n\t\t\t} else {\n\t\t\t\tif (dragSelectionBox) {\n\t\t\t\t\tdragSelectionBox.remove();\n\t\t\t\t\tdragSelectionBox = null;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tisDragging = false;\n\t\t};\n\n\t\tdocument.addEventListener('mousedown', mousedownListener, true);\n\t\tdocument.addEventListener('mousemove', mousemoveListener);\n\t\tdocument.addEventListener('mouseup', mouseupListener, true);\n\n\t\tareaDragListeners = {\n\t\t\tmousedown: mousedownListener,\n\t\t\tmousemove: mousemoveListener,\n\t\t\tmouseup: mouseupListener\n\t\t};\n\t}\n\n\tfunction disableAreaSelection() {\n\t\t// Skip if BrowserEditorContent already handles area screenshots\n\t\tif (areaScreenshotAlreadyInjected) {\n\t\t\treturn;\n\t\t}\n\n\t\tisDragging = false;\n\t\tdragStartX = null;\n\t\tdragStartY = null;\n\n\t\tif (dragSelectionBox) {\n\t\t\tdragSelectionBox.remove();\n\t\t\tdragSelectionBox = null;\n\t\t}\n\n\t\tif (areaDragListeners) {\n\t\t\tconst { mousedown, mousemove, mouseup } = areaDragListeners;\n\t\t\tdocument.removeEventListener('mousedown', mousedown, true);\n\t\t\tdocument.removeEventListener('mousemove', mousemove);\n\t\t\tdocument.removeEventListener('mouseup', mouseup, true);\n\t\t\tareaDragListeners = null;\n\t\t}\n\t}\n\n\t// =============================================================================\n\t// Message Handling\n\t// =============================================================================\n\n\twindow.addEventListener('message', (e) => {\n\t\tif (e.data.type === 'enable-element-selection') {\n\t\t\t// Check if we should enable area selection along with element selection\n\t\t\tif (e.data.enableAreaSelection) {\n\t\t\t\tenableAreaSelection();\n\t\t\t}\n\t\t\t// Don't re-post the message - the overlay system will handle it directly\n\t\t} else if (e.data.type === 'disable-element-selection') {\n\t\t\tdisableAreaSelection();\n\t\t\t// Don't re-post the message - the overlay system will handle it directly\n\t\t} else if (e.data.type === 'start-area-screenshot') {\n\t\t\tenableAreaSelection();\n\t\t} else if (e.data.type === 'stop-area-screenshot') {\n\t\t\tdisableAreaSelection();\n\t\t}\n\t});\n\n\t// =============================================================================\n\t// Keyboard Shortcuts\n\t// =============================================================================\n\n\tdocument.addEventListener('keydown', (e) => {\n\t\tconst isMac = navigator.platform.toUpperCase().indexOf('MAC') >= 0;\n\t\tconst cmdOrCtrl = isMac ? e.metaKey : e.ctrlKey;\n\n\t\tif (cmdOrCtrl && !e.altKey) {\n\t\t\tif (e.key === 'a' && !e.shiftKey) {\n\t\t\t\te.preventDefault();\n\t\t\t\te.stopPropagation();\n\n\t\t\t\tconst target = e.target;\n\t\t\t\tif (target instanceof HTMLInputElement || target instanceof HTMLTextAreaElement) {\n\t\t\t\t\ttarget.select();\n\t\t\t\t} else if (target instanceof HTMLElement && target.isContentEditable) {\n\t\t\t\t\tconst selection = window.getSelection();\n\t\t\t\t\tconst range = document.createRange();\n\t\t\t\t\trange.selectNodeContents(target);\n\t\t\t\t\tselection?.removeAllRanges();\n\t\t\t\t\tselection?.addRange(range);\n\t\t\t\t} else {\n\t\t\t\t\tdocument.execCommand('selectAll');\n\t\t\t\t}\n\t\t\t\treturn;\n\t\t\t}\n\t\t}\n\t}, true);\n\n})();\n`}},857:t=>{t.exports=require("os")},928:t=>{t.exports=require("path")},943:t=>{t.exports=require("fs/promises")}},e={};function n(r){var o=e[r];if(void 0!==o)return o.exports;var s=e[r]={exports:{}};return t[r].call(s.exports,s,s.exports,n),s.exports}n.d=(t,e)=>{for(var r in e)n.o(e,r)&&!n.o(t,r)&&Object.defineProperty(t,r,{enumerable:!0,get:e[r]})},n.o=(t,e)=>Object.prototype.hasOwnProperty.call(t,e),n.r=t=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(t,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(t,"__esModule",{value:!0})};var r=n(256),o=exports;for(var s in r)o[s]=r[s];r.__esModule&&Object.defineProperty(o,"__esModule",{value:!0})})();
//# sourceMappingURL=http://go/sourcemap/sourcemaps/3578107fdf149b00059ddad37048220e41681000/extensions/cursor-browser-automation/dist/extension.js.map