import { asyncScheduler } from '../scheduler/async.js';
import { Observable, operate } from '../Observable.js';
export function timeInterval(scheduler = asyncScheduler) {
    return (source) => new Observable((destination) => {
        let last = scheduler.now();
        source.subscribe(operate({
            destination,
            next: (value) => {
                const now = scheduler.now();
                const interval = now - last;
                last = now;
                destination.next(new TimeInterval(value, interval));
            },
        }));
    });
}
export class TimeInterval {
    value;
    interval;
    constructor(value, interval) {
        this.value = value;
        this.interval = interval;
    }
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/dc8361355d709f306d5159635a677a571b277bc0/node_modules/rxjs/dist/esm/internal/operators/timeInterval.js.map