"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeInterval = exports.timeInterval = void 0;
const async_js_1 = require("../scheduler/async.js");
const Observable_js_1 = require("../Observable.js");
function timeInterval(scheduler = async_js_1.asyncScheduler) {
    return (source) => new Observable_js_1.Observable((destination) => {
        let last = scheduler.now();
        source.subscribe((0, Observable_js_1.operate)({
            destination,
            next: (value) => {
                const now = scheduler.now();
                const interval = now - last;
                last = now;
                destination.next(new TimeInterval(value, interval));
            },
        }));
    });
}
exports.timeInterval = timeInterval;
class TimeInterval {
    value;
    interval;
    constructor(value, interval) {
        this.value = value;
        this.interval = interval;
    }
}
exports.TimeInterval = TimeInterval;//# sourceMappingURL=http://go/sourcemap/sourcemaps/dc8361355d709f306d5159635a677a571b277bc0/node_modules/rxjs/dist/cjs/internal/operators/timeInterval.js.map