"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.every = void 0;
const Observable_js_1 = require("../Observable.js");
function every(predicate, thisArg) {
    return (source) => new Observable_js_1.Observable((destination) => {
        let index = 0;
        source.subscribe((0, Observable_js_1.operate)({
            destination,
            next: (value) => {
                if (!predicate.call(thisArg, value, index++, source)) {
                    destination.next(false);
                    destination.complete();
                }
            },
            complete: () => {
                destination.next(true);
                destination.complete();
            },
        }));
    });
}
exports.every = every;//# sourceMappingURL=http://go/sourcemap/sourcemaps/dc8361355d709f306d5159635a677a571b277bc0/node_modules/rxjs/dist/cjs/internal/operators/every.js.map