import { Observable, operate, from } from '../Observable.js';
import { noop } from '../util/noop.js';
export function buffer(closingNotifier) {
    return (source) => new Observable((destination) => {
        let currentBuffer = [];
        from(closingNotifier).subscribe(operate({
            destination,
            next: () => {
                const b = currentBuffer;
                currentBuffer = [];
                destination.next(b);
            },
            complete: noop,
        }));
        source.subscribe(operate({
            destination,
            next: (value) => currentBuffer.push(value),
            complete: () => {
                destination.next(currentBuffer);
                destination.complete();
            },
        }));
        return () => {
            currentBuffer = null;
        };
    });
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/dc8361355d709f306d5159635a677a571b277bc0/node_modules/rxjs/dist/esm/internal/operators/buffer.js.map