const core = require('@sentry/core');

/** Gets the merged scope data */
function getScopeData() {
    const globalScope = core.getGlobalScope().getScopeData();
    const isolationScope = core.getIsolationScope().getScopeData();
    const currentScope = core.getCurrentScope().getScopeData();
    core.mergeScopeData(globalScope, isolationScope);
    core.mergeScopeData(globalScope, currentScope);
    globalScope.eventProcessors = [];
    return globalScope;
}
/** Hooks both current and isolation scope changes and passes merged scope on changes  */
function addScopeListener(callback) {
    core.getIsolationScope().addScopeListener((isolation) => {
        const merged = getScopeData();
        callback(merged, isolation);
    });
    core.getCurrentScope().addScopeListener((current) => {
        const merged = getScopeData();
        callback(merged, current);
    });
    core.getGlobalScope().addScopeListener((global) => {
        const merged = getScopeData();
        callback(merged, global);
    });
}

exports.addScopeListener = addScopeListener;
exports.getScopeData = getScopeData;//# sourceMappingURL=http://go/sourcemap/sourcemaps/dc8361355d709f306d5159635a677a571b277bc0/node_modules/@sentry/electron/common/scope.js.map
