import { Observable, isFunction } from '../Observable.js';
import { iterator as Symbol_iterator } from '../symbol/iterator.js';
import { executeSchedule } from '../util/executeSchedule.js';
export function scheduleIterable(input, scheduler) {
    return new Observable((subscriber) => {
        let iterator;
        executeSchedule(subscriber, scheduler, () => {
            iterator = input[Symbol_iterator]();
            executeSchedule(subscriber, scheduler, () => {
                let value;
                let done;
                try {
                    ({ value, done } = iterator.next());
                }
                catch (err) {
                    subscriber.error(err);
                    return;
                }
                if (done) {
                    subscriber.complete();
                }
                else {
                    subscriber.next(value);
                }
            }, 0, true);
        });
        return () => isFunction(iterator?.return) && iterator.return();
    });
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/2ca326e0d1ce10956aea33d54c0e2d8c13c58a30/node_modules/rxjs/dist/esm/internal/scheduled/scheduleIterable.js.map