import { Observable, operate } from '../Observable.js';
export function find(predicate) {
    return (source) => new Observable((subscriber) => createFind(predicate, 'value', source, subscriber));
}
export function createFind(predicate, emit, source, destination) {
    const findIndex = emit === 'index';
    let index = 0;
    source.subscribe(operate({
        destination,
        next: (value) => {
            const i = index++;
            if (predicate(value, i, source)) {
                destination.next(findIndex ? i : value);
                destination.complete();
            }
        },
        complete: () => {
            destination.next(findIndex ? -1 : undefined);
            destination.complete();
        },
    }));
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/2ca326e0d1ce10956aea33d54c0e2d8c13c58a30/node_modules/rxjs/dist/esm/internal/operators/find.js.map