"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.pairwise = void 0;
const Observable_js_1 = require("../Observable.js");
function pairwise() {
    return (source) => new Observable_js_1.Observable((destination) => {
        let prev;
        let hasPrev = false;
        source.subscribe((0, Observable_js_1.operate)({
            destination,
            next: (value) => {
                const p = prev;
                prev = value;
                hasPrev && destination.next([p, value]);
                hasPrev = true;
            },
        }));
    });
}
exports.pairwise = pairwise;//# sourceMappingURL=http://go/sourcemap/sourcemaps/2ca326e0d1ce10956aea33d54c0e2d8c13c58a30/node_modules/rxjs/dist/cjs/internal/operators/pairwise.js.map