"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.debounce = void 0;
const Observable_js_1 = require("../Observable.js");
const noop_js_1 = require("../util/noop.js");
function debounce(durationSelector) {
    return (source) => new Observable_js_1.Observable((destination) => {
        let hasValue = false;
        let lastValue = null;
        let durationSubscriber = null;
        const emit = () => {
            durationSubscriber?.unsubscribe();
            durationSubscriber = null;
            if (hasValue) {
                hasValue = false;
                const value = lastValue;
                lastValue = null;
                destination.next(value);
            }
        };
        source.subscribe((0, Observable_js_1.operate)({
            destination,
            next: (value) => {
                durationSubscriber?.unsubscribe();
                hasValue = true;
                lastValue = value;
                durationSubscriber = (0, Observable_js_1.operate)({ destination, next: emit, complete: noop_js_1.noop });
                (0, Observable_js_1.from)(durationSelector(value)).subscribe(durationSubscriber);
            },
            complete: () => {
                emit();
                destination.complete();
            },
            finalize: () => {
                lastValue = durationSubscriber = null;
            },
        }));
    });
}
exports.debounce = debounce;//# sourceMappingURL=http://go/sourcemap/sourcemaps/2ca326e0d1ce10956aea33d54c0e2d8c13c58a30/node_modules/rxjs/dist/cjs/internal/operators/debounce.js.map