"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.range = void 0;
const Observable_js_1 = require("../Observable.js");
const empty_js_1 = require("./empty.js");
const executeSchedule_js_1 = require("../util/executeSchedule.js");
function range(start, count, scheduler) {
    if (count == null) {
        count = start;
        start = 0;
    }
    if (count <= 0) {
        return empty_js_1.EMPTY;
    }
    const end = count + start;
    return new Observable_js_1.Observable(scheduler
        ?
            (subscriber) => {
                let n = start;
                const emit = () => {
                    if (n < end) {
                        subscriber.next(n++);
                        if (!subscriber.closed) {
                            (0, executeSchedule_js_1.executeSchedule)(subscriber, scheduler, emit);
                        }
                    }
                    else {
                        subscriber.complete();
                    }
                };
                (0, executeSchedule_js_1.executeSchedule)(subscriber, scheduler, emit);
            }
        :
            (subscriber) => {
                let n = start;
                while (n < end && !subscriber.closed) {
                    subscriber.next(n++);
                }
                subscriber.complete();
            });
}
exports.range = range;//# sourceMappingURL=http://go/sourcemap/sourcemaps/2ca326e0d1ce10956aea33d54c0e2d8c13c58a30/node_modules/rxjs/dist/cjs/internal/observable/range.js.map