import { Observable, operate } from '../Observable.js';
import { EmptyError } from '../util/EmptyError.js';
export function first(predicate, defaultValue) {
    const hasDefaultValue = arguments.length >= 2;
    return (source) => new Observable((destination) => {
        let index = 0;
        const operatorSubscriber = operate({
            destination,
            next: (value) => {
                const passed = predicate ? predicate(value, index++, source) : true;
                if (passed) {
                    operatorSubscriber.unsubscribe();
                    destination.next(value);
                    destination.complete();
                }
            },
            complete: () => {
                if (hasDefaultValue) {
                    destination.next(defaultValue);
                    destination.complete();
                }
                else {
                    destination.error(new EmptyError());
                }
            },
        });
        source.subscribe(operatorSubscriber);
    });
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/a86689c93e9fb11addfbefd29a6ec7c0a59175e0/node_modules/rxjs/dist/esm/internal/operators/first.js.map