import { createStackParser, stackParserFromStackParserOptions, getIntegrationsToSetup, debug, nodeStackLineParser } from '@sentry/core';
import { setNodeAsyncContextStrategy, getCurrentScope, NodeClient, initOpenTelemetry, eventFiltersIntegration, functionToStringIntegration, linkedErrorsIntegration, consoleIntegration, nativeNodeFetchIntegration, onUncaughtExceptionIntegration, onUnhandledRejectionIntegration, createGetModuleFromFilename } from '@sentry/node';
import { makeUtilityProcessTransport } from './transport.js';

const defaultStackParser = createStackParser(nodeStackLineParser(createGetModuleFromFilename()));
/** Get the default integrations for the main process SDK. */
function getDefaultIntegrations() {
    const integrations = [
        // Node integrations
        eventFiltersIntegration(),
        functionToStringIntegration(),
        linkedErrorsIntegration(),
        consoleIntegration(),
        nativeNodeFetchIntegration(),
        onUncaughtExceptionIntegration(),
        onUnhandledRejectionIntegration(),
    ];
    return integrations;
}
/**
 * Initialize Sentry in the Electron main process
 */
function init(userOptions = {}) {
    const optionsWithDefaults = {
        defaultIntegrations: getDefaultIntegrations(),
        transport: makeUtilityProcessTransport(),
        sendClientReports: false,
        ...userOptions,
        stackParser: stackParserFromStackParserOptions(userOptions.stackParser || defaultStackParser),
        // Events are sent via the main process but the Node SDK wont start without dsn
        dsn: 'https://12345@dummy.dsn/12345',
        includeServerName: false,
    };
    const options = {
        ...optionsWithDefaults,
        integrations: getIntegrationsToSetup(optionsWithDefaults),
    };
    if (options.debug) {
        debug.enable();
    }
    setNodeAsyncContextStrategy();
    const scope = getCurrentScope();
    scope.update(options.initialScope);
    const client = new NodeClient(options);
    scope.setClient(client);
    client.init();
    // If users opt-out of this, they _have_ to set up OpenTelemetry themselves
    // There is no way to use this SDK without OpenTelemetry!
    if (!options.skipOpenTelemetrySetup) {
        initOpenTelemetry(client);
    }
}

export { defaultStackParser, getDefaultIntegrations, init };//# sourceMappingURL=http://go/sourcemap/sourcemaps/a86689c93e9fb11addfbefd29a6ec7c0a59175e0/node_modules/@sentry/electron/esm/utility/sdk.js.map
