"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.scheduleArray = void 0;
const Observable_js_1 = require("../Observable.js");
const executeSchedule_js_1 = require("../util/executeSchedule.js");
function scheduleArray(input, scheduler) {
    return new Observable_js_1.Observable((subscriber) => {
        let i = 0;
        const emit = () => {
            if (i === input.length) {
                subscriber.complete();
            }
            else {
                subscriber.next(input[i++]);
                (0, executeSchedule_js_1.executeSchedule)(subscriber, scheduler, emit);
            }
        };
        return (0, executeSchedule_js_1.executeSchedule)(subscriber, scheduler, emit);
    });
}
exports.scheduleArray = scheduleArray;//# sourceMappingURL=http://go/sourcemap/sourcemaps/a86689c93e9fb11addfbefd29a6ec7c0a59175e0/node_modules/rxjs/dist/cjs/internal/scheduled/scheduleArray.js.map