"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.raceInit = exports.race = void 0;
const Observable_js_1 = require("../Observable.js");
const argsOrArgArray_js_1 = require("../util/argsOrArgArray.js");
function race(...sources) {
    sources = (0, argsOrArgArray_js_1.argsOrArgArray)(sources);
    return sources.length === 1 ? (0, Observable_js_1.from)(sources[0]) : new Observable_js_1.Observable(raceInit(sources));
}
exports.race = race;
function raceInit(sources) {
    return (destination) => {
        let subscriptions = [];
        for (let i = 0; subscriptions && !destination.closed && i < sources.length; i++) {
            subscriptions.push((0, Observable_js_1.from)(sources[i]).subscribe((0, Observable_js_1.operate)({
                destination,
                next: (value) => {
                    if (subscriptions) {
                        for (let s = 0; s < subscriptions.length; s++) {
                            s !== i && subscriptions[s].unsubscribe();
                        }
                        subscriptions = null;
                    }
                    destination.next(value);
                },
            })));
        }
    };
}
exports.raceInit = raceInit;//# sourceMappingURL=http://go/sourcemap/sourcemaps/a86689c93e9fb11addfbefd29a6ec7c0a59175e0/node_modules/rxjs/dist/cjs/internal/observable/race.js.map