Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const exports$1 = require('./logs/exports.js');
const index = require('./integrations/http/index.js');
const httpServerSpansIntegration = require('./integrations/http/httpServerSpansIntegration.js');
const httpServerIntegration = require('./integrations/http/httpServerIntegration.js');
const SentryHttpInstrumentation = require('./integrations/http/SentryHttpInstrumentation.js');
const index$1 = require('./integrations/node-fetch/index.js');
const SentryNodeFetchInstrumentation = require('./integrations/node-fetch/SentryNodeFetchInstrumentation.js');
const context = require('./integrations/context.js');
const contextlines = require('./integrations/contextlines.js');
const index$2 = require('./integrations/local-variables/index.js');
const modules = require('./integrations/modules.js');
const onuncaughtexception = require('./integrations/onuncaughtexception.js');
const onunhandledrejection = require('./integrations/onunhandledrejection.js');
const index$3 = require('./integrations/anr/index.js');
const spotlight = require('./integrations/spotlight.js');
const systemError = require('./integrations/systemError.js');
const childProcess = require('./integrations/childProcess.js');
const winston = require('./integrations/winston.js');
const pino = require('./integrations/pino.js');
const contextManager = require('./otel/contextManager.js');
const logger = require('./otel/logger.js');
const instrument = require('./otel/instrument.js');
const index$4 = require('./sdk/index.js');
const scope = require('./sdk/scope.js');
const api = require('./sdk/api.js');
const module$1 = require('./utils/module.js');
const addOriginToSpan = require('./utils/addOriginToSpan.js');
const getRequestUrl = require('./utils/getRequestUrl.js');
const esmLoader = require('./sdk/esmLoader.js');
const detection = require('./utils/detection.js');
const ensureIsWrapped = require('./utils/ensureIsWrapped.js');
const createMissingInstrumentationContext = require('./utils/createMissingInstrumentationContext.js');
const envToBool = require('./utils/envToBool.js');
const http = require('./transports/http.js');
const client = require('./sdk/client.js');
const index$5 = require('./cron/index.js');
const nodeVersion = require('./nodeVersion.js');
const opentelemetry = require('@sentry/opentelemetry');
const core = require('@sentry/core');



exports.logger = exports$1;
exports.httpIntegration = index.httpIntegration;
exports.httpServerSpansIntegration = httpServerSpansIntegration.httpServerSpansIntegration;
exports.httpServerIntegration = httpServerIntegration.httpServerIntegration;
exports.SentryHttpInstrumentation = SentryHttpInstrumentation.SentryHttpInstrumentation;
exports.nativeNodeFetchIntegration = index$1.nativeNodeFetchIntegration;
exports.SentryNodeFetchInstrumentation = SentryNodeFetchInstrumentation.SentryNodeFetchInstrumentation;
exports.nodeContextIntegration = context.nodeContextIntegration;
exports.contextLinesIntegration = contextlines.contextLinesIntegration;
exports.localVariablesIntegration = index$2.localVariablesIntegration;
exports.modulesIntegration = modules.modulesIntegration;
exports.onUncaughtExceptionIntegration = onuncaughtexception.onUncaughtExceptionIntegration;
exports.onUnhandledRejectionIntegration = onunhandledrejection.onUnhandledRejectionIntegration;
exports.anrIntegration = index$3.anrIntegration;
exports.disableAnrDetectionForCallback = index$3.disableAnrDetectionForCallback;
exports.spotlightIntegration = spotlight.spotlightIntegration;
exports.systemErrorIntegration = systemError.systemErrorIntegration;
exports.childProcessIntegration = childProcess.childProcessIntegration;
exports.createSentryWinstonTransport = winston.createSentryWinstonTransport;
exports.pinoIntegration = pino.pinoIntegration;
exports.SentryContextManager = contextManager.SentryContextManager;
exports.setupOpenTelemetryLogger = logger.setupOpenTelemetryLogger;
exports.INSTRUMENTED = instrument.INSTRUMENTED;
exports.generateInstrumentOnce = instrument.generateInstrumentOnce;
exports.instrumentWhenWrapped = instrument.instrumentWhenWrapped;
exports.getDefaultIntegrations = index$4.getDefaultIntegrations;
exports.init = index$4.init;
exports.initWithoutDefaultIntegrations = index$4.initWithoutDefaultIntegrations;
exports.validateOpenTelemetrySetup = index$4.validateOpenTelemetrySetup;
exports.setIsolationScope = scope.setIsolationScope;
exports.defaultStackParser = api.defaultStackParser;
exports.getSentryRelease = api.getSentryRelease;
exports.createGetModuleFromFilename = module$1.createGetModuleFromFilename;
exports.addOriginToSpan = addOriginToSpan.addOriginToSpan;
exports.getRequestUrl = getRequestUrl.getRequestUrl;
exports.initializeEsmLoader = esmLoader.initializeEsmLoader;
exports.isCjs = detection.isCjs;
exports.ensureIsWrapped = ensureIsWrapped.ensureIsWrapped;
exports.createMissingInstrumentationContext = createMissingInstrumentationContext.createMissingInstrumentationContext;
exports.envToBool = envToBool.envToBool;
exports.makeNodeTransport = http.makeNodeTransport;
exports.NodeClient = client.NodeClient;
exports.cron = index$5.cron;
exports.NODE_VERSION = nodeVersion.NODE_VERSION;
exports.setNodeAsyncContextStrategy = opentelemetry.setOpenTelemetryContextAsyncContextStrategy;
exports.SDK_VERSION = core.SDK_VERSION;
exports.SEMANTIC_ATTRIBUTE_SENTRY_OP = core.SEMANTIC_ATTRIBUTE_SENTRY_OP;
exports.SEMANTIC_ATTRIBUTE_SENTRY_ORIGIN = core.SEMANTIC_ATTRIBUTE_SENTRY_ORIGIN;
exports.SEMANTIC_ATTRIBUTE_SENTRY_SAMPLE_RATE = core.SEMANTIC_ATTRIBUTE_SENTRY_SAMPLE_RATE;
exports.SEMANTIC_ATTRIBUTE_SENTRY_SOURCE = core.SEMANTIC_ATTRIBUTE_SENTRY_SOURCE;
exports.Scope = core.Scope;
exports.addBreadcrumb = core.addBreadcrumb;
exports.addEventProcessor = core.addEventProcessor;
exports.addIntegration = core.addIntegration;
exports.captureCheckIn = core.captureCheckIn;
exports.captureConsoleIntegration = core.captureConsoleIntegration;
exports.captureEvent = core.captureEvent;
exports.captureException = core.captureException;
exports.captureFeedback = core.captureFeedback;
exports.captureMessage = core.captureMessage;
exports.captureSession = core.captureSession;
exports.close = core.close;
exports.consoleIntegration = core.consoleIntegration;
exports.consoleLoggingIntegration = core.consoleLoggingIntegration;
exports.continueTrace = core.continueTrace;
exports.createConsolaReporter = core.createConsolaReporter;
exports.createTransport = core.createTransport;
exports.dedupeIntegration = core.dedupeIntegration;
exports.endSession = core.endSession;
exports.eventFiltersIntegration = core.eventFiltersIntegration;
exports.extraErrorDataIntegration = core.extraErrorDataIntegration;
exports.featureFlagsIntegration = core.featureFlagsIntegration;
exports.flush = core.flush;
exports.functionToStringIntegration = core.functionToStringIntegration;
exports.getActiveSpan = core.getActiveSpan;
exports.getClient = core.getClient;
exports.getCurrentScope = core.getCurrentScope;
exports.getGlobalScope = core.getGlobalScope;
exports.getIsolationScope = core.getIsolationScope;
exports.getRootSpan = core.getRootSpan;
exports.getSpanDescendants = core.getSpanDescendants;
exports.getSpanStatusFromHttpCode = core.getSpanStatusFromHttpCode;
exports.getTraceData = core.getTraceData;
exports.getTraceMetaTags = core.getTraceMetaTags;
exports.inboundFiltersIntegration = core.inboundFiltersIntegration;
exports.instrumentSupabaseClient = core.instrumentSupabaseClient;
exports.isEnabled = core.isEnabled;
exports.isInitialized = core.isInitialized;
exports.lastEventId = core.lastEventId;
exports.linkedErrorsIntegration = core.linkedErrorsIntegration;
exports.metrics = core.metrics;
exports.parameterize = core.parameterize;
exports.profiler = core.profiler;
exports.requestDataIntegration = core.requestDataIntegration;
exports.rewriteFramesIntegration = core.rewriteFramesIntegration;
exports.setContext = core.setContext;
exports.setCurrentClient = core.setCurrentClient;
exports.setExtra = core.setExtra;
exports.setExtras = core.setExtras;
exports.setHttpStatus = core.setHttpStatus;
exports.setMeasurement = core.setMeasurement;
exports.setTag = core.setTag;
exports.setTags = core.setTags;
exports.setUser = core.setUser;
exports.spanToBaggageHeader = core.spanToBaggageHeader;
exports.spanToJSON = core.spanToJSON;
exports.spanToTraceHeader = core.spanToTraceHeader;
exports.startInactiveSpan = core.startInactiveSpan;
exports.startNewTrace = core.startNewTrace;
exports.startSession = core.startSession;
exports.startSpan = core.startSpan;
exports.startSpanManual = core.startSpanManual;
exports.supabaseIntegration = core.supabaseIntegration;
exports.suppressTracing = core.suppressTracing;
exports.trpcMiddleware = core.trpcMiddleware;
exports.updateSpanName = core.updateSpanName;
exports.withActiveSpan = core.withActiveSpan;
exports.withIsolationScope = core.withIsolationScope;
exports.withMonitor = core.withMonitor;
exports.withScope = core.withScope;
exports.wrapMcpServerWithSentry = core.wrapMcpServerWithSentry;
exports.zodErrorsIntegration = core.zodErrorsIntegration;//# sourceMappingURL=http://go/sourcemap/sourcemaps/a86689c93e9fb11addfbefd29a6ec7c0a59175e0/node_modules/@sentry/node-core/build/cjs/index.js.map
