"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.pairwise = void 0;
const Observable_js_1 = require("../Observable.js");
function pairwise() {
    return (source) => new Observable_js_1.Observable((destination) => {
        let prev;
        let hasPrev = false;
        source.subscribe((0, Observable_js_1.operate)({
            destination,
            next: (value) => {
                const p = prev;
                prev = value;
                hasPrev && destination.next([p, value]);
                hasPrev = true;
            },
        }));
    });
}
exports.pairwise = pairwise;//# sourceMappingURL=http://go/sourcemap/sourcemaps/b3573281c4775bfc6bba466bf6563d3d498d1070/node_modules/rxjs/dist/cjs/internal/operators/pairwise.js.map