"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.bufferTextMapGetter = void 0;
/*
same as open telemetry's `defaultTextMapGetter`,
but also handle case where header is buffer,
adding toString() to make sure string is returned
*/
exports.bufferTextMapGetter = {
    get(carrier, key) {
        if (!carrier) {
            return undefined;
        }
        const keys = Object.keys(carrier);
        for (const carrierKey of keys) {
            if (carrierKey === key || carrierKey.toLowerCase() === key) {
                return carrier[carrierKey]?.toString();
            }
        }
        return undefined;
    },
    keys(carrier) {
        return carrier ? Object.keys(carrier) : [];
    },
};//# sourceMappingURL=http://go/sourcemap/sourcemaps/b3573281c4775bfc6bba466bf6563d3d498d1070/node_modules/@opentelemetry/instrumentation-kafkajs/build/src/propagator.js.map