/* global crypto */
import { from } from './hasher.js';
function sha(name) {
    return async (data) => new Uint8Array(await crypto.subtle.digest(name, data));
}
export const sha256 = from({
    name: 'sha2-256',
    code: 0x12,
    encode: sha('SHA-256')
});
export const sha512 = from({
    name: 'sha2-512',
    code: 0x13,
    encode: sha('SHA-512')
});//# sourceMappingURL=http://go/sourcemap/sourcemaps/cf858ca030e9c9a99ea444ec6efcbcfc40bfda70/node_modules/multiformats/dist/src/hashes/sha2-browser.js.map