const core = require('@sentry/core');
const ipc = require('../ipc.js');

const eventLoopBlockIntegration = core.defineIntegration((options) => {
    const anrThreshold = options?.threshold ?? 1000;
    const pollInterval = options?.pollInterval || anrThreshold / 2;
    return {
        name: 'EventLoopBlockRenderer',
        setup(client) {
            const config = {
                pollInterval,
                anrThreshold,
                captureStackTrace: true,
                ...options,
            };
            const ipc$1 = ipc.getIPC(client);
            // eslint-disable-next-line no-restricted-globals
            ipc$1.sendStatus({ status: document.visibilityState, config });
            setInterval(() => {
                ipc$1.sendStatus({ status: 'alive', config });
            }, config.pollInterval);
        },
    };
});

exports.eventLoopBlockIntegration = eventLoopBlockIntegration;//# sourceMappingURL=http://go/sourcemap/sourcemaps/1685afce45886aa5579025ac7e077fc3d4369c50/node_modules/@sentry/electron/renderer/integrations/event-loop-block.js.map
