import { Observable, operate, from } from '../Observable.js';
import { noop } from '../util/noop.js';
export function distinct(keySelector, flushes) {
    return (source) => new Observable((destination) => {
        const distinctKeys = new Set();
        source.subscribe(operate({
            destination,
            next: (value) => {
                const key = keySelector ? keySelector(value) : value;
                if (!distinctKeys.has(key)) {
                    distinctKeys.add(key);
                    destination.next(value);
                }
            },
        }));
        flushes && from(flushes).subscribe(operate({ destination, next: () => distinctKeys.clear(), complete: noop }));
    });
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/56f0a83df8e9eb48585fcc4858a9440db4cc7770/node_modules/rxjs/dist/esm/internal/operators/distinct.js.map