import { Subscription } from '../Observable.js';
export const animationFrameProvider = {
    schedule(callback) {
        let request = requestAnimationFrame;
        let cancel = cancelAnimationFrame;
        const { delegate } = animationFrameProvider;
        if (delegate) {
            request = delegate.requestAnimationFrame;
            cancel = delegate.cancelAnimationFrame;
        }
        const handle = request((timestamp) => {
            cancel = undefined;
            callback(timestamp);
        });
        return new Subscription(() => cancel?.(handle));
    },
    requestAnimationFrame(...args) {
        const { delegate } = animationFrameProvider;
        return (delegate?.requestAnimationFrame || requestAnimationFrame)(...args);
    },
    cancelAnimationFrame(...args) {
        const { delegate } = animationFrameProvider;
        return (delegate?.cancelAnimationFrame || cancelAnimationFrame)(...args);
    },
    delegate: undefined,
};//# sourceMappingURL=http://go/sourcemap/sourcemaps/56f0a83df8e9eb48585fcc4858a9440db4cc7770/node_modules/rxjs/dist/esm/internal/scheduler/animationFrameProvider.js.map