import { Observable, operate, from } from '../Observable.js';
import { noop } from '../util/noop.js';
export function skipUntil(notifier) {
    return (source) => new Observable((destination) => {
        let taking = false;
        const skipSubscriber = operate({
            destination,
            next: () => {
                skipSubscriber?.unsubscribe();
                taking = true;
            },
            complete: noop,
        });
        from(notifier).subscribe(skipSubscriber);
        source.subscribe(operate({ destination, next: (value) => taking && destination.next(value) }));
    });
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/56f0a83df8e9eb48585fcc4858a9440db4cc7770/node_modules/rxjs/dist/esm/internal/operators/skipUntil.js.map